/*======================================*/
/* 	_Vol2HTML:                      */
/*======================================*/

Func      = arg(1);  /* [ INIT | DETAIL | CLOSE ]        */
Data      = arg(2);
VolID     = arg(3);
VolName   = arg(4);
Artist    = arg(5);
Jahr      = arg(6);
MediaType = arg(7);

INIFile  = "CDMagic.ini";
BMPPath  = SysINI(INIFile, "Settings", "BMPPath");
TSN_Ext  = "TSN";

/* ===== These constants may be changed by you: ========== */

OutFile  = "MyVolumes.html";
Num_VolPerPage = 20;

/* ===== From here on program logic SHOULD BE CHANGED WITH CARE! ================ */

If Func = "INIT"   then do;Data = _Vol2HTML_INIT();   return Data; end;
If Func = "DETAIL" then do;Data = _Vol2HTML_DETAIL(); return Data; end;
If Func = "CLOSE"  then do;Data = _Vol2HTML_CLOSE();  return Data; end;

return "invalid function-code "arg(1);

===================================
_Vol2HTML_INIT:

ok = SysFileDelete(OutFile);

Act_VolPerPage =  0;
NumRecords     =  0;

/* ------------------		*/
/* Write List-Header:		*/
/* ------------------		*/
i=1;
HTML.i = "<html>";							i=i+1;
HTML.i = "<style>";							i=i+1;
HTML.i = "td.PageHdr  {font-size:10pt;font-weight:bold;color:white;background-color:blue;}";		i=i+1;
HTML.i = "td          {font-size:10pt;font-weight:normal;}";		i=i+1;
HTML.i = "</style>";							i=i+1;
HTML.i = "<body>";							i=i+1;
HTML.i = "<h1>List of my Music (CD's + LP's):</h1>";			i=i+1;
HTML.i = "<table border=1 cellspacing=0 cellpadding=6 width='99%'>";	i=i+1;
HTML.0 = i-1;
Call Write_HTML;

StartTime = time("E");
ok = beep(311,232);

Call DoThe_PageHeader;

RETURN ,
    " "||PadZero(Act_VolPerPage,2)  ,
  ||" "||PadZero(NumRecords,6)      ;

===================================
_Vol2HTML_DETAIL:
Act_VolPerPage = substr(Data,02,02);
NumRecords     = substr(Data,05,06);

      if Act_VolPerPage > Num_VolPerPage then do
         /* Seite voll: Seitenwechsel:	*/
	 Call DoThe_PageHeader;
      end;
      Act_VolPerPage = Act_VolPerPage +1;

      NumRecords = NumRecords + 1;

      /* ---------------------			*/
      /* Do the single volume:			*/
      /* ---------------------			*/

      /* Cover vorhanden?			*/

      TSN_FileSpec = ZBuildCoverID(VolID,1,"IMG");
      ok = SysFileTree(TSN_FileSpec, "files.", "FB");

      if files.0 > 0 then do
         Img_Name = filespec("name",files.1);
         Img_Name = left(Img_Name, pos(".",Img_Name)-1);

         Img_Name = translate(Img_Name,"_","#");    /* kill http-schdliches Sonderzeichen  */

         CoverLink = "<a href='cdm/covers/"Img_Name".gif'>"Img_Name"</a>";
      end;
      else;
         CoverLink = "&nbsp;";

      if strip(Jahr) = "" then
         Jahr = "&nbsp;";

      i = 1;
      HTML.i = "<tr>";		                     i=i+1;
      HTML.i = "<td>"Strip(Artist)"</td>";	              i=i+1;
      HTML.i = "<td>"Strip(VolName)"</td>";	       i=i+1;
      HTML.i = "<td>"TranslateMedia(MediaType)"</td>";	i=i+1;
      HTML.i = "<td>"Jahr"</td>";		              i=i+1;
      HTML.i = "<td>"CoverLink"</td>";			i=i+1;
      HTML.i = "</tr>";					i=i+1;
      HTML.0 = i-1;

      Call Write_HTML;

RETURN ,
    " "||PadZero(Act_VolPerPage,2)  ,
  ||" "||PadZero(NumRecords,6)      ;

===================================
_Vol2HTML_CLOSE:
Act_VolPerPage = substr(Data,02,02);
NumRecords     = substr(Data,05,06);

/* -------------------		*/
/* Write List-Trailer:		*/
/* -------------------		*/
i=1;
HTML.i = "</table>";	i=i+1;
HTML.i = "</body>";	i=i+1;
HTML.i = "</html>";	i=i+1;
HTML.0 = i-1;
Call Write_HTML;

ok = beep(211,188);
RETURN 0;

---------------------------

DoThe_PageHeader:
i=1;
HTML.i = "<tr>";			i=i+1;
HTML.i = "<td class='PageHdr'><b><br>Artist:</b></td>";	i=i+1;
HTML.i = "<td class='PageHdr'><b><br>Name:</b></td>";	i=i+1;
HTML.i = "<td class='PageHdr'><b><br>Media:</b></td>";	i=i+1;
HTML.i = "<td class='PageHdr'><b><br>Year:</b></td>";	i=i+1;
HTML.i = "<td class='PageHdr'><b><br>Cover:</b></td>";	i=i+1;
HTML.i = "</tr>";			i=i+1;
HTML.0 = i-1;

Call Write_HTML;

Act_VolPerPage = 0;
return 0;

---------------------------

Write_HTML:
do i = 1 to HTML.0
   ok = LineOut(OutFile, HTML.i);
end;
return 0;

/* --------------------------------------------------      */
/* bersetzen MediaType in Klartext:			   */
/* --------------------------------------------------      */
TranslateMedia: procedure
Media = arg(1);

if Media = 1 then return "LP";
if Media = 2 then return "CD";
if Media = 3 then return "Cass";
if Media = 4 then return "Tape";
if Media = 5 then return "Import";
if Media = 6 then return "Single";

return "wrong media";

/* --------------------------------------------------      */
/* Auffllen links Zahl mit fhrenden Nullen:              */
/* --------------------------------------------------      */
PadZero: procedure
    What = arg(1);
    Leng = arg(2);
    return left("0", Leng-length(What), "0")||What;

/* --------------------------------------------------      */
/* Liefert Name des Cover-Images                           */
/* --------------------------------------------------      */
ZBuildCoverID: procedure Expose     ,
                            BMPPath ,
                            TSN_Ext; 
VolID = arg(1);
Pageno= arg(2);		/* opt. (bei 'IMG' )	*/
What  = arg(3);		/* { 'TSN' | 'IMG' }	*/

Stem = BMPPath"\"||"CV"padzero(VolID,4);

if What = "TSN" then		/* CV0081.TSN		*/
   return Stem||"."TSN_Ext;

if What = "IMG" then    	/* CV0081#1.BMP	*/
   return Stem||"#"Pageno||".BMP";

return "PGM-Error: invalid 'What' in 'ZBuildCoverID'";

