/*
 * Decompiled with CFR 0.152.
 */
package boplanets.gui;

import boplanets.gui.CoordinateSystem;
import boplanets.gui.EclipticSystem;
import boplanets.gui.EquatorSystem;
import boplanets.gui.HorizontSystem;
import boplanets.gui.LogEclipticSystem;
import boplanets.gui.PnlOrbitalParameters;
import boplanets.planetSystem.Planet;
import boplanets.planetSystem.Planets;
import boplanets.util.CalUtil;
import boplanets.util.NumberConverter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.VolatileImage;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PlanetsPanel
extends JPanel
implements Runnable {
    private JButton btnStepSizeOk;
    private JLabel lblElapsedTime;
    private JLabel lblStepSize;
    private JMenuItem mitClearScreen;
    private JMenuItem mitStart;
    private JMenuItem mitStop;
    private JPanel pnlControl;
    private JPopupMenu popActions;
    private JSlider sldSpeed;
    private JTextField txtElapsedTime;
    private JTextField txtGmtDateTime;
    private JTextField txtLocalDateTime;
    private JTextField txtStepSize;
    private static final double MAX_STEPSIZE = 146102.56;
    private static final double MIN_STEPSIZE = 1.0E-4;
    private static final int STEPSIZE_PREC = 10000;
    private static final int STEPS_ELAPSED_TIME = 365;
    private static final int DELAY_SINGLE_STEP_MS = 120;
    private static final int MAX_DELAY_CONT = 50;
    private static final int MIN_DELAY_CONT = 2;
    private final GregorianCalendar LOCAL_CALENDAR = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
    private String _localPattern;
    private SimpleDateFormat _sdfLocalFormat;
    private ArrayList<double[]> _arrPlanetPositions;
    private int _pnlWidth;
    private int _pnlHeight;
    private int _iNoPlanets;
    private Planet[] _arrPlanets;
    private Planet _objObserver;
    private CoordinateSystem _coordSystem;
    private long _lActualDate;
    private long _lStepSize;
    private Image _imgObserver;
    private int _centerX;
    private int _centerY;
    private double _scaleFactorX;
    private double _scaleFactorY;
    private double _markValueX;
    private double _markValueY;
    private VolatileImage _img = null;
    private Graphics2D _imgGraphics;
    private boolean _paintActivatedByPlanets = false;
    private volatile AtomicReference<PnlOrbitalParameters> _stepCompleteListener = new AtomicReference<Object>(null);
    private Thread _threadRunPlanets = null;
    private int _delayContinousMs;
    private boolean _withRadiusVector;
    private boolean _bLogScaling;
    private int _iAbsciss = 0;
    private int _iOrdinate = 1;
    private boolean _bStepwise;
    private int _threadDelayMs;
    private int _timeDir;
    private double _dblStepSize;
    private double _lastStepSizeNotHorizontal;
    private double _latitudeObs;
    private double _longitudeObs;
    private int _iTimeZoneObs;
    private long _lTimeZoneOffsetObs;

    public PlanetsPanel(int n, int n2, int n3, int[] nArray) {
        this._pnlWidth = n;
        this._pnlHeight = n2;
        this.initComponents();
        this._arrPlanets = Planets.initAllPlanets(n3, nArray);
        this._iNoPlanets = this._arrPlanets.length - 1;
        this._objObserver = this._arrPlanets[this._iNoPlanets];
        this._imgObserver = this._objObserver.imgPlanet;
        long l = CalUtil.REF_DATE_J2000;
        this._lActualDate = System.currentTimeMillis();
        this._lStepSize = this._lActualDate - l;
        this.txtGmtDateTime.setText(CalUtil.formatGmtDate(this._lActualDate));
        this._bLogScaling = true;
        this._coordSystem = new LogEclipticSystem(this._arrPlanets, this._iAbsciss, this._iOrdinate);
        double d = (double)this._lStepSize / 8.64E7;
        this._arrPlanetPositions = this.nextStep(this._coordSystem, d);
        this._dblStepSize = 2.0;
        this._lastStepSizeNotHorizontal = 2.0;
        this._timeDir = 1;
        String string = NumberConverter.format(this._dblStepSize);
        this.txtStepSize.setText(string);
        this._bStepwise = true;
        this.txtLocalDateTime.setVisible(false);
        this.txtElapsedTime.setEnabled(false);
        this.sldSpeed.setVisible(false);
        this.setDrawContext(n, n2);
        this.mitStart.setEnabled(false);
        this.mitStop.setEnabled(false);
        double d2 = (1.0 - (double)this.sldSpeed.getValue() / (double)(this.sldSpeed.getMaximum() - this.sldSpeed.getMinimum())) * 48.0;
        this._delayContinousMs = (int)Math.floor(d2 + 0.5) + 2;
    }

    private void initComponents() {
        this.popActions = new JPopupMenu();
        this.mitClearScreen = new JMenuItem();
        this.mitStart = new JMenuItem();
        this.mitStop = new JMenuItem();
        this.pnlControl = new JPanel();
        this.lblStepSize = new JLabel();
        this.txtStepSize = new JTextField();
        this.btnStepSizeOk = new JButton();
        this.sldSpeed = new JSlider();
        this.lblElapsedTime = new JLabel();
        this.txtElapsedTime = new JTextField();
        this.txtGmtDateTime = new JTextField();
        this.txtLocalDateTime = new JTextField();
        this.popActions.setFont(new Font("Arial", 0, 11));
        this.mitClearScreen.setFont(new Font("Arial", 0, 11));
        this.mitClearScreen.setText("clear screen");
        this.mitClearScreen.setToolTipText("clear the screen,show the actual positions.");
        this.mitClearScreen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PlanetsPanel.this.mitClearScreen_ActionPerformed(actionEvent);
            }
        });
        this.popActions.add(this.mitClearScreen);
        this.mitStart.setFont(new Font("Arial", 0, 11));
        this.mitStart.setText("start planets");
        this.mitStart.setToolTipText("start the planets in run mode continous.");
        this.mitStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PlanetsPanel.this.mitStart_ActionPerformed(actionEvent);
            }
        });
        this.popActions.add(this.mitStart);
        this.mitStop.setFont(new Font("Arial", 0, 11));
        this.mitStop.setText("stop planets");
        this.mitStop.setToolTipText("stop the continously running planets.");
        this.mitStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PlanetsPanel.this.mitStop_ActionPerformed(actionEvent);
            }
        });
        this.popActions.add(this.mitStop);
        this.setToolTipText("click or press left mouse to move the planets. Click right mouse for context menu.");
        this.setFont(new Font("Arial", 0, 11));
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(this._pnlWidth, this._pnlHeight));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                PlanetsPanel.this.PlanetsPanel_MousePressed(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                PlanetsPanel.this.PlanetsPanel_MouseReleased(mouseEvent);
            }
        });
        this.setLayout(new FlowLayout(0, 1, 1));
        this.pnlControl.setDoubleBuffered(false);
        this.pnlControl.setFont(new Font("Arial", 0, 10));
        this.pnlControl.setPreferredSize(new Dimension(810, 22));
        this.pnlControl.setLayout(new FlowLayout(0, 2, 0));
        this.lblStepSize.setFont(new Font("Arial", 0, 10));
        this.lblStepSize.setHorizontalAlignment(4);
        this.lblStepSize.setText("stepsize:");
        this.lblStepSize.setToolTipText("enter stepsize and click ok");
        this.lblStepSize.setPreferredSize(new Dimension(40, 20));
        this.pnlControl.add(this.lblStepSize);
        this.txtStepSize.setFont(new Font("Arial", 0, 10));
        this.txtStepSize.setHorizontalAlignment(4);
        this.txtStepSize.setToolTipText("stepsize in earth days: 0.0001 <= stepsize < =400*365.2564=146102,56\n");
        this.txtStepSize.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("CheckBoxMenuItem.selectionBackground")));
        this.txtStepSize.setPreferredSize(new Dimension(50, 20));
        this.txtStepSize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PlanetsPanel.this.txtStepSize_ActionPerformed(actionEvent);
            }
        });
        this.pnlControl.add(this.txtStepSize);
        this.btnStepSizeOk.setFont(new Font("Arial", 0, 10));
        this.btnStepSizeOk.setText("OK");
        this.btnStepSizeOk.setToolTipText("finishes entering new stepsiz");
        this.btnStepSizeOk.setBorder(new SoftBevelBorder(0));
        this.btnStepSizeOk.setOpaque(false);
        this.btnStepSizeOk.setPreferredSize(new Dimension(40, 20));
        this.btnStepSizeOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PlanetsPanel.this.btnStepSizeOk_ActionPerformed(actionEvent);
            }
        });
        this.pnlControl.add(this.btnStepSizeOk);
        this.sldSpeed.setFont(new Font("Arial", 0, 10));
        this.sldSpeed.setMajorTickSpacing(10);
        this.sldSpeed.setMinorTickSpacing(2);
        this.sldSpeed.setPaintLabels(true);
        this.sldSpeed.setPaintTicks(true);
        this.sldSpeed.setSnapToTicks(true);
        this.sldSpeed.setToolTipText("speed down <-> up");
        this.sldSpeed.setValue(80);
        this.sldSpeed.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("CheckBoxMenuItem.selectionBackground")));
        this.sldSpeed.setPreferredSize(new Dimension(200, 20));
        this.sldSpeed.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                PlanetsPanel.this.sldSpeed_StateChanged(changeEvent);
            }
        });
        this.pnlControl.add(this.sldSpeed);
        this.lblElapsedTime.setFont(new Font("Arial", 0, 10));
        this.lblElapsedTime.setHorizontalAlignment(4);
        this.lblElapsedTime.setText("elapsed msecs:");
        this.lblElapsedTime.setPreferredSize(new Dimension(72, 20));
        this.pnlControl.add(this.lblElapsedTime);
        this.txtElapsedTime.setEditable(false);
        this.txtElapsedTime.setFont(new Font("Arial", 0, 10));
        this.txtElapsedTime.setHorizontalAlignment(4);
        this.txtElapsedTime.setToolTipText("elapsed time of 365 steps in msecs in continous mode");
        this.txtElapsedTime.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("CheckBoxMenuItem.selectionBackground")));
        this.txtElapsedTime.setEnabled(false);
        this.txtElapsedTime.setPreferredSize(new Dimension(34, 20));
        this.pnlControl.add(this.txtElapsedTime);
        this.txtGmtDateTime.setEditable(false);
        this.txtGmtDateTime.setFont(new Font("Arial", 0, 10));
        this.txtGmtDateTime.setHorizontalAlignment(4);
        this.txtGmtDateTime.setToolTipText("Greenwich Mean Time");
        this.txtGmtDateTime.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("CheckBoxMenuItem.selectionBackground")));
        this.txtGmtDateTime.setFocusable(false);
        this.txtGmtDateTime.setPreferredSize(new Dimension(175, 20));
        this.pnlControl.add(this.txtGmtDateTime);
        this.txtLocalDateTime.setEditable(false);
        this.txtLocalDateTime.setFont(new Font("Arial", 0, 10));
        this.txtLocalDateTime.setHorizontalAlignment(4);
        this.txtLocalDateTime.setToolTipText("local time at time zone of observer;TZ=no of timezone");
        this.txtLocalDateTime.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("CheckBoxMenuItem.selectionBackground")));
        this.txtLocalDateTime.setFocusable(false);
        this.txtLocalDateTime.setPreferredSize(new Dimension(180, 20));
        this.pnlControl.add(this.txtLocalDateTime);
        this.add(this.pnlControl);
    }

    private void sldSpeed_StateChanged(ChangeEvent changeEvent) {
        JSlider jSlider = (JSlider)changeEvent.getSource();
        if (!jSlider.getValueIsAdjusting()) {
            double d = (1.0 - (double)this.sldSpeed.getValue() / (double)(this.sldSpeed.getMaximum() - this.sldSpeed.getMinimum())) * 48.0;
            this._threadDelayMs = this._delayContinousMs = (int)Math.floor(d + 0.5) + 2;
        }
    }

    private void btnStepSizeOk_ActionPerformed(ActionEvent actionEvent) {
        this.txtStepSizeReady();
    }

    private void mitStop_ActionPerformed(ActionEvent actionEvent) {
        if (this._threadRunPlanets != null) {
            this._threadRunPlanets.interrupt();
        }
        this.mitStart.setEnabled(true);
        this.mitStop.setEnabled(false);
    }

    private void mitStart_ActionPerformed(ActionEvent actionEvent) {
        this.startContinousMode();
    }

    private void mitClearScreen_ActionPerformed(ActionEvent actionEvent) {
        this.initImage(this.getWidth(), this.getHeight() - this.pnlControl.getHeight());
        this.repaint();
    }

    private void PlanetsPanel_MouseReleased(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            if (this._bStepwise && this._threadRunPlanets != null) {
                this._threadRunPlanets.interrupt();
            }
        } else {
            this.popActions.show((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private void PlanetsPanel_MousePressed(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent) && this._threadRunPlanets == null) {
            if (this._bStepwise) {
                this._threadDelayMs = 120;
                this._threadRunPlanets = new Thread(this);
                this._threadRunPlanets.start();
            } else {
                this.startContinousMode();
            }
        }
    }

    private void txtStepSize_ActionPerformed(ActionEvent actionEvent) {
        this.txtStepSizeReady();
    }

    private void txtStepSizeReady() {
        String string = this.txtStepSize.getText();
        try {
            double d = NumberConverter.parse(string);
            if (d <= 146102.56 && d >= 1.0E-4) {
                this._dblStepSize = d;
                String string2 = NumberConverter.format(this._dblStepSize);
                this.txtStepSize.setText(string2);
                return;
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        Toolkit.getDefaultToolkit().beep();
        String string3 = NumberConverter.format(this._dblStepSize);
        this.txtStepSize.setText(string3);
        this.txtStepSize.requestFocusInWindow();
    }

    @Override
    public void run() {
        int n = 0;
        long l = System.currentTimeMillis();
        while (!this._threadRunPlanets.isInterrupted()) {
            this.paintNextPosition();
            ++n;
            this.signalStepComplete();
            try {
                Thread.sleep(this._threadDelayMs);
            }
            catch (InterruptedException interruptedException) {
                this._threadRunPlanets.interrupt();
                break;
            }
            if (n < 365) continue;
            long l2 = System.currentTimeMillis() - l;
            this.txtElapsedTime.setText(String.valueOf(l2));
            n = 0;
            l = System.currentTimeMillis();
        }
        this._threadRunPlanets = null;
    }

    public void registerStepCompleteListener(PnlOrbitalParameters pnlOrbitalParameters) {
        this._stepCompleteListener.set(pnlOrbitalParameters);
    }

    public void unregisterStepCompleteListener() {
        this._stepCompleteListener.set(null);
    }

    private void signalStepComplete() {
        PnlOrbitalParameters pnlOrbitalParameters = this._stepCompleteListener.get();
        if (pnlOrbitalParameters != null) {
            pnlOrbitalParameters.nextPositionCompleted();
        }
    }

    protected void paintNextPosition() {
        this._paintActivatedByPlanets = true;
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        if (this._img == null) {
            this.initImage(this.getWidth(), this.getHeight() - this.pnlControl.getHeight());
        }
        this.drawPlanets((Graphics2D)graphics);
    }

    protected void setEcliptic(int n, int n2) {
        int n3 = this._coordSystem._viewType;
        if (n3 != 0 || this._iAbsciss != n || this._iOrdinate != n2) {
            if (n3 == 3) {
                this._dblStepSize = this._lastStepSizeNotHorizontal;
            }
            this.txtStepSize.setText(NumberConverter.format(this._dblStepSize));
            this._bLogScaling = false;
            this.txtLocalDateTime.setVisible(false);
            this._iAbsciss = n;
            this._iOrdinate = n2;
            this._coordSystem = new EclipticSystem(this._arrPlanets, this._iAbsciss, this._iOrdinate);
            this.setDrawContext(this.getWidth(), this.getHeight());
            this._arrPlanetPositions = this.nextStep(this._coordSystem, 0.0);
            this.repaint();
        }
    }

    protected void setLogEcliptic(int n, int n2) {
        int n3 = this._coordSystem._viewType;
        if (n3 != 1 || this._iAbsciss != n || this._iOrdinate != n2) {
            if (n3 == 3) {
                this._dblStepSize = this._lastStepSizeNotHorizontal;
            }
            this.txtStepSize.setText(NumberConverter.format(this._dblStepSize));
            this._bLogScaling = true;
            this.txtLocalDateTime.setVisible(false);
            this._iAbsciss = n;
            this._iOrdinate = n2;
            this._coordSystem = new LogEclipticSystem(this._arrPlanets, this._iAbsciss, this._iOrdinate);
            this.setDrawContext(this.getWidth(), this.getHeight());
            this._arrPlanetPositions = this.nextStep(this._coordSystem, 0.0);
            this.repaint();
        }
    }

    protected void setEquatorial() {
        int n = this._coordSystem._viewType;
        if (n != 2) {
            if (n == 3) {
                this._dblStepSize = this._lastStepSizeNotHorizontal;
            }
            this.txtStepSize.setText(NumberConverter.format(this._dblStepSize));
            this._bLogScaling = false;
            this.txtLocalDateTime.setVisible(false);
            this._coordSystem = new EquatorSystem(this._arrPlanets);
            this.setDrawContext(this.getWidth(), this.getHeight());
            this._arrPlanetPositions = this.nextStep(this._coordSystem, 0.0);
            this.repaint();
        }
    }

    protected void setHorizontal(double d, double d2, int n) {
        double d3;
        double d4 = this._objObserver.sunDay;
        if (this._coordSystem._viewType != 3) {
            this._lastStepSizeNotHorizontal = this._dblStepSize;
            d3 = d4 / 96.0;
            this._dblStepSize = Math.floor(d3 * 10000.0) / 10000.0;
            this.txtStepSize.setText(NumberConverter.format(this._dblStepSize));
            this._bLogScaling = false;
            this.txtLocalDateTime.setVisible(true);
            this._coordSystem = new HorizontSystem(this._arrPlanets, d, d2);
        } else {
            if (this._longitudeObs == d && this._latitudeObs == d2 && this._iTimeZoneObs == n) {
                return;
            }
            ((HorizontSystem)this._coordSystem).setLongitudeAndLatitude(d, d2);
        }
        this._longitudeObs = d;
        this._latitudeObs = d2;
        this._iTimeZoneObs = n;
        d3 = d4 * (double)this._iTimeZoneObs;
        this._lTimeZoneOffsetObs = (int)(d3 * 3600000.0);
        this._localPattern = "dd.MM.yyyy HH:mm:ss G 'TZ " + String.valueOf(this._iTimeZoneObs) + "'";
        this._sdfLocalFormat = new SimpleDateFormat(this._localPattern);
        this._sdfLocalFormat.setCalendar(this.LOCAL_CALENDAR);
        this.txtLocalDateTime.setText(this.formatLocalDate(this._lActualDate));
        this.setDrawContext(this.getWidth(), this.getHeight());
        this._arrPlanetPositions = this.nextStep(this._coordSystem, 0.0);
        this.repaint();
    }

    protected void applyNewOrbParams(Planet planet, double d, double d2, double d3, double d4) {
        this.stopThread();
        planet.setOrbParameters(d, d2, d3, d4);
        if (planet.bIsObserver) {
            for (int i = 0; i < this._iNoPlanets; ++i) {
                this._arrPlanets[i].calculateMinMaxRaDecl();
            }
            this._coordSystem.setOrbParamsOfObserver(this._objObserver);
        }
        this._coordSystem.setMinMaxCoordinates(this._arrPlanets);
        this.setDrawContext(this.getWidth(), this.getHeight());
        this._arrPlanetPositions = this.nextStep(this._coordSystem, 0.0);
        this.startContinousMode();
        this.repaint();
    }

    private void startContinousMode() {
        if (this._threadRunPlanets == null && !this._bStepwise) {
            this._threadDelayMs = this._delayContinousMs;
            this.mitStop.setEnabled(true);
            this.mitStart.setEnabled(false);
            this._threadRunPlanets = new Thread(this);
            this._threadRunPlanets.start();
        }
    }

    protected void stopThread() {
        if (this._threadRunPlanets != null) {
            this._threadRunPlanets.interrupt();
            if (this._threadRunPlanets != null) {
                try {
                    this._threadRunPlanets.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    protected void setRadiusVector(boolean bl) {
        this._withRadiusVector = bl;
    }

    protected void setAxisOfEcliptic(int n, int n2) {
        if (this._coordSystem._viewType == 1) {
            this.setLogEcliptic(n, n2);
        } else {
            this.setEcliptic(n, n2);
        }
    }

    protected void setTimeForward(boolean bl) {
        this._timeDir = bl ? 1 : -1;
    }

    protected void setRunMode(boolean bl) {
        if (this._threadRunPlanets != null) {
            this._threadRunPlanets.interrupt();
        }
        this._bStepwise = bl;
        if (!this._bStepwise) {
            this.mitStart.setEnabled(true);
            this.txtElapsedTime.setEnabled(true);
            this.sldSpeed.setVisible(true);
            this.startContinousMode();
        } else {
            this.mitStart.setEnabled(false);
            this.mitStop.setEnabled(false);
            this.txtElapsedTime.setEnabled(false);
            this.sldSpeed.setVisible(false);
        }
    }

    protected Planet[] getAllPlanets() {
        return this._arrPlanets;
    }

    private void initImage(int n, int n2) {
        if (this._img != null) {
            this._img.flush();
            this._img = null;
        }
        this._img = this.createVolatileImage(n, n2);
        if (this._img != null) {
            this._imgGraphics = this._img.createGraphics();
            this._imgGraphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            this._imgGraphics.setColor(Color.GRAY);
            this._imgGraphics.fillRect(0, 0, n, n2);
            this._imgGraphics.setColor(Color.WHITE);
            this.drawCoordAxis(this._imgGraphics, n, n2, this._centerX, this._centerY, this._scaleFactorX, this._scaleFactorY, this._markValueX, this._markValueY);
            this._imgGraphics.drawImage(this._imgObserver, this._centerX - 3, this._centerY - 3, this);
        }
    }

    public void resizePanel(int n, int n2) {
        if (this._pnlWidth != n || this._pnlHeight != n2) {
            this._pnlWidth = n;
            this._pnlHeight = n2;
            this.setDrawContext(n, n2);
        }
        this.repaint();
    }

    private void drawPlanets(Graphics2D graphics2D) {
        if (this._paintActivatedByPlanets) {
            double d = (double)this._timeDir * this._dblStepSize;
            this._arrPlanetPositions = this.nextStep(this._coordSystem, d);
            this._paintActivatedByPlanets = false;
            this._lActualDate += (long)(d * 8.64E7);
            this.txtGmtDateTime.setText(CalUtil.formatGmtDate(this._lActualDate));
            if (this._coordSystem._viewType == 3) {
                this.txtLocalDateTime.setText(this.formatLocalDate(this._lActualDate));
            }
        }
        for (int i = 0; i < this._iNoPlanets; ++i) {
            double[] dArray = this._arrPlanetPositions.get(i);
            int n = (int)(dArray[0] * this._scaleFactorX) + this._centerX;
            int n2 = (int)(-dArray[1] * this._scaleFactorY) + this._centerY;
            if (this._withRadiusVector) {
                Color color = this._arrPlanets[i].cColor;
                this._imgGraphics.setColor(color);
                this._imgGraphics.setXORMode(Color.GRAY);
                this._imgGraphics.drawLine(this._centerX, this._centerY, n, n2);
                this._imgGraphics.setColor(Color.GRAY);
                this._imgGraphics.setPaintMode();
            }
            Image image = this._arrPlanets[i].imgPlanet;
            this._imgGraphics.drawImage(image, n - 3, n2 - 3, this);
        }
        graphics2D.drawImage(this._img, 0, this.pnlControl.getHeight() + 2, this);
    }

    private void setDrawContext(int n, int n2) {
        this.setVisible(false);
        int n3 = n2 - this.pnlControl.getHeight();
        this.setPreferredSize(new Dimension(n, n2));
        double[] dArray = this._coordSystem.getSpecMapParams(n, n3);
        this._centerX = (int)dArray[0];
        this._centerY = (int)dArray[1];
        this._scaleFactorX = dArray[2];
        this._scaleFactorY = dArray[3];
        this._markValueX = dArray[4];
        this._markValueY = dArray[5];
        this.initImage(n, n3);
        this.setVisible(true);
    }

    private void drawCoordAxis(Graphics2D graphics2D, int n, int n2, int n3, int n4, double d, double d2, double d3, double d4) {
        double d5;
        double d6;
        int n5;
        graphics2D.drawLine(n3, 0, n3, n2);
        graphics2D.drawLine(0, n4, n, n4);
        int n6 = (int)(d3 * d);
        int n7 = (n - n3 - n6 - 1) / n6;
        int n8 = (n3 - n6 - 1) / n6;
        int n9 = n3 - n6 * n8;
        int n10 = -((int)Math.floor(d3 * (double)n8 * 100.0 + 1.0E-5));
        int n11 = (int)(d3 * 100.0 + 0.999);
        for (n5 = 0; n5 <= n7 + n8; ++n5) {
            if (n9 != n3) {
                graphics2D.drawLine(n9, n4 - 4, n9, n4 + 4);
                d6 = (double)n10 / 100.0;
                if (this._bLogScaling) {
                    d5 = Math.pow(10.0, Math.abs(d6)) - 1.0;
                    d6 = Math.signum(d6) * Math.floor(d5 * 100.0) / 100.0;
                }
                graphics2D.drawString(String.valueOf(d6), n9 - 16, n4 + 16);
            }
            n9 += n6;
            n10 += n11;
        }
        n6 = (int)(d4 * d2);
        n7 = (n4 - n6 - 1) / n6;
        n8 = (n2 - n4 - n6 - 1) / n6;
        n9 = n4 + n6 * n8;
        n10 = -((int)Math.floor(d4 * (double)n8 * 100.0 + 1.0E-5));
        n11 = (int)(d4 * 100.0 + 0.999);
        for (n5 = 0; n5 <= n7 + n8; ++n5) {
            if (n9 != n4) {
                graphics2D.drawLine(n3 - 4, n9, n3 + 4, n9);
                d6 = (double)n10 / 100.0;
                if (this._bLogScaling) {
                    d5 = Math.pow(10.0, Math.abs(d6)) - 1.0;
                    d6 = Math.signum(d6) * Math.floor(d5 * 100.0) / 100.0;
                }
                graphics2D.drawString(String.valueOf(d6), n3 + 8, n9 + 4);
            }
            n9 -= n6;
            n10 += n11;
        }
    }

    private ArrayList<double[]> nextStep(CoordinateSystem coordinateSystem, double d) {
        double[] dArray = this._objObserver.getNextPlanetEcl(d);
        ArrayList<double[]> arrayList = new ArrayList<double[]>();
        for (int i = 0; i < this._iNoPlanets; ++i) {
            double[] dArray2 = this._arrPlanets[i].getNextPosition(coordinateSystem, d, dArray);
            arrayList.add(dArray2);
        }
        arrayList.trimToSize();
        return arrayList;
    }

    private String formatLocalDate(long l) {
        this.LOCAL_CALENDAR.setTimeInMillis(l + this._lTimeZoneOffsetObs);
        Date date = this.LOCAL_CALENDAR.getTime();
        return this._sdfLocalFormat.format(date);
    }
}

