/*
 * Decompiled with CFR 0.152.
 */
package biogenesis;

import biogenesis.MainWindow;
import biogenesis.Messages;
import java.awt.Color;
import java.util.Random;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;

public final class Utils {
    static final int FILE_VERSION = 700;
    static final int VERSION = 800;
    static final int DEF_WINDOW_X = 0;
    static final int DEF_WINDOW_Y = 0;
    static final int DEF_WINDOW_WIDTH = 640;
    static final int DEF_WINDOW_HEIGHT = 480;
    static final int DEF_WINDOW_STATE = 0;
    static final int DEF_INITIAL_ORGANISMS = 15;
    static final double DEF_INITIAL_O2 = 0.0;
    static final double DEF_INITIAL_CO2 = 5000.0;
    static final int DEF_ORGANISMS_VECTOR_SIZE = 50;
    static final int DEF_WORLD_WIDTH = 1000;
    static final int DEF_WORLD_HEIGHT = 1000;
    static final int DEF_MAX_AGE = 30;
    static final double DEF_RUBBING = 0.98;
    static final double DEF_MUTATION_RATE = 0.05;
    static final int DEF_SEGMENT_COST_DIVISOR = 5000;
    static final double DEF_ORGANIC_OBTAINED_ENERGY = 0.5;
    static final int DEF_GREEN_OBTAINED_ENERGY_DIVISOR = 500;
    static final double DEF_ORGANIC_SUBS_PRODUCED = 0.1;
    static final double DEF_RED_ENERGY_CONSUMPTION = 0.0;
    static final double DEF_GREEN_ENERGY_CONSUMPTION = 0.0;
    static final double DEF_BLUE_ENERGY_CONSUMPTION = 0.0;
    static final double DEF_CYAN_ENERGY_CONSUMPTION = 0.0;
    static final double DEF_WHITE_ENERGY_CONSUMPTION = 1.0;
    static final double DEF_GRAY_ENERGY_CONSUMPTION = 1.0;
    static final double DEF_YELLOW_ENERGY_CONSUMPTION = 0.0;
    static final int DEF_RED_PROB = 10;
    static final int DEF_GREEN_PROB = 30;
    static final int DEF_BLUE_PROB = 10;
    static final int DEF_CYAN_PROB = 20;
    static final int DEF_WHITE_PROB = 10;
    static final int DEF_GRAY_PROB = 10;
    static final int DEF_YELLOW_PROB = 10;
    static final int DEF_DRAIN_SUBS_DIVISOR = 5000;
    static final int DEF_INITIAL_ENERGY = 50;
    static final double DEF_MAX_VEL = 5.0;
    static final double DEF_MAX_ROT = 0.19634954084936207;
    static final double DEF_ELASTICITY = 0.8;
    static final int DEF_DELAY = 50;
    static final int DEF_LOCAL_PORT = 8888;
    static final int DEF_MAX_CONNECTIONS = 1;
    static final boolean DEF_ACCEPT_CONNECTIONS = false;
    static final boolean DEF_CONNECT_TO_SERVER = false;
    static final String DEF_SERVER_ADDRESS = "";
    static final int DEF_SERVER_PORT = 0;
    static final int DEF_HARDWARE_ACCELERATION = 0;
    static final double DEF_DECAY_ENERGY = 0.1;
    static int WINDOW_X = 0;
    static int WINDOW_Y = 0;
    static int WINDOW_WIDTH = 640;
    static int WINDOW_HEIGHT = 480;
    static int WINDOW_STATE = 0;
    static int INITIAL_ORGANISMS = 15;
    static double INITIAL_O2 = 0.0;
    static double INITIAL_CO2 = 5000.0;
    static int ORGANISMS_VECTOR_SIZE = 50;
    static int WORLD_WIDTH = 1000;
    static int WORLD_HEIGHT = 1000;
    static int MAX_AGE = 30;
    static double RUBBING = 0.98;
    static double MUTATION_RATE = 0.05;
    static int SEGMENT_COST_DIVISOR = 5000;
    static double ORGANIC_OBTAINED_ENERGY = 0.5;
    static int GREEN_OBTAINED_ENERGY_DIVISOR = 500;
    static double ORGANIC_SUBS_PRODUCED = 0.1;
    static double RED_ENERGY_CONSUMPTION = 0.0;
    static double GREEN_ENERGY_CONSUMPTION = 0.0;
    static double BLUE_ENERGY_CONSUMPTION = 0.0;
    static double CYAN_ENERGY_CONSUMPTION = 0.0;
    static double WHITE_ENERGY_CONSUMPTION = 1.0;
    static double GRAY_ENERGY_CONSUMPTION = 1.0;
    static double YELLOW_ENERGY_CONSUMPTION = 0.0;
    static int RED_PROB = 10;
    static int GREEN_PROB = 30;
    static int BLUE_PROB = 10;
    static int CYAN_PROB = 20;
    static int WHITE_PROB = 10;
    static int GRAY_PROB = 10;
    static int YELLOW_PROB = 10;
    static int DRAIN_SUBS_DIVISOR = 5000;
    static int INITIAL_ENERGY = 50;
    static double MAX_VEL = 5.0;
    static double MAX_ROT = 0.19634954084936207;
    static double ELASTICITY = 0.8;
    static int DELAY = 50;
    static int LOCAL_PORT = 8888;
    static int MAX_CONNECTIONS = 1;
    static boolean ACCEPT_CONNECTIONS = false;
    static boolean CONNECT_TO_SERVER = false;
    static String SERVER_ADDRESS = "";
    static int HARDWARE_ACCELERATION = 0;
    static int SERVER_PORT = 0;
    static double DECAY_ENERGY = 0.1;
    static final double tol = 1.0E-7;
    static final int[][] side;
    static final double[] scale;
    static final Color ColorDARK_GREEN;
    static final Color ColorDARK_RED;
    static final Color ColorDARK_CYAN;
    static final Color ColorDARK_BLUE;
    static final Color ColorDARK_MAGENTA;
    static final Color ColorDARK_PINK;
    static final Color ColorDARK_ORANGE;
    static final Color ColorDARK_WHITE;
    static final Color ColorDARK_GRAY;
    static final Color ColorDARK_YELLOW;
    static final Color ColorBROWN;
    static final Color ColorLIGHT_BLUE;
    static final Color ColorLIGHT_RED;
    public static Random random;

    static {
        int[][] nArrayArray = new int[8][];
        int[] nArray = new int[2];
        nArray[0] = 1;
        nArrayArray[0] = nArray;
        nArrayArray[1] = new int[]{1, 1};
        int[] nArray2 = new int[2];
        nArray2[1] = 1;
        nArrayArray[2] = nArray2;
        nArrayArray[3] = new int[]{-1, 1};
        int[] nArray3 = new int[2];
        nArray3[0] = -1;
        nArrayArray[4] = nArray3;
        nArrayArray[5] = new int[]{-1, -1};
        int[] nArray4 = new int[2];
        nArray4[1] = -1;
        nArrayArray[6] = nArray4;
        nArrayArray[7] = new int[]{1, -1};
        side = nArrayArray;
        scale = new double[]{1.0, 1.12, 1.25, 1.4, 1.57, 1.76, 1.97, 2.21, 2.47, 2.77, 3.11, 3.48, 3.9, 4.36, 4.89, 5.47};
        ColorDARK_GREEN = Color.GREEN.darker();
        ColorDARK_RED = Color.RED.darker();
        ColorDARK_CYAN = Color.CYAN.darker();
        ColorDARK_BLUE = Color.BLUE.darker();
        ColorDARK_MAGENTA = Color.MAGENTA.darker();
        ColorDARK_PINK = Color.PINK.darker();
        ColorDARK_ORANGE = Color.ORANGE.darker();
        ColorDARK_WHITE = Color.WHITE.darker();
        ColorDARK_GRAY = Color.GRAY.darker();
        ColorDARK_YELLOW = Color.YELLOW.darker();
        ColorBROWN = new Color(150, 75, 0);
        ColorLIGHT_BLUE = new Color(0, 0, 100);
        ColorLIGHT_RED = new Color(100, 0, 0);
        random = new Random();
    }

    public static final int randomSign() {
        return (random.nextInt(2) << 1) - 1;
    }

    public static final int min(int a, int b, int c) {
        return Math.min(Math.min(a, b), c);
    }

    public static final double min(double a, double b, double c) {
        return Math.min(Math.min(a, b), c);
    }

    public static final int max(int a, int b, int c) {
        return Math.max(Math.max(a, b), c);
    }

    public static final double max(double a, double b, double c) {
        return Math.max(Math.max(a, b), c);
    }

    public static final int between(int value, int min, int max) {
        return Math.max(Math.min(max, value), min);
    }

    public static final double between(double value, double min, double max) {
        return Math.max(Math.min(max, value), min);
    }

    public static final boolean randomMutation() {
        return random.nextDouble() < MUTATION_RATE;
    }

    public static final String colorToString(Color c) {
        if (c.equals(Color.RED)) {
            return Messages.getString("T_RED");
        }
        if (c.equals(Color.GREEN)) {
            return Messages.getString("T_GREEN");
        }
        if (c.equals(Color.BLUE)) {
            return Messages.getString("T_BLUE");
        }
        if (c.equals(Color.CYAN)) {
            return Messages.getString("T_CYAN");
        }
        if (c.equals(Color.MAGENTA)) {
            return Messages.getString("T_MAGENTA");
        }
        if (c.equals(Color.PINK)) {
            return Messages.getString("T_PINK");
        }
        if (c.equals(Color.ORANGE)) {
            return Messages.getString("T_ORANGE");
        }
        if (c.equals(Color.WHITE)) {
            return Messages.getString("T_WHITE");
        }
        if (c.equals(Color.GRAY)) {
            return Messages.getString("T_GRAY");
        }
        if (c.equals(Color.YELLOW)) {
            return Messages.getString("T_YELLOW");
        }
        return DEF_SERVER_ADDRESS;
    }

    public static final void savePreferences() {
        try {
            Preferences prefs = Preferences.userNodeForPackage(Utils.class);
            prefs.putInt("VERSION", 700);
            prefs.putInt("INITIAL_ORGANISMS", INITIAL_ORGANISMS);
            prefs.putDouble("INITIAL_O2", INITIAL_O2);
            prefs.putDouble("INITIAL_CO2", INITIAL_CO2);
            prefs.putInt("ORGANISMS_VECTOR_SIZE", ORGANISMS_VECTOR_SIZE);
            prefs.putInt("WORLD_WIDTH", WORLD_WIDTH);
            prefs.putInt("WORLD_HEIGHT", WORLD_HEIGHT);
            prefs.putInt("MAX_AGE", MAX_AGE);
            prefs.putDouble("RUBBING", RUBBING);
            prefs.putDouble("MUTATION_RATE", MUTATION_RATE);
            prefs.putInt("SEGMENT_COST_DIVISOR", SEGMENT_COST_DIVISOR);
            prefs.putDouble("ORGANIC_OBTAINED_ENERGY", ORGANIC_OBTAINED_ENERGY);
            prefs.putInt("GREEN_OBTAINED_ENERGY_DIVISOR", GREEN_OBTAINED_ENERGY_DIVISOR);
            prefs.putDouble("ORGANIC_SUBS_PRODUCED", ORGANIC_SUBS_PRODUCED);
            prefs.putDouble("RED_ENERGY_CONSUMPTION", RED_ENERGY_CONSUMPTION);
            prefs.putDouble("GREEN_ENERGY_CONSUMPTION", GREEN_ENERGY_CONSUMPTION);
            prefs.putDouble("BLUE_ENERGY_CONSUMPTION", BLUE_ENERGY_CONSUMPTION);
            prefs.putDouble("CYAN_ENERGY_CONSUMPTION", CYAN_ENERGY_CONSUMPTION);
            prefs.putDouble("WHITE_ENERGY_CONSUMPTION", WHITE_ENERGY_CONSUMPTION);
            prefs.putDouble("GRAY_ENERGY_CONSUMPTION", GRAY_ENERGY_CONSUMPTION);
            prefs.putDouble("YELLOW_ENERGY_CONSUMPTION", YELLOW_ENERGY_CONSUMPTION);
            prefs.putInt("RED_PROB", RED_PROB);
            prefs.putInt("GREEN_PROB", GREEN_PROB);
            prefs.putInt("BLUE_PROB", BLUE_PROB);
            prefs.putInt("CYAN_PROB", CYAN_PROB);
            prefs.putInt("WHITE_PROB", WHITE_PROB);
            prefs.putInt("GRAY_PROB", GRAY_PROB);
            prefs.putInt("YELLOW_PROB", YELLOW_PROB);
            prefs.putInt("DRAIN_SUBS_DIVISOR", DRAIN_SUBS_DIVISOR);
            prefs.putInt("INITIAL_ENERGY", INITIAL_ENERGY);
            prefs.putDouble("MAX_VEL", MAX_VEL);
            prefs.putDouble("MAX_ROT", MAX_ROT);
            prefs.putDouble("ELASTICITY", ELASTICITY);
            prefs.putInt("DELAY", DELAY);
            prefs.putInt("LOCAL_PORT", LOCAL_PORT);
            prefs.putBoolean("ACCEPT_CONNECTIONS", ACCEPT_CONNECTIONS);
            prefs.putBoolean("CONNECT_TO_SERVER", CONNECT_TO_SERVER);
            prefs.put("SERVER_ADDRESS", SERVER_ADDRESS);
            prefs.putInt("SERVER_PORT", SERVER_PORT);
            prefs.putInt("MAX_CONNECTIONS", MAX_CONNECTIONS);
            prefs.putInt("HARDWARE_ACCELERATION", HARDWARE_ACCELERATION);
            prefs.putDouble("DECAY_ENERGY", DECAY_ENERGY);
            prefs.put("LOCALE", Messages.getLanguage());
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public static final void readPreferences() {
        try {
            Preferences prefs = Preferences.userNodeForPackage(Utils.class);
            int previous_version = prefs.getInt("VERSION", 0);
            if (previous_version != 700) {
                try {
                    prefs.clear();
                }
                catch (BackingStoreException backingStoreException) {
                    // empty catch block
                }
            }
            WINDOW_X = prefs.getInt("WINDOW_X", 0);
            WINDOW_Y = prefs.getInt("WINDOW_Y", 0);
            WINDOW_WIDTH = prefs.getInt("WINDOW_WIDTH", 640);
            WINDOW_HEIGHT = prefs.getInt("WINDOW_HEIGHT", 480);
            WINDOW_STATE = prefs.getInt("WINDOW_STATE", 0);
            INITIAL_ORGANISMS = prefs.getInt("INITIAL_ORGANISMS", 15);
            INITIAL_O2 = prefs.getDouble("INITIAL_O2", 0.0);
            INITIAL_CO2 = prefs.getDouble("INITIAL_CO2", 5000.0);
            ORGANISMS_VECTOR_SIZE = prefs.getInt("ORGANISMS_VECTOR_SIZE", 50);
            WORLD_WIDTH = prefs.getInt("WORLD_WIDTH", 1000);
            WORLD_HEIGHT = prefs.getInt("WORLD_HEIGHT", 1000);
            MAX_AGE = prefs.getInt("MAX_AGE", 30);
            RUBBING = prefs.getDouble("RUBBING", 0.98);
            MUTATION_RATE = prefs.getDouble("MUTATION_RATE", 0.05);
            SEGMENT_COST_DIVISOR = prefs.getInt("SEGMENT_COST_DIVISOR", 5000);
            ORGANIC_OBTAINED_ENERGY = prefs.getDouble("ORGANIC_OBTAINED_ENERGY", 0.5);
            GREEN_OBTAINED_ENERGY_DIVISOR = prefs.getInt("GREEN_OBTAINED_ENERGY_DIVISOR", 500);
            ORGANIC_SUBS_PRODUCED = prefs.getDouble("ORGANIC_SUBS_PRODUCED", 0.1);
            RED_ENERGY_CONSUMPTION = prefs.getDouble("RED_ENERGY_CONSUMPTION", 0.0);
            GREEN_ENERGY_CONSUMPTION = prefs.getDouble("GREEN_ENERGY_CONSUMPTION", 0.0);
            BLUE_ENERGY_CONSUMPTION = prefs.getDouble("BLUE_ENERGY_CONSUMPTION", 0.0);
            CYAN_ENERGY_CONSUMPTION = prefs.getDouble("CYAN_ENERGY_CONSUMPTION", 0.0);
            WHITE_ENERGY_CONSUMPTION = prefs.getDouble("WHITE_ENERGY_CONSUMPTION", 1.0);
            GRAY_ENERGY_CONSUMPTION = prefs.getDouble("GRAY_ENERGY_CONSUMPTION", 1.0);
            YELLOW_ENERGY_CONSUMPTION = prefs.getDouble("YELLOW_ENERGY_CONSUMPTION", 0.0);
            RED_PROB = prefs.getInt("RED_PROB", 10);
            GREEN_PROB = prefs.getInt("GREEN_PROB", 30);
            BLUE_PROB = prefs.getInt("BLUE_PROB", 10);
            CYAN_PROB = prefs.getInt("CYAN_PROB", 20);
            WHITE_PROB = prefs.getInt("WHITE_PROB", 10);
            GRAY_PROB = prefs.getInt("GRAY_PROB", 10);
            YELLOW_PROB = prefs.getInt("YELLOW_PROB", 10);
            DRAIN_SUBS_DIVISOR = prefs.getInt("DRAIN_SUBS_DIVISOR", 5000);
            INITIAL_ENERGY = prefs.getInt("INITIAL_ENERGY", 50);
            MAX_VEL = prefs.getDouble("MAX_VEL", 5.0);
            MAX_ROT = prefs.getDouble("MAX_ROT", 0.19634954084936207);
            ELASTICITY = prefs.getDouble("ELASTICITY", 0.8);
            DELAY = prefs.getInt("DELAY", 50);
            LOCAL_PORT = prefs.getInt("LOCAL_PORT", 8888);
            MAX_CONNECTIONS = prefs.getInt("MAX_CONNECTIONS", 1);
            ACCEPT_CONNECTIONS = prefs.getBoolean("ACCEPT_CONNECTIONS", false);
            CONNECT_TO_SERVER = prefs.getBoolean("CONNECT_TO_SERVER", false);
            SERVER_ADDRESS = prefs.get("SERVER_ADDRESS", DEF_SERVER_ADDRESS);
            SERVER_PORT = prefs.getInt("SERVER_PORT", 0);
            DECAY_ENERGY = prefs.getDouble("DECAY_ENERGY", 0.1);
            Utils.setHardwareAcceleration(prefs.getInt("HARDWARE_ACCELERATION", 0));
            if (HARDWARE_ACCELERATION == 1 || HARDWARE_ACCELERATION == 4) {
                prefs.putInt("HARDWARE_ACCELERATION", 0);
                ++HARDWARE_ACCELERATION;
            }
            Messages.setLocale(prefs.get("LOCALE", Messages.getLanguage()));
        }
        catch (SecurityException ex) {
            Messages.setLocale(Messages.getLanguage());
        }
    }

    public static void quitProgram(MainWindow window) {
        try {
            Preferences prefs = Preferences.userNodeForPackage(Utils.class);
            if (HARDWARE_ACCELERATION == 2 || HARDWARE_ACCELERATION == 5) {
                Object[] options = new String[]{Messages.getString("T_YES"), Messages.getString("T_NO")};
                int answer = JOptionPane.showOptionDialog(null, Messages.getString("T_DID_OPENGL_WORK_WELL"), Messages.getString("T_OPENGL_CONFIRMATION"), 0, 3, null, options, options[1]);
                if (answer == 0) {
                    prefs.putInt("HARDWARE_ACCELERATION", HARDWARE_ACCELERATION + 1);
                }
            }
            prefs.putInt("WINDOW_X", window.getX());
            prefs.putInt("WINDOW_Y", window.getY());
            prefs.putInt("WINDOW_WIDTH", window.getWidth());
            prefs.putInt("WINDOW_HEIGHT", window.getHeight());
            prefs.putInt("WINDOW_STATE", window.getExtendedState());
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        Utils.savePreferences();
    }

    public static void setHardwareAcceleration(int newValue) {
        try {
            switch (newValue) {
                case 0: 
                case 2: 
                case 5: {
                    System.setProperty("sun.java2d.opengl", "false");
                    break;
                }
                case 1: 
                case 3: {
                    System.setProperty("sun.java2d.opengl", "True");
                    System.setProperty("sun.java2d.noddraw", "true");
                    break;
                }
                case 4: 
                case 6: {
                    System.setProperty("sun.java2d.opengl", "True");
                    System.setProperty("sun.java2d.noddraw", "true");
                    System.setProperty("sun.java2d.opengl.fbobject", "false");
                }
            }
            HARDWARE_ACCELERATION = newValue;
        }
        catch (Exception e) {
            System.err.println(e.getLocalizedMessage());
        }
    }
}

