/*
 * Decompiled with CFR 0.152.
 */
package biogenesis;

import biogenesis.Connection;
import biogenesis.GeneticCode;
import biogenesis.NetServerThread;
import biogenesis.Utils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;

public class NetSend
extends Thread {
    protected Connection connection;
    protected int message;
    protected GeneticCode geneticCode;
    private int netCode;
    private int port;
    private int answerMessage;
    private ObjectOutputStream oos;
    private ObjectInputStream ois;
    private Socket socket;
    private InetAddress address;

    public NetSend(Connection c, int m, GeneticCode g) {
        this.connection = c;
        this.message = m;
        this.geneticCode = g;
    }

    /*
     * Loose catch block
     */
    @Override
    public void run() {
        this.address = this.connection.remoteAddress;
        this.port = this.connection.remotePort;
        this.netCode = this.connection.netCode;
        try {
            try {
                this.socket = new Socket(this.address, this.port);
                this.oos = new ObjectOutputStream(this.socket.getOutputStream());
                this.ois = new ObjectInputStream(this.socket.getInputStream());
                System.out.println("->" + NetServerThread.messageToString(this.message));
                switch (this.message) {
                    case 1: {
                        this.handleConnect();
                        break;
                    }
                    case 8: {
                        this.handleSendCode();
                        break;
                    }
                    case 13: {
                        this.handleKeepAlive();
                        break;
                    }
                    case 5: {
                        this.handleDisconnect();
                    }
                }
                this.socket.close();
            }
            catch (ConnectException e) {
                this.connection.setState(50);
                System.out.println("NetSend, ConnectException: " + e.getMessage());
                System.out.println("Connection closed with " + this.connection.remoteAddress + ":" + this.connection.remotePort);
                if (this.oos != null) {
                    try {
                        this.oos.close();
                    }
                    catch (IOException e2) {
                        System.out.println(e2.getMessage());
                    }
                }
                if (this.ois != null) {
                    try {
                        this.ois.close();
                    }
                    catch (IOException e3) {
                        System.out.println(e3.getMessage());
                    }
                }
                if (this.socket != null) {
                    try {
                        this.socket.close();
                    }
                    catch (IOException e4) {
                        System.out.println(e4.getMessage());
                    }
                }
            }
            catch (UnknownHostException e) {
                block56: {
                    this.connection.setState(50);
                    System.out.println("NetSend, UnknownHostException: " + e.getMessage());
                    System.out.println("Connection closed with " + this.connection.remoteAddress + ":" + this.connection.remotePort);
                    if (this.oos == null) break block56;
                    try {
                        this.oos.close();
                    }
                    catch (IOException e5) {
                        System.out.println(e5.getMessage());
                    }
                }
                if (this.ois != null) {
                    try {
                        this.ois.close();
                    }
                    catch (IOException e6) {
                        System.out.println(e6.getMessage());
                    }
                }
                if (this.socket != null) {
                    try {
                        this.socket.close();
                    }
                    catch (IOException e7) {
                        System.out.println(e7.getMessage());
                    }
                }
            }
            catch (IOException e) {
                block57: {
                    this.connection.setState(50);
                    System.out.println("NetSend, IOException: " + e.getMessage());
                    System.out.println("Connection closed with " + this.connection.remoteAddress + ":" + this.connection.remotePort);
                    if (this.oos == null) break block57;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    try {
                        this.oos.close();
                    }
                    catch (IOException e8) {
                        System.out.println(e8.getMessage());
                    }
                }
                if (this.ois != null) {
                    try {
                        this.ois.close();
                    }
                    catch (IOException e9) {
                        System.out.println(e9.getMessage());
                    }
                }
                if (this.socket != null) {
                    try {
                        this.socket.close();
                    }
                    catch (IOException e10) {
                        System.out.println(e10.getMessage());
                    }
                }
            }
        }
        finally {
            if (this.oos != null) {
                try {
                    this.oos.close();
                }
                catch (IOException e) {
                    System.out.println(e.getMessage());
                }
            }
            if (this.ois != null) {
                try {
                    this.ois.close();
                }
                catch (IOException e) {
                    System.out.println(e.getMessage());
                }
            }
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (IOException e) {
                    System.out.println(e.getMessage());
                }
            }
        }
    }

    private void handleConnect() throws ConnectException, IOException, UnknownHostException {
        System.out.println("----- Connecting...");
        this.oos.writeInt(this.message);
        this.oos.writeInt(800);
        this.oos.writeInt(Utils.LOCAL_PORT);
        this.oos.writeInt(this.netCode);
        this.oos.flush();
        this.answerMessage = this.ois.readInt();
        System.out.println(NetServerThread.messageToString(this.answerMessage));
        switch (this.answerMessage) {
            case 2: {
                this.connection.setState(51);
                break;
            }
            case 3: {
                this.connection.setState(51);
                break;
            }
            default: {
                this.connection.setState(50);
            }
        }
    }

    private void handleSendCode() throws ConnectException, IOException, UnknownHostException {
        System.out.println("----- Sending code...");
        this.oos.writeInt(this.message);
        this.oos.writeInt(this.netCode);
        this.oos.flush();
        this.answerMessage = this.ois.readInt();
        System.out.println(NetServerThread.messageToString(this.answerMessage));
        switch (this.answerMessage) {
            case 9: {
                this.oos.writeObject(this.geneticCode);
                System.out.println("->Genetic code");
                this.answerMessage = this.ois.readInt();
                System.out.println(NetServerThread.messageToString(this.answerMessage));
                if (this.answerMessage != 10) break;
                this.connection.resetTime();
                break;
            }
            case 7: {
                this.connection.setState(50);
                break;
            }
            case 11: {
                break;
            }
            default: {
                this.connection.setState(50);
            }
        }
    }

    private void handleKeepAlive() throws ConnectException, IOException, UnknownHostException {
        System.out.println("----- Checking remote server...");
        this.oos.writeInt(this.message);
        this.oos.writeInt(this.netCode);
        this.oos.flush();
        this.answerMessage = this.ois.readInt();
        System.out.println(NetServerThread.messageToString(this.answerMessage));
        switch (this.answerMessage) {
            case 14: {
                this.connection.resetTime();
                break;
            }
            default: {
                this.connection.setState(50);
            }
        }
    }

    private void handleDisconnect() throws ConnectException, IOException, UnknownHostException {
        System.out.println("----- Disconnecting...");
        this.oos.writeInt(this.message);
        this.oos.writeInt(this.netCode);
        this.oos.flush();
        this.answerMessage = this.ois.readInt();
        System.out.println(NetServerThread.messageToString(this.answerMessage));
        this.connection.setState(50);
    }
}

