/*
 * Decompiled with CFR 0.152.
 */
package biogenesis;

import biogenesis.Corridor;
import biogenesis.GeneticCode;
import biogenesis.Organism;
import biogenesis.Utils;
import biogenesis.World;
import java.awt.Color;
import java.awt.Graphics;
import java.util.LinkedList;
import java.util.Queue;

public class InCorridor
extends Corridor {
    private static final long serialVersionUID = 700L;
    private Queue<GeneticCode> pendingOrganisms = new LinkedList<GeneticCode>();
    private Organism nextOrganism = null;

    public InCorridor(World w) {
        super(w);
    }

    public synchronized void receiveOrganism(GeneticCode code) {
        this.pendingOrganisms.add(code);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void frame() {
        if (this.nextOrganism == null) {
            GeneticCode nextCode;
            Queue<GeneticCode> queue = this.pendingOrganisms;
            synchronized (queue) {
                nextCode = this.pendingOrganisms.poll();
            }
            if (nextCode != null) {
                this.nextOrganism = new Organism(this.world, nextCode);
            }
        }
        if (this.nextOrganism != null && this.nextOrganism.pasteOrganism(this.x + Utils.random.nextInt(this.width), this.y + Utils.random.nextInt(this.height))) {
            this.world.addOrganism(this.nextOrganism, null);
            this.nextOrganism = null;
        }
    }

    @Override
    public void draw(Graphics g) {
        g.setColor(Color.RED);
        g.drawRect(this.x, this.y, this.width, this.height);
        g.setColor(Utils.ColorLIGHT_RED);
        g.fillRect(this.x + 1, this.y + 1, this.width - 1, this.height - 1);
    }
}

