/*
 * Decompiled with CFR 0.152.
 */
package biogenesis;

import java.awt.Color;
import java.awt.Graphics;
import java.util.Iterator;
import java.util.List;

class GraphInfo {
    public Color color;
    public String name;
    public List<Double> info;
    public double max;
    public double min;
    private int[] xPoints;
    private int[] yPoints;
    private int nPoints;

    public void draw(Graphics g) {
        g.setColor(this.color);
        g.drawPolyline(this.xPoints, this.yPoints, this.nPoints);
    }

    public GraphInfo(List<Double> datum, double maxValue, double minValue, int width, int height, Color graphColor, String graphName) {
        this.info = datum;
        this.max = maxValue;
        this.min = minValue;
        this.color = graphColor;
        this.name = graphName;
        int x = 0;
        this.nPoints = Math.min(this.info.size(), width);
        this.xPoints = new int[this.nPoints];
        this.yPoints = new int[this.nPoints];
        Iterator<Double> it = this.info.iterator();
        while (it.hasNext() && x < width) {
            double y = (double)height - (it.next() - this.min) * (double)height / (this.max - this.min);
            this.xPoints[x] = x;
            this.yPoints[x] = (int)y;
            ++x;
        }
    }
}

