/* BinSuk.cmd */

  '@echo off'
  Version = '1.90'
  Debugswitch=1

/*----------------------------------------------------------------------------*
 * process commandline parameters                                             *
 *----------------------------------------------------------------------------*/
  parse arg Server Group Minsize Maxcount Sound Logfilename

  if Logfilename = 'NONE' then Logfilename = ''
  if Logfilename = "LOGFILENAME" then Logfilename = ''

  Rc=log(Logfilename,'BinSuk - '||Version||' startup')

  '@icontalk BinSuk '||Version||' - starting...'

/* draw the cool ansi screen on the local console */

  Rc=drawboarder(Version)

/*----------------------------------------------------------------------------*
 * Miscellaneous variables                                                    *
 *----------------------------------------------------------------------------*/
  Beginread       = 0
  Duplicatecount  = 0
  Duplicatelogdir ='DuplicateLogs'
  Grouplogdir     ='GroupLogs'
  Inbounddir      ='InBound'
  Processedcount  = 0
  Startline       = 9
  Trashedfilecount=0

/*----------------------------------------------------------------------------*
 * load add-on function libraries and assume it all went well...              *
 *----------------------------------------------------------------------------*/

  Rc=loadlibraries()

/*----------------------------------------------------------------------------*
 * Read BinSuk.cnf file and parse out UserID and Password                     *
 *----------------------------------------------------------------------------*/

  Rc=readconfig()

/*----------------------------------------------------------------------------*
 * determine if user specified server parameter is a named server or a        *
 * dotted named server                                                        *
 *----------------------------------------------------------------------------*/

  parse var Server Bit0 '.' Bit1 '.' Bit2 '.' Bit3

  Servertype=(datatype(Bit0)='NUM' & datatype(Bit1)='NUM' & datatype(Bit2)='NUM' & datatype(Bit3)='NUM')

  if Servertype=0 then do     /* is a named server */
    Nameserver=Server
    Rc=bsgethostbyname(Server)
    Server=Rc
  end /* if serverType */

  if Servertype=1 then do     /* is a dotted server */
    Rc=bsgethostbyaddr(Server)
    Nameserver=Rc
  end /* if serverType */

/*----------------------------------------------------------------------------*
 * If rc returns a zero, then an error occured and terminate the BS process   *
 * Gotta' clean this one up some day to terminate cleanly!@                   *
 *----------------------------------------------------------------------------*/

  if (Rc = 0) then do
    Rc=errorsound(1)
    Text="Unable to resolve server name: "Server
    say Text
    Rc=log(Logfilename,Text)
    exit
  end /* if rc */

/*----------------------------------------------------------------------------*
 * Open socket and return the actual socket numnber.                          *
 *----------------------------------------------------------------------------*/

  Rc=bssocksocket()

  if (Rc = -1) then do
    Rc=errorsound(1)
    Text="Error opening socket: "Errno
    say Text
    Rc=log(Logfilename,Text)
    exit
  end /* if rc */

  Sock=Rc

/* configure the socket we just opened */

  Rc=bssocksetsockopt(Sock)

  if (Rc = 0) then do
    Rc=ticksound(1)
  end /* if rc */

/* connect the socket and start the "conversation" */

  Rc=bssockconnect(Sock,Server)

  if (Rc = -1) then do
    Rc=errorsound(1)
    Text='Error connecting socket:' Errno
    say Text
    Rc=log(Logfilename,Text)
    exit
  end

  Rc=getresponse(Sock)

  Text='Connected to server: 'Nameserver' ('Server')'
  Rc=log(Logfilename,Text)

  Rc = SysCurPos(2,3)
  say Text

  Rc = SysCurPos(2,71)
  say'(   )'

/*----------------------------------------------------------------------------*
 * ask for group information from server                                      *
 *----------------------------------------------------------------------------*/
  Rc=sendmessage(Sock,'group '||Group,Logfilename)
  Rc=getresponse(Sock)

  parse var Line.1 Code Total Begin End1 .

/*----------------------------------------------------------------------------*
 * Code 480 reponse indicates that this session is password/userID protected  *
 *----------------------------------------------------------------------------*/

  if Code=480 then do
    Rc=log(Logfilename,'The news server >'||Nameserver||'< requires authentication!')
    Rc=log(Logfilename,'Sending userID >'||Bsuser||'< to >'||Nameserver||'<!')

    Rc=sendmessage(Sock,'AUTHINFO USER '||Bsuser)
    Rc=getresponse(Sock)
    parse var Line.1 Code .

    if Code=482 | Code =502 then do
      Text='The news server >'||Nameserver||'< does not accept UserID >'||Bsuser|'<!'
      say Text
      Rc=log(Logfilename,Text)
      Text='This BinSuk session is terminated!'
      say Text
      Rc=log(Logfilename,Text)
      exit 1
    end /* if code=482 */

    if Code=381 then do
      Rc=log(Logfilename,'Sending Password >'||Bspass||'< to >'||Nameserver||'<!')
      Rc=sendmessage(Sock,'AUTHINFO PASS '||Bspass)
      Rc=getresponse(Sock)
      parse var Line.1 Code .
    end /* if code=381 */

    if Code=482 | Code =502 then do
      Text='The news server >'||Nameserver||'< does not accept your login information!'
      say Text
      Rc=log(Logfilename,Text)
      Text='This BinSuk session is terminated!'
      say Text
      Rc=log(Logfilename,Text)
      exit 1
    end /* if code=482 */

    Rc=log(Logfilename,'The news server >'||Nameserver||'< accepts your login information!')

    Rc=sendmessage(Sock,'group '||Group,Logfilename)
    Rc=getresponse(Sock)

    parse var Line.1 Code Total Begin End1 .

  end /* if code=480 */

/*----------------------------------------------------------------------------*
 * code 411 - this was a BAD group command!                                   *
 *----------------------------------------------------------------------------*/

  if Code = 411 then do
    Rc=errorsound(Sound)

    Rc=SysCurPos(Startline+3,3)
    say'                                                                          '

    Rc=SysCurPos(Startline+3,3)

    Text='No such group as: 'Group
    say Text
    Rc=log(Logfilename,Text)
    exit 1

  end /* if code */

/*----------------------------------------------------------------------------*
 * Setup newserver for client reader operations. Performance boost on some    *
 * newsservers. Server response is ignored.                                   *
 *----------------------------------------------------------------------------*/

  Rc=sendmessage(Sock,'mode reader',Logfilename)
  Rc=getresponse(Sock)

  parse var Line.1 Code .

/*----------------------------------------------------------------------------*
 * read in group.log information                                              *
 *----------------------------------------------------------------------------*/

  Rc=grouplogfunctions(Group,Grouplogdir,,'read')
  Lastread=Rc

  if Lastread = '' then Lastread = 0

  if Lastread < Begin then Lastread = Begin

  Beginread = Lastread

  Rc = SysCurPos(4,3)
  say'Processing newsgroup: 'Group

  Rc = SysCurPos(5,3)
  say'Last message number read: 'Lastread

  Newmessagecount = End1-Lastread

  Rc = SysCurPos(6,3)
  say'Newest message number on server: 'End1' (number of new messages: 'Newmessagecount')'

  Rc=SysCurPos(8,3)
  say'                                                                          '

  Rc=SysCurPos(8,3)
  say'Minimum message length: 'Minsize'    Sound: 'Sound'    maxCount: 'Maxcount

  if Lastread > End1 then do
    say''
    Text='No new messages in: 'Group
    say Text
    Rc=log(Logfilename,Text)
    exit
  end

  Badarticle = 0
  Duplicatecount = 0
  Extractedbinarycount = 0

  Rc=clearscreen(Startline)
  Rc=cleartotals(Startline)

/*----------------------------------------------------------------------------*
 * here's the main work loop                                                  *
 *----------------------------------------------------------------------------*/
  do Messagenumber = Beginread to End1

    signal on halt

    Rc=clearscreen(Startline)

    Rc=SysCurPos(Startline+1,3)
    say'                                                                          '

    Rc=SysCurPos(Startline+1,3)
    say'Getting header number: 'Messagenumber
    '@icontalk BinSuk getting header: 'Messagenumber' - '

    Rc=sendmessage(Sock,'head '||Messagenumber,Logfilename)
    Rc=getresponse(Sock)

    parse var Line.1 Code Number .

/*----------------------------------------------------------------------------*
 * code 421 - no more messages                                                *
 *----------------------------------------------------------------------------*/

    if Code = 421 then do
      Rc=clearscreen(Startline)
      Rc=SysCurPos(Startline+1,3)
      say'                                                                          '

      Rc=bloopsound(Sound)

      Rc=SysCurPos(Startline+1,3)
      Text='All Done!'
      say Text
      Rc=log(Logfilename,Text)

      exit
    end /* if code */

/*----------------------------------------------------------------------------*
 * code 423 - this was a BAD message!                                         *
 *----------------------------------------------------------------------------*/

    if Code = 423 then do
      Rc=SysCurPos(Startline+8,3)
      say'Bad article count: '

      Rc=bloopsound(Sound)
      Badarticle = Badarticle + 1

      Rc=SysCurPos(Startline+8,3)
      say'Bad article count: 'Badarticle

/* update group log file, so we can keep track of the LAST processed message */

      Rc=grouplogfunctions(Group,Grouplogdir,Messagenumber,'write')

      Rc=checkforkey()
      if Rc=1 then signal killedbyuser

      iterate

    end /* if code */

    do I = 1 to Line.0
      parse var Line.i Name Linecount .

      if Name = "Lines:" then leave
    end /* do i */

    do I = 1 to Line.0
      parse var Line.i Subj Subject

      if Subj = "Subject:" then leave
    end /* do i */

/*----------------------------------------------------------------------------*
 * extract file suffix from subject line - not case sensitive                 *
 * Set lines var to 0 if a nondesired file - original code by Rob Chandler    *
 *----------------------------------------------------------------------------*/

    Capsubject=translate(Subject)
    Longsubject=Capsubject

    Rc=checkforfetch(Longsubject)
    Rjcnameend=Rc

    if Rjcnameend > 0 then do
      Rjcnameend = 3 + Rjcnameend
      Rjcnamestart = 1 + lastpos(' ',Subject, Rjcnameend)
      Rjcnamelength = 1 + Rjcnameend - Rjcnamestart
      Tempsubject = substr(Subject, Rjcnamestart, Rjcnamelength-4)
      Subject = translate(Tempsubject)
    end /* RJCNameEnd */

    if Rjcnameend < 1 then do
      Linecount = 0
    end /* if RJCNameEnd */

    Rc=checkfortrash(Longsubject)

    if Rc=1 then do
      Rc=SysCurPos(Startline+4,3)
      say'Skipping filename: 'Subject
      Rc=bloopsound(Sound)
      Trashedfilecount=Trashedfilecount+1

      Rc=SysCurPos(Startline+11,3)
      say'                                                                      '

      Rc=SysCurPos(Startline+11,3)
      say'Trashed article count: 'Trashedfilecount

      iterate
    end /* if rc=1 */

    if Rc=0 then do

      if Linecount > Minsize then do

        Rc=checkfordupes(Startline,Duplicatelogdir,Subject,Longsubject)
        if Rc = 0 then do

          '@icontalk BinSuk getting header: 'Messagenumber' - "'Subject'"'

          Rc=SysCurPos(Startline+2,3)
          say'                                                                          '

          Rc=SysCurPos(Startline+2,3)
          say Subject' is not a duplicate...'

          Rc=SysCurPos(Startline+3,3)
          say'                                                                          '

          Rc=SysCurPos(Startline+3,3)
          say'Reading 'Linecount' lines from message number: 'Number
          '@icontalk BinSuk reading 'Linecount' lines from Msg# 'Messagenumber

          Rc=sendmessage(Sock,'body '||Number,Logfilename)

          Readingmessage = 1
          Rc=getresponse(Sock)
          Readingmessage = 0

          Filename = SysTempFileName('temporary.?????','?')

          Rc=SysCurPos(Startline+4,3)
          say'                                                                          '

          Rc=SysCurPos(Startline+4,3)
          say'Writing 'Linecount' lines to: 'Filename
          '@icontalk BinSuk writing 'Linecount' to file'

          do I = 1 to Line.0
            call lineout Filename,Line.i
          end /* do i */

          Rc=stream(Filename,'c','close')

          Rc=SysCurPos(Startline+5,3)
          say'                                                                          '

          Rc=SysCurPos(Startline+5,3)
          say'Extracting binary from :'Filename
          '@icontalk BinSuk extracting binary...'

          Sessionlabel='"BinDecoder - '||Subject||'"'
          'start 'Sessionlabel' /b /c /win /min BinDecoder.cmd 'Inbounddir' 'Subject' 'Filename' 'Logfilename

          Rc=SysCurPos(Startline+5,3)
          say'                                                                          '

          Rc=SysCurPos(Startline+5,3)
          say'Extracted!'

/*----------------------------------------------------------------------------*
 * update duplicate log file with extracted binary name                       *
 *----------------------------------------------------------------------------*/
          Rc=updateduplicatelog(Startline,Duplicatelogdir,Subject)

          Extractedbinarycount = Extractedbinarycount + 1
          Rc=SysCurPos(Startline+9,3)
          say'                                                                          '

          Rc=SysCurPos(Startline+9,3)
          say'Extracted binaries: 'Extractedbinarycount

        end /* if rc checkfordupes */

        if Rc=1 then Rc=log(Logfilename,'The file "'Subject'.JPG" was a duplicate in the group "'Group'"!')

      end /* if lineCount > MINSIZE */

    end /* if rc checkfortrash */

    Rc=grouplogfunctions(Group,Grouplogdir,Messagenumber,'write')

    Rc=SysCurPos(Startline-4,29)
    say'                                  '

    Rc=SysCurPos(Startline-4,29)
    say Number

    Processedcount = Processedcount + 1

    Rc=SysCurPos(Startline+12,3)
    say'Processed message count: 'Processedcount

    if Extractedbinarycount > (Maxcount - 1) then leave

    Rc=checkforkey()
    if Rc=1 then signal killedbyuser

    Newmessagecount = Newmessagecount -1

    if Newmessagecount < 1 then Newmessagecount = 0

    Rc=SysCurPos(6,3)
    say'                                                                          '

    Rc = SysCurPos(6,3)
    say'Newest message number on server: 'End1' (number of new messages: 'Newmessagecount')'

  end /* do messageNumber */

/*----------------------------------------------------------------------------*
 * at end of main loop - all done                                             *
 *----------------------------------------------------------------------------*/

  Rc=SysCurPos(22,3)
  Text='Finished processing newsgroup "'Group'"'
  say Text
  Rc=log(Logfilename,Text)

  Rc=sendmessage(Sock,'quit',Logfilename)

  Rc=getresponse(Sock)
  Rc = socksoclose(Sock)

  Rc=donesound(Sound)

  Rc=log(Logfilename, 'BinSuk - finished without errors')

  call SysSleep 10

exit

/*----------------------------------------------------------------------------*
 * get a line from the server                                                 *
 *----------------------------------------------------------------------------*/

  Getresponseline: procedure expose !.

  Sock = arg(1)

  Crlf = d2c(13)||d2c(10)

  if (symbol('!.buff') = "LIT") then !.buff = ""

  do while (pos(Crlf,!.buff) = 0)
    Rc = sockrecv(Sock,"data",8192)
    !.buff = !.buff||Data
  end /* do while */

  P = pos(Crlf,!.buff)

  Line = substr(!.buff,1,P-1)
  !.buff = substr(!.buff,P+2)

return Line

/*----------------------------------------------------------------------------*
 * get a response from the server                                             *
 *----------------------------------------------------------------------------*/

  Getresponse: procedure expose !. Line. Readingmessage Linecount

  Sock=arg(1)

  Moreids = "100 215 220 221 222 223 230 231"

  Line.0 = 1
  Line.1 = getresponseline(Sock)

  parse var Line.1 Rid Msg

  if Rid = 400 then do
    say'The server has closed the connection!'
    exit
  end /* if rid */

  if (wordpos(Rid,Moreids) = 0) then return ''

  Blink = 0
  O = 0

  do forever

    O = Line.0 + 1
    Line.o = getresponseline(Sock)

    if (Line.o == ".") then return ''

    Line.0 = O

    if Readingmessage = 1 then do

      Blink = Blink + 1

      if Blink > 5 then do
        Rc=SysCurPos(2,72)
        say format((( Line.0 / Linecount) * 100),3,0)
        Rc=SysCurPos(2,72)
        Blink = 0
      end /* if blink */

    end /* if readingMessage */

  end /* do forever */

return ''

/*----------------------------------------------------------------------------*
 * send a string to the server, after adding the cr/lf pair                   *
 *----------------------------------------------------------------------------*/

  Sendmessage: procedure

  Sock = arg(1)
  Data = arg(2)||d2c(13)||d2c(10)
  Logfilename=arg(3)

  Len = length(Data)

  do while (Len > 0)

    I = socksend(Sock,Data);

    if (Errno <> 0) then do
      Text='Error sending data to server!'
      say Text
      Rc=log(Logfilename,Text)
      exit
    end /* if */

    if (I <= 0) then do
      Text='Server closed the connection!'
      say Text
      Rc=log(Logfilename,Text)
      exit
    end /* if */

    Data = substr(Data,Len+1)
    Len  = length(Data)

  end /* do while */

return 0

/*----------------------------------------------------------------------------*
 * check for duplicate messages                                               *
 *----------------------------------------------------------------------------*/

  Checkfordupes: procedure expose Duplicatecount

  Startline      =arg(1)
  Duplicatelogdir=arg(2)
  Subject        =arg(3)
  Longsubject    =arg(4)
  Logfilename    =arg(5)

/* check for dupebase directory */

  do forever
    Rc=SysMkDir(Duplicatelogdir)
    if Rc=5 then leave
  end

  Isaduplicate = 0

  Rc=SysCurPos(Startline+2,3)
  say'                                                                          '

  Rc=SysCurPos(Startline+2,3)
  say 'Waiting for duplicates file to be free...'

  Handle=syscreatemutexsem('\sem32\CheckForDupes')
  Rc=sysopenmutexsem(Handle)

  do forever
    Rc=sysrequestmutexsem(Handle,random(1,1000))
    if Rc=0 then leave
    Rc=debuglog('Waiting for mutex to clear in checkfordupes',Group)
    call ticksound(1)
  end /* do forever */

  Rc=SysCurPos(Startline+2,3)
  say'                                                                          '

  Rc=SysCurPos(Startline+2,3)
  say'Checking 'Subject' for duplicate status...'

  Prefix='\'||left(Subject,1)
  do while lines(Duplicatelogdir||Prefix||'.log')

    Text=linein(Duplicatelogdir||Prefix||'.log')

    parse var Text Dupsubj'/'Dupdate

    if Subject = Dupsubj then do
      Rc=SysCurPos(Startline+2,3)
      say'                                                                          '

      Rc=SysCurPos(Startline+2,3)
      say'====>Duplicate Subject - Ignoring Message<===='

      Rc=SysCurPos(Startline+12,3)
      say'                                                                          '

      Duplicatecount = Duplicatecount + 1

      Rc=SysCurPos(Startline+10,3)
      say'Duplicate article count: 'Duplicatecount

      Rc=errorsound(Sound)

      Isaduplicate = 1

    end /* if subject */

    Rc=checkforkey()
    if Rc=1 then signal killedbyuser

  end /* do while */

  call stream Duplicatelogdir||Prefix||'.log','c','close'

  Rc=sysreleasemutexsem(Handle)

return Isaduplicate

  Ticksound: procedure

  Sound=arg(1)

  if Sound = 1 then do
    call beep 1500, 1
    call beep 1600, 1
  end /* if sound */

return 0

  Bloopsound: procedure

  Sound=arg(1)

  if Sound = 1 then do
    call beep 1400, 1
    call beep 1500, 1
  end /* if sound */

return 0

  Errorsound: procedure

  Sound=arg(1)

  if Sound = 1 then do
    call beep 400, 25
    call beep 500, 25
  end /* if sound */

return 0

  Donesound: procedure

  Sound=arg(1)

  if Sound = 1 then do
    call beep 400, 100
    call beep 500, 100
    call beep 400, 100
    call beep 500, 100
    call beep 400, 100
    call beep 500, 100
    call beep 400, 100
    call beep 500, 100

  end /* if sound */

return 0

  Updateduplicatelog: procedure

  Startline=arg(1)
  Duplicatelogdir=arg(2)
  Subject=arg(3)
  Logfilename=arg(4)

  Rc=SysCurPos(Startline+6,3)
  say'                                                                          '

  Rc=SysCurPos(Startline+6,3)
  say 'Waiting for duplicate log to be free...'

  Handle=syscreatemutexsem('\sem32\updateDuplicateLog')
  Rc=sysopenmutexsem(Handle)

  do forever
    Rc=sysrequestmutexsem(Handle,random(1,1000))
    if Rc=0 then leave
    Rc=debuglog('Waiting for mutex to clear in updateduplicatelog',Group)
    call ticksound(1)
  end /* do forever */

  Rc=SysCurPos(Startline+6,3)
  say'                                                                          '

  Rc=SysCurPos(Startline+6,3)
  say'Updating duplicate list with new entry!'

  Prefix='\'||left(Subject,1)
  call stream  Duplicatelogdir||Prefix||'.log','c','seek <' 0
  call lineout Duplicatelogdir||Prefix||'.log', Subject||'/'||date('b')
  call stream  Duplicatelogdir||Prefix||'.log','c','close'

  Rc=sysreleasemutexsem(Handle)

  Rc=SysCurPos(Startline+6,3)
  say'                                                                          '

  Rc=SysCurPos(Startline+6,3)
  say'Updated duplicate log with new entry!'

return 0

  Log: procedure

  Logfilename=arg(1)
  Text       =arg(2)
  Group      =arg(3)

  if Logfilename = '' then return 1

  Handle=syscreatemutexsem('\sem32\Log')
  Rc=sysopenmutexsem(Handle)

  do forever
    Rc=sysrequestmutexsem(Handle,random(1,1000))
    if Rc=0 then leave

    call ticksound(1)
  end /* do forever */

  call stream  Logfilename,'c','seek <' 0
  call lineout Logfilename, date()||' '||time()||' 'Group||' - '||Text
  call stream  Logfilename,'c','close'

  Rc=sysreleasemutexsem(Handle)

return 0

  Clearscreen: procedure

  Startline = arg(1)

  Rc=SysCurPos(Startline+1,3)
  say'-                                                                        '

  Rc=SysCurPos(Startline+2,3)
  say'-                                                                        '

  Rc=SysCurPos(Startline+3,3)
  say'-                                                                        '

  Rc=SysCurPos(Startline+4,3)
  say'-                                                                        '

  Rc=SysCurPos(Startline+5,3)
  say'-                                                                        '

  Rc=SysCurPos(Startline+6,3)
  say'-                                                                        '

  Rc=SysCurPos(2,72)
  say'   '

return 0

  Cleartotals: procedure

  Startline=arg(1)

  Rc=SysCurPos(Startline+8,3)
  say'Bad article count: 0                                                     '

  Rc=SysCurPos(Startline+9,3)
  say'Extracted binaries: 0                                                    '

  Rc=SysCurPos(Startline+10,3)
  say'Duplicate article count: 0                                               '

  Rc=SysCurPos(Startline+11,3)
  say'Trashed article count: 0                                                 '

  Rc=SysCurPos(Startline+12,3)
  say'Processed message count: 0                                               '

return 0

/*----------------------------------------------------------------------------*
 * The following routine checks for possible waiting key strokes,             *
 * indicating that the user wishes to terminate this run of BinSuk            *
 *----------------------------------------------------------------------------*/

  Checkforkey: procedure

  if chars() then Key = SysGetKey('noecho')
  if Key=' ' then return 1

return 0

/*----------------------------------------------------------------------------*
 * The following routine draws a boarder around the console. Designed and     *
 * generated using THEDRAW for DOS                                            *
 *----------------------------------------------------------------------------*/

  Drawboarder: procedure expose Version

  Version = arg(1)

  say'[?7h[40m[2J[0;1m<> BinSuk 'Version' - mcbrides@pics.com <>Ŀ'
  say'[77C'
  say'[77C'
  say'[77C'
  say'[77C'
  say'[77C'
  say'[77C'
  say'[77C'
  say'[77C'
  say'[77C'
  say'[77C'
  say'[77C'
  say'[77C'
  say'[77C'
  say'[77C'
  say'[77C'
  say'[77C'
  say'[77C'
  say'[77C'
  say'[77C'
  say'[77C'
  say'[77C'
  say'[77C'
  say'<> Press space bar to kill off this BinSuk Process then wait for closure <>'

/*  SAY''*/

return 0

/*----------------------------------------------------------------------------*
 * get address of server : rc=0 error, rc=1 ok                                *
 *----------------------------------------------------------------------------*/

  Bsgethostbyname: procedure

  Server=arg(1)

  Rc = sockgethostbyname(Server,"host.!")

/*  server = host.!addr */

  if Rc = 0 then Host.!addr=0

return Host.!addr

/*----------------------------------------------------------------------------*
 * get name of server : rc=0 error, rc=1 ok                                   *
 *----------------------------------------------------------------------------*/

  Bsgethostbyaddr: procedure

  Server=arg(1)

  Rc = sockgethostbyaddr(Server,"host.!")

/*  server = host.!addr */

  if Rc = 0 then Host.!name=0

return Host.!name

/*----------------------------------------------------------------------------*
 * open socket                                                                *
 *----------------------------------------------------------------------------*/

  Bssocksocket: procedure

  Sock = socksocket("AF_INET","SOCK_STREAM",0)

return Sock

/*----------------------------------------------------------------------------*
 * configure socket for large buffers:                                        *
 * on some test machines, buffers larger than 16k caused this setting to be   *
 * ignored.                                                                   *
 *----------------------------------------------------------------------------*/

  Bssocksetsockopt: procedure

  Sock=arg(1)

  Rc = socksetsockopt(Sock, 'SOL_SOCKET', 'SO_RCVBUF', 16384)

return Rc

/*----------------------------------------------------------------------------*
 * connect socket                                                             *
 *----------------------------------------------------------------------------*/

  Bssockconnect: procedure

  Sock=arg(1)
  Server=arg(2)

  Server.!family = "AF_INET"
  Server.!port   = 119
  Server.!addr   = Server

  Rc = sockconnect(Sock,"server.!")

return Rc

/*----------------------------------------------------------------------------*
 * check for unwanted junk 0=okay to keep, 1=trash it!                        *
 *----------------------------------------------------------------------------*/

  Checkfortrash: procedure

  Trash=0

  Testtext=arg(1)
  Logfilename=arg(2)

  Binsuktrash='BinSuk.trash'

  if stream(Binsuktrash,'c','query exists') ='' then return Rc

  Handle=syscreatemutexsem('\sem32\CheckForTrash')
  Rc=sysopenmutexsem(Handle)

  do forever
    Rc=sysrequestmutexsem(Handle,random(1,1000))
    if Rc=0 then leave
    Rc=debuglog('Waiting for mutex to clear in checkfortrash',Group)
    call ticksound(1)
  end /* do forever */

  do while lines(Binsuktrash)

    Text=strip(translate(linein(Binsuktrash)))
    if pos('#',Text)\=1 then do
      if Text\='' then do
        if pos(Text,Testtext) > 0 then do
          Trash=1
        end /* if pos(test */
      end /* if text */
    end /* if pos( */
  end /* do while */

  call stream  Binsuktrash,'c','close'

  Rc=sysreleasemutexsem(Handle)

return Trash

/*----------------------------------------------------------------------------*
 * check for wanted messages 0=skip it, 1=fetch it!                           *
 *----------------------------------------------------------------------------*/

  Checkforfetch: procedure

  Testtext=arg(1)
  Logfilename=arg(2)
  Binsukfetch='BinSuk.fetch'

  Match=0

  if stream(Binsukfetch,'c','query exists') ='' then do
    Match=pos('.JPG',Testtext)
    return Match
  end /* if stream */

  Handle=syscreatemutexsem('\sem32\CheckForFetch')
  Rc=sysopenmutexsem(Handle)

  do forever
    Rc=sysrequestmutexsem(Handle,random(1,1000))
    if Rc=0 then leave
    Rc=debuglog('Waiting for mutex to clear in checkforfetch',Group)
    call ticksound(1)
  end /* do forever */

  do while lines(Binsukfetch)

    Text=strip(translate(linein(Binsukfetch)))
    if pos('#',Text)=1 then iterate
    if Text='' then iterate

    Match=pos(Text,Testtext)
    if Match>0 then leave

  end /* do while */

  call stream  Binsukfetch,'c','close'

  Rc=sysreleasemutexsem(Handle)

return Match

/*----------------------------------------------------------------------------*
 * update the group log with the last message number processed                *
 *                                                                            *
 * organized for easy porting to java                                         *
 *----------------------------------------------------------------------------*/

  Grouplogfunctions: procedure

  Group        =arg(1)
  Grouplogdir  =arg(2)
  Groupdata    =arg(3)
  Groupfunction=arg(4)

  Lastread=0

  Rc=SysMkDir(Grouplogdir)

  if Groupfunction='read' then do
    Lastread = linein(Grouplogdir||'\'||Group||'.log')
    call stream Grouplogdir||'\'||Group||'.log','c','close'
    return Lastread
  end /* read */

  if Groupfunction='write' then do
    call lineout Grouplogdir||'\'||Group||'.log', Groupdata, 1
    call stream Grouplogdir||'\'||Group||'.log','c','close'
    return 0
  end /* write */

return 0

/*----------------------------------------------------------------------------*
 * Load the support libraries if not already in memory                        *
 *----------------------------------------------------------------------------*/

  Loadlibraries: procedure

  if rxfuncquery('SysLoadFuncs') then do
    Rc=rxfuncadd('SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs')
    Rc=Sysloadfuncs
    say'Loaded RexxUtil'
  end /* if */

  if rxfuncquery('SockLoadFuncs') then do
    Rc=rxfuncadd('SockLoadFuncs','RxSock','SockLoadFuncs')
    Rc=sockloadfuncs('Quiet')
    say'Loaded RxSock"'
  end /* if */

return 0

  Debuglog: procedure expose Debugswitch

  if Debugswitch=0 then return 0

  Text=arg(1)
  Group=arg(2)

  Rc=log('Debug.log', 'In 'Group' = 'Text)

return 0

  Killedbyuser:

  Rc=log(Logfilename,'Killed by USER!')

  Rc=clearscreen(Startline)
  Rc=cleartotals(Startline)

  Rc=sendmessage(Sock,'quit',Logfilename)
  Rc=getresponse(Sock)
  Rc = socksoclose(Sock)

  if (Rc = -1) then do
    say''
    Text='Error on SockSoClose: 'Errno
    say Text
    Rc=log(Logfilename,Text)
  end

  Rc=donesound(Sound)

  Rc=log(Logfilename, 'BinSuk - finished by termination!')

  call SysSleep 2

exit

/*----------------------------------------------------------------------------*
 * check for BinSuk.cnf and read it's contents                                *
 *----------------------------------------------------------------------------*/

  Readconfig: procedure expose Bsuser Bspass

  Bsuser=''
  Bspass=''

  Binsukconfig='BinSuk.cnf'

  if stream(Binsukconfig,'c','query exists') ='' then return 0

  Handle=syscreatemutexsem('\sem32\ReadConfig')
  Rc=sysopenmutexsem(Handle)

  do forever
    Rc=sysrequestmutexsem(Handle,random(1,1000))
    if Rc=0 then leave
    Rc=debuglog('Waiting for mutex to clear in ReadConfig','No group')
    call ticksound(1)
  end /* do forever */

  do while lines(Binsukconfig)

    Text=strip(linein(Binsukconfig))
    Utext=translate(Text)

    if pos('#',Utext)\=1 then do
      if Utext\='' then do

        if pos('BSUSER ',Utext) > 0 then do
          parse var Text . Bsuser
        end /* if pos( */

        if pos('BSPASS ',Utext) > 0 then do
          parse var Text . Bspass
        end /* if pos( */

      end /* if text */
    end /* if pos( */

  end /* do while */

  call stream  Binsukconfig,'c','close'

  Rc=sysreleasemutexsem(Handle)

return 0



