/* REXX sound processor to accompany BiRC */

call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
call SysLoadFuncs

trace off
'@echo off'

parse upper arg playfile
playfile=space(playfile)

if (right(filespec('n',playfile),4)='.MP3') then /* Playing an mp3 */
   do
   'start "BiRC: Playing MP3' playfile'" /C /min mp3play 'playfile
   end /* MP3 */
else if (right(filespec('n',playfile),4)='.MOD') then /* Playing a mod */
   do
   'start "BiRC: Playing MOD' playfile'" /C /min modplay 'playfile
   end
else if (right(filespec('n',playfile),4)='.S3M') then /* Playing an s3m */
   do
   'start "BiRC: Playing S3M' playfile'" /C /min S3Mplay 'playfile
   end
else if (right(filespec('n',playfile),3)='.XM') then /* Playing an xm */
   do
   'start "BiRC: Playing XM' playfile'" /C /min xmplay 'playfile
   end
else if (right(filespec('n',playfile),4)='.AMF') then /* Playing an AMF */
   do
   'start "BiRC: Playing AMF' playfile'" /C /min amfplay 'playfile
   end
else if (right(filespec('n',playfile),3)='.IT') then /* Playing an IT */
   do
   'start "BiRC: Playing IT' playfile'" /C /min itplay 'playfile
   end
else if (right(filespec('n',playfile),4)='.WAV') then /* Playing a wav */
   do
   'start "BiRC: Playing WAV' playfile'" /C /min play file='playfile
   end
else if (right(filespec('n',playfile),4)='.MID') then /* Playing a midi */
   do
   'start "BiRC: Playing MIDI' playfile'" /C /min play file='playfile
   end

exit
