include ../include/gcc_os2.std

EXPLIB  = libvip.a
EXPINC  = vip.h	      

SYS     = gviptest
OBJS1   = vip2win.o vipframe.o vippush.o viptext.o
OBJS2   = vipgraph.o vipfont.o vipdial.o vipmeter.o
OBJS3   = vipmenu.o viplabel.o vipprint.o viptrans.o
OBJS4   = viptimer.o  vipscrol.o vipinput.o vipkeys.o 
OBJS    = $(OBJS1) $(OBJS2) $(OBJS3) $(OBJS4) 

LIBS    = -ldnpap

all: $(OBJS) $(EXPLIB) gviptest.exe gviptest.ini

examples:
	@cd examples $(SEP) $(MAKE) -f gcc_os2.mak all install $(OPTIONS) $(SEP) cd ..
        

$(SYS).exe: viptest.o $(OBJS) viptest.res
	$(CC) -g -o gviptest viptest.o -L. -L..\lib -lvip -ldnpap -los2
	emxbind -bpq -rviptest.res l:/emx/bin/emxl gviptest

viptest.res : viptest.rc
	rc -r viptest.rc

libvip.a: $(OBJS)
	ar u libvip.a $(OBJS1)
	ar u libvip.a $(OBJS2)
	ar u libvip.a $(OBJS3)
	ar u libvip.a $(OBJS4)

clean:
	- $(RM) *.o
	- $(RM) *.a
	- $(RM) *.exe
	- $(RM) core
	- $(RM) gviptest
	- $(RM) *.man
	- $(RM) *.err
	- $(RM) *.bak
	@cd examples $(SEP) $(MAKE) -f gcc_os2.mak clean $(OPTIONS) $(SEP) cd ..

install: $(LIBDIR)\$(EXPLIB) $(INCDIR)\$(EXPINC)

$(LIBDIR)\$(EXPLIB): $(EXPLIB)
	$(CP) $(EXPLIB) $(LIBDIR)

$(INCDIR)\$(EXPINC): $(EXPINC)
	$(CP) $(EXPINC) $(INCDIR)

gviptest.ini: viptest.ini
	$(CP) viptest.ini gviptest.ini
				

