/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       macspy.h
**     SYSTEM   NAME:       
**     ORIGINAL AUTHOR(S):  Paul Lemmers
**     VERSION  NUMBER:     
**     CREATION DATE:       1990/12/12
**
** DESCRIPTION: 
**              
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision:   1.1  $
** WORKFILE:    $Workfile:   macspy.h  $
** LOGINFO:     $Log:   D:/cprog/ndis/macspy/vcs/macspy.h_v  $
**              
**                 Rev 1.1   23 Jun 1991 14:43:36   PAUL
**              Adaption to ML (masm) 6.00
**              
**                 Rev 1.0   23 Jun 1991 14:36:10   PAUL
**              Initial revision.
*************************************************************************/

typedef struct _ALLSEL {
	unsigned short	p_cs;
	unsigned short	p_ds;
	unsigned short	r_cs;
	unsigned short	r_ds;
	unsigned short	now_cs;
	unsigned short	now_ds;
	} ALLSEL;

/* category code */
#define MAC_DEV 0x81

/* subfunction codes */
#define MAC_MY_ERROR  0
#define MAC_TR_INIT   0x41
#define MAC_TR_NEXT   0x42
#define MAC_TR_ON     0x43
#define MAC_TR_OFF    0x44
#define MAC_TR_STOP   0x45
#define MAC_TR_LOCAL  0x46
#define MAC_GETSEL    0x61
#define MAC_GETTAB    0x62


/* Mask for error ranges */
#define DEV_ERR_MASK  0xff00

/* device specific error codes in request status field */
/* Returned as (0xff00 | error code) by DosDevIOCtl() */
#define MSPE_INV_PTR    0x81
#define MSPE_MAX_SEL    0x82
#define MSPE_MAX_SEC    0x83
#define MSPE_INV_SEL    0x84
#define MSPE_DUP_SEL    0x85
#define MSPE_INV_TRST   0x86
#define MSPE_LOCK_FAIL  0x87
#define MSPE_ADDRESS    0x88
#define MSPE_SEM_ERR    0x89
#define MSPE_NOT_BOUND  0x8A
#define MSPE_INV_LOCALST 0x8B
#define MSPE_TIME       0x8C

/* Trace record types */
#define MSPT_DATA      0x4
#define MSPT_GenReq    0x11
#define MSPT_TranCh    0x12
#define MSPT_TranData  0x13
#define MSPT_RcvRel    0x14
#define MSPT_IndOn     0x15
#define MSPT_IndOff    0x16
#define MSPT_ReqConf   0x21
#define MSPT_TranConf  0x22
#define MSPT_RcvLook   0x23
#define MSPT_IndCompl  0x24
#define MSPT_RcvCh     0x25
#define MSPT_StaInd    0x26


/* structures for sector array and sector segment descriptors */

/* SECTD is a ptr to a byte array, the sector */
typedef unsigned char _far *SECTD;

typedef struct _SEGD {
	unsigned char _far *segp;
	unsigned short      sects;
	} SEGD;

#if !defined(NDESC)
#define NDESC 1
#endif

typedef struct _START {
	unsigned short ndesc;
	unsigned short sectsize;
	void _far *hsemReleased;
	SEGD	segarr[NDESC];
	} START;

typedef struct _BSEG _far *PBSEG;

typedef struct _BSEG {
	long    res0;
	long	res1;
	long	res2;
	short	first;
	short	count;
	} BSEG;

typedef struct _TRACEREC {
	unsigned short  TrLen;
	unsigned short  TrType;
	unsigned long   RetTime;
	unsigned long   CallTime;
	unsigned short  TrSeq;
	unsigned short  retc;
	unsigned short  ReqHandle;
	} TRACEREC;
