#ifndef _UDP_H_
#define _UDP_H_

#include <dnpap.h>
#include <chain.h>
#include <ip.h>


#define UDP_PORT_ANY	0xffff
#define UDP_ADDR_ANY    0xffffffffL

typedef struct _UDP_DESCR           UDP_DESCR;
typedef struct _UDP_HDR             UDP_HDR;
typedef struct _UDP_STAT            UDP_STAT;

struct _UDP_DESCR
{
	BOOLEAN     (*Rcve)(UDP_DESCR *descr, CHAIN *chain, UDP_HDR *udpHdr, IP_HDR *ipHdr);
	WORD	    locPort;
	DWORD    	locAddr;
	WORD    	remPort;
	DWORD       remAddr;
    void        *specific;
    UDP_DESCR   *next;
};

struct _UDP_STAT
{
    DWORD   noPorts;
    DWORD   inDatagrams;
    DWORD   inErrors;
    DWORD   outDatagrams;
    DWORD   outErrors;
};

struct _UDP_HDR
{
    WORD    src;
    WORD    dst;
    WORD    length;
    WORD    check;
};



BOOLEAN UdpInit(void);

BOOLEAN UdpRegister(UDP_DESCR *udp);
BOOLEAN UdpRemove(UDP_DESCR *udp);

BOOLEAN UdpSend(CHAIN *chain, UDP_HDR *udpHdr, IP_HDR *ipHdr);



#endif
