#include "ip.h"
#include "ipiface.h"


IP_IFACE *ipIfaceList = 0;



BOOLEAN IpIfaceRegister(IP_IFACE *iface)
{
    ARP_DESCR *arp;
    
    iface->addrNet          = iface->addr &  iface->mask;
    iface->addrBroadcast    = iface->addr | ~iface->mask;
    if (iface->iface->arp != MAC_ARP_NONE)
    {
        arp                 = DnpapMalloc(sizeof(ARP_DESCR));
        arp->iface          = iface->iface;
        arp->prot           = MAC_PROT_IP;
        *(DWORD *)arp->addr = IpH2NDWord(iface->addr); 
        arp->addrLength     = 4;
        if (!ArpRegister(arp))
            return FALSE;
        iface->arp          = arp;
    }
    iface->next         = ipIfaceList;
    ipIfaceList         = iface;
   
    return TRUE;
}


void IpIfaceRemove(IP_IFACE *iface)
{
    IP_IFACE **p;

    
    for (p=&ipIfaceList; *p!=0; p=&(*p)->next)
    {
        if (*p==iface)
        {
            *p = (*p)->next;
            break;
        }
    }
    if (iface->arp != 0)
    {
        ArpRemove(iface->arp);
        DnpapFree(iface->arp);
    }
}




void IpIfaceSwitch(IP_IFACE *iface, BOOLEAN up)
{
    iface->up = up;
}





BOOLEAN IpIfaceIsForMe(DWORD addr)
{
    IP_IFACE *i;
    
    if (addr == 0xffffffff || addr == 0)
        return TRUE;

    for (i=ipIfaceList; i!=0; i=i->next)
    {
        if (i->up)
        {
            if (addr == i->addr ||
                addr == i->addrNet ||
                addr == i->addrBroadcast)
                return TRUE;
        }
    }
    return FALSE;
}
