!include ..\..\include\standard.mak

SYS     = protocol
SYSLIB  = b2

all: obj doc

install: all $(INCDIR)\$(SYS).h $(MANDIR)\$(SYS).man $(LIBDIR)\$(SYSLIB).lib

$(INCDIR)\$(SYS).h: $(SYS).h 
	$(CP) $(SYS).h $(INCDIR)\$(SYS).h

$(MANDIR)\$(SYS).man: $(SYS).man 
	$(CP) $(SYS).man $(MANDIR)\$(SYS).man 

$(LIBDIR)\$(SYSLIB).lib: $(SYS).obj
        $(AR) $(LIBDIR)\$(SYSLIB).lib -+$(SYS).obj -+proteth.obj -+protip.obj -+prottcp.obj -+protudp.obj -+proticmp.obj -+protarp.obj -+protdns.obj;

obj: $(SYS).obj proteth.obj protip.obj prottcp.obj protudp.obj proticmp.obj protarp.obj protdns.obj      

doc: $(SYS).man

clean:
    - $(RM) *.exe
    - $(RM) *.obj
    - $(RM) *.i
    - $(RM) *.lib
    - $(RM) *.man
    - $(RM) *.err
    - $(RM) *.bak

$(SYS).man: $(SYS).c proteth.c protip.c prottcp.c protudp.c proticmp.c protarp.c protdns.c      
    $(MAN) -R:API  $(SYS).c proteth.c protip.c prottcp.c protudp.c proticmp.c protarp.c protdns.c > $(SYS).man

$(SYS).obj:     $(SYS).c    $(SYS).h        prot.h
proteth.obj:    proteth.c   protocol.h      prot.h
protip.obj:     protip.c    protocol.h      prot.h
prottcp.obj:    prottcp.c   protocol.h      prot.h
protudp.obj:    protudp.c   protocol.h      prot.h
proticmp.obj:   proticmp.c  protocol.h      prot.h
protarp.obj:    protarp.c   protocol.h      prot.h
protdns.obj:    protdns.c   protocol.h      prot.h



test.exe: test.obj test.ini
	$(LINK) test.obj $(SYSLIB)
	markexe windowcompat test.exe
