#ifndef _NEURO_M_H
#define _NEURO_M_H


#include <dnpap.h>
#include <mib.h>


#define NMIB_BASE       BTNG_MIB,2
#define NMIB_BASELEN    BTNG_MIBLEN+1


enum { NMIB_NRNETWORKS, NMIB_RUNNINGNRNETWORKS,
       NMIB_INDEX,
       NMIB_NRLAYERS, NMIB_NETREFRESH,
       NMIB_REQCOMM, 
       NMIB_TRAIN,
       NMIB_LRATE, NMIB_MOMENTUM,
       NMIB_TOTALSTEPS, NMIB_TRAININGSTEPS, 
       NMIB_OWNER, NMIB_STATUS, 
       NMIB_NRNEURONS, 
       NMIB_DATASRC, NMIB_DATASRCMAX, NMIB_DATASRCMIN,
       NMIB_DATASRCAVERAGEMETHOD, NMIB_DATASRCSTEPS, 
       NMIB_DATASRCTRAP, NMIB_DATASRCTRAPCOMM,
       NMIB_DATASRCTHRESHOLDCHECK,
       NMIB_DATASRCVALUE, NMIB_OUTPUTVALUE,
       NMIB_DATASRCTHRESHOLDVALUE
     };


#define NMIB_NRNETWORKSID               1,0,0
#define NMIB_RUNNINGNRNETWORKSID        2,0,0
#define NMIB_INDEXID                    3,1,1
#define NMIB_NRLAYERSID                 3,1,2      
#define NMIB_NETREFRESHID               3,1,3
#define NMIB_REQCOMMID                  3,1,4
#define NMIB_TRAINID                    3,1,5
#define NMIB_LRATEID                    3,1,6 
#define NMIB_MOMENTUMID                 3,1,7
#define NMIB_TOTALSTEPSID               3,1,8
#define NMIB_TRAININGSTEPSID            3,1,9
#define NMIB_OWNERID                    3,1,10
#define NMIB_STATUSID                   3,1,11      
#define NMIB_NRNEURONSID                4,1,3      
#define NMIB_DATASRCID                  5,1,4
#define NMIB_DATASRCMAXID               5,1,5
#define NMIB_DATASRCMINID               5,1,6
#define NMIB_DATASRCAVERAGEMETHODID     5,1,7
#define NMIB_DATASRCSTEPSID             5,1,8
#define NMIB_DATASRCTRAPID              5,1,9
#define NMIB_DATASRCTRAPCOMMID          5,1,10
#define NMIB_DATASRCTHRESHOLDCHECKID    5,1,11
#define NMIB_DATASRCVALUEID             5,1,12
#define NMIB_OUTPUTVALUEID              5,1,13
#define NMIB_DATASRCTHRESHOLDVALUEID    6,1,5

      
#define NMIB_COFFSET	1
#define NMIB_LOFFSET	2
#define NMIB_NOFFSET	3
#define NMIB_IOFFSET	4


#define NEUROSETID(base, index) \
{ \
LONG tmp[] = { index }; \
  \
    base[NMIB_BASELEN] = tmp[0];   \
    base[NMIB_BASELEN+1] = tmp[1]; \
    base[NMIB_BASELEN+2] = tmp[2]; \
}


BOOLEAN NeuroMInit(int argc, char *argv[]);
BOOLEAN NeuroMStart(VOID);
BOOLEAN NeuroMStop(VOID);

WORD NeuroIndex(MIB_OBJECT *obj, WORD idlen);
WORD NeuroLayerIndex(MIB_OBJECT *obj, WORD idlen);
WORD NeuroLayerIndexLayer(MIB_OBJECT *obj, WORD idlen);
WORD NeuroLayerNeuronIndex(MIB_OBJECT *obj, WORD idlen);
WORD NeuroLayerNeuronIndexLayer(MIB_OBJECT *obj, WORD idlen);
WORD NeuroLayerNeuronIndexNeuron(MIB_OBJECT *obj, WORD idlen);
WORD NeuroLayerNeuronValueIndex(MIB_OBJECT *obj, WORD idlen);
WORD NeuroLayerNeuronValueIndexLayer(MIB_OBJECT *obj, WORD idlen);
WORD NeuroLayerNeuronValueIndexNeuron(MIB_OBJECT *obj, WORD idlen);
WORD NeuroLayerNeuronValueIndexValue(MIB_OBJECT *obj, WORD idlen);
WORD NeuroNrNetworks(MIB_OBJECT *obj, WORD idlen);
WORD NeuroRunningNrNetworks(MIB_OBJECT *obj, WORD idlen);
WORD NeuroNrLayers(MIB_OBJECT *obj, WORD idlen);
WORD NeuroNrNeurons(MIB_OBJECT *obj, WORD idlen);
WORD NeuroRequestComm(MIB_OBJECT *obj, WORD idlen);
WORD NeuroNetRefresh(MIB_OBJECT *obj, WORD idlen);
WORD NeuroTrain(MIB_OBJECT *obj, WORD idlen);
WORD NeuroLearningRate(MIB_OBJECT *obj, WORD idlen);
WORD NeuroMomentum(MIB_OBJECT *obj, WORD idlen);
WORD NeuroError(MIB_OBJECT *obj, WORD idlen);
WORD NeuroTotalSteps(MIB_OBJECT *obj, WORD idlen);
WORD NeuroTrainingSteps(MIB_OBJECT *obj, WORD idlen);
WORD NeuroOutputValue(MIB_OBJECT *obj, WORD idlen);
WORD NeuroDataSource(MIB_OBJECT *obj, WORD idlen);
WORD NeuroDataSourceValue(MIB_OBJECT *obj, WORD idlen);
WORD NeuroDataSourceMax(MIB_OBJECT *obj, WORD idlen);
WORD NeuroDataSourceMin(MIB_OBJECT *obj, WORD idlen);
WORD NeuroDataSourceAverageMethod(MIB_OBJECT *obj, WORD idlen);
WORD NeuroDataSourceAverageSteps(MIB_OBJECT *obj, WORD idlen);
WORD NeuroDataSourceTrap(MIB_OBJECT *obj, WORD idlen);
WORD NeuroDataSourceTrapComm(MIB_OBJECT *obj, WORD idlen);
WORD NeuroDataSourceThresholdCheck(MIB_OBJECT *obj, WORD idlen);
WORD NeuroDataSourceThresholdValue(MIB_OBJECT *obj, WORD idlen);
WORD NeuroOwner(MIB_OBJECT *obj, WORD idlen);
WORD NeuroStatus(MIB_OBJECT *obj, WORD idlen);


#endif					     
