/************************************************************************
** MODULE INFORMATION **
************************
** FILE NAME:          infoc.c
** SYSTEM NAME:        beholder
** MODULE NAME:        info
** ORIGINAL AUTHOR(S): M.F.B. de Greeve
** VERSION NUMBER:     1.0
** CREATION DATE:      1992/7/13
** DESCRIPTION:        beholderInfo group: collector
*************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <dnpap.h>
#include <message.h>
#include <snmp.h>
#include <mac.h>
#include <timer.h>

#include "infoe.h"
#include "infoc.h"


static VOID InfoTimerCallback (TIMER_DESCR *timer, ULONG now, BEHOLDER_INFO *beholderInfo);


/*****************************************************************
** NAME:        InfoInit
** SYNOPSIS:    BOOLEAN InfoInit (BEHOLDER_INFO *beholderInfo)
** PARAMETERS:  pointer to data beholderInfo entry
** DESCRIPTION: initializes collector.
** REMARKS:     called when status is CREATE_REQUEST: see infom.c
** RETURNS:     TRUE: everything OK
**              FALSE: timer or net not initialized
*******************************************************************/

BOOLEAN InfoInit (BEHOLDER_INFO *beholderInfo)
{
    LONG source[] = {1,3,6,1,2,1,2,2,1,1,1};
    
    beholderInfo->SourceLen = sizeof(source)/sizeof(source[0]);
    memcpy (beholderInfo->Source, source, sizeof(source));

    if ((beholderInfo->Iface =
        MacIfaceGet((WORD) beholderInfo->Source[beholderInfo->SourceLen-1])) == NULL)
    {
        DnpapMessage(DMC_ERROR, INFO_NETINIT, "beholderInfo: network init");
        return (FALSE);
    }
    return (TRUE);
}


/*****************************************************************
** NAME:        InfoStart
** SYNOPSIS:    BOOLEAN InfoStart (BEHOLDER_INFO *beholderInfo)
** PARAMETERS:  pointer to data beholderInfo entry
** DESCRIPTION: starts collector.
** REMARKS:     called when status is VALID: see infom.c
** RETURNS:     TRUE: everything OK
**              FALSE: timer not registered
*******************************************************************/

BOOLEAN InfoStart (BEHOLDER_INFO *beholderInfo)
{
    if ((beholderInfo->Timer = TimerRegister (InfoTimerCallback, beholderInfo, 1000L, TIMER_FOREVER,TIMER_TYPE_SKIP)) == NULL)
    {
        DnpapMessage(DMC_ERROR, INFO_TIMER, "beholderInfo: timer init");
        return (FALSE);
    }
    MacStatistics(beholderInfo->Iface, &beholderInfo->OldStat);
    return(TRUE);
}

/*****************************************************************
** NAME:        InfoStop
** SYNOPSIS:    BOOLEAN InfoStop (BEHOLDER_INFO *beholderInfo)
** PARAMETERS:  pointer to data beholderInfo entry
** DESCRIPTION: stops collector.
** REMARKS:     called when status is INVALID: see infom.c
** RETURNS:     TRUE: timer registration removed
*******************************************************************/

BOOLEAN InfoStop (BEHOLDER_INFO *beholderInfo)
{
    TimerRemove(beholderInfo->Timer);
    return(TRUE);
}

/*****************************************************************
** NAME:        InfoTimerCallback
** SYNOPSIS:    VOID InfoTimerCallback (TIMER_DESCR *timer,
**                  ULONG now, ETHER_STATS *etherStats)
** PARAMETERS:  see Timer manual
** DESCRIPTION: periodically requests network statistics
** REMARKS:     none
** RETURNS:     VOID
*******************************************************************/

static VOID InfoTimerCallback (TIMER_DESCR *timer, ULONG now, BEHOLDER_INFO *beholderInfo)
{
    MacStatistics(beholderInfo->Iface, &beholderInfo->Stat);
    beholderInfo->Stat.LostPkts -= beholderInfo->OldStat.LostPkts;
    beholderInfo->Stat.Pkts -= beholderInfo->OldStat.Pkts;
    beholderInfo->Stat.DiscardedPkts -= beholderInfo->OldStat.DiscardedPkts;
    beholderInfo->Stat.TruncatedPkts -= beholderInfo->OldStat.TruncatedPkts;
    beholderInfo->Stat.StackedPkts -= beholderInfo->OldStat.StackedPkts;
    return;
}
