#ifndef _ALARM_C_H
#define _ALARM_C_H


#include <dnpap.h>
#include <snmp.h>
#include <timer.h>


typedef struct RmonAlarm_
{
    LONG Index;
    LONG Interval;                 
	LONG Variable[SNMP_SIZE_OBJECTID];
    WORD VarLen;
	LONG SampleType;               
	LONG Value;                    
	LONG PrevValue;                    
	LONG PrevDeltaValue;                    
	LONG StartupAlarm;             
	LONG RisingThreshold;          
    BOOLEAN RisingEvent;
	LONG FallingThreshold;         
    BOOLEAN FallingEvent;
	LONG RisingEventIndex;         
	LONG FallingEventIndex;        
	BYTE Owner[SNMP_SIZE_BUFCHR];     
	WORD OwnerLen;
	WORD Status;                   
	TIMER_DESCR *Timer;
	
} RmonAlarm;


BOOLEAN     AlarmCInit(RmonAlarm* alarm);
BOOLEAN     AlarmCStart(RmonAlarm* alarm);
BOOLEAN     AlarmCStop(RmonAlarm* alarm);

WORD        AlarmSample(LONG *id, WORD idlen, LONG *value, SNMP_OBJECT *obj);

RmonAlarm*  NewRmonAlarm(WORD nrevents);
RmonAlarm*  ReNewRmonAlarm(RmonAlarm* ptr, WORD nrevents);
VOID        DelRmonAlarm(RmonAlarm* ptr);


#endif

