/*
 * Decompiled with CFR 0.152.
 */
package cloudberry.watermark;

import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.jdesktop.swingx.JXImageView;

public class ImageViewer
extends JFrame
implements ActionListener,
WindowListener,
MouseWheelListener {
    JXImageView view = new JXImageView();
    JFrame controlFrame = new JFrame();
    JButton plusBTN = new JButton("Zoom In");
    JButton minusBTN = new JButton("Zoom Out");
    JButton closeBTN = new JButton("Close");

    public ImageViewer() {
        super("Preview");
        this.view.addMouseWheelListener(this);
        this.getContentPane().add(this.view);
        this.pack();
        this.setVisible(false);
        this.addWindowListener(this);
        this.setDefaultCloseOperation(0);
        this.setBounds(300, 100, 800, 600);
    }

    public void showImage(Image img) {
        this.view.setImage(img);
        this.setVisible(true);
        this.showControls();
    }

    public void showControls() {
        JPanel buttonPanel = new JPanel(new GridLayout(1, 3));
        buttonPanel.add(this.plusBTN);
        buttonPanel.add(this.minusBTN);
        buttonPanel.add(this.closeBTN);
        this.plusBTN.addActionListener(this);
        this.minusBTN.addActionListener(this);
        this.closeBTN.addActionListener(this);
        this.controlFrame.getContentPane().add(buttonPanel);
        this.controlFrame.pack();
        this.controlFrame.setVisible(true);
        this.controlFrame.setAlwaysOnTop(true);
        this.controlFrame.setBounds(320, 130, 250, 50);
        this.controlFrame.setResizable(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.plusBTN) {
            this.view.setScale(this.view.getScale() + 0.4);
        } else if (e.getSource() == this.minusBTN) {
            this.view.setScale(this.view.getScale() - 0.4);
        } else if (e.getSource() == this.closeBTN) {
            this.dispose();
            this.controlFrame.dispose();
        }
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.controlFrame.dispose();
        this.dispose();
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent arg0) {
        if (arg0.getUnitsToScroll() > 0) {
            this.view.setScale(this.view.getScale() - 0.05);
        } else {
            this.view.setScale(this.view.getScale() + 0.05);
        }
    }
}

