/*
 * Decompiled with CFR 0.152.
 */
package org.basex.modules;

import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.http.HttpSession;
import org.basex.data.Data;
import org.basex.http.SessionListener;
import org.basex.modules.SessionErrors;
import org.basex.query.QueryException;
import org.basex.query.QueryModule;
import org.basex.query.value.Value;
import org.basex.query.value.item.Dtm;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.node.ANode;
import org.basex.query.value.seq.StrSeq;
import org.basex.util.Util;
import org.basex.util.list.TokenList;

public final class Sessions
extends QueryModule {
    public Value ids() {
        HashMap<String, HttpSession> http = SessionListener.sessions();
        TokenList tl = new TokenList(http.size());
        for (String s : http.keySet()) {
            tl.add(s);
        }
        return StrSeq.get((TokenList)tl);
    }

    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public Dtm created(Str id) throws QueryException {
        return new Dtm(this.session(id).getCreationTime(), null);
    }

    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public Dtm accessed(Str id) throws QueryException {
        return new Dtm(this.session(id).getLastAccessedTime(), null);
    }

    public Value names(Str id) throws QueryException {
        TokenList tl = new TokenList();
        Enumeration en = this.session(id).getAttributeNames();
        while (en.hasMoreElements()) {
            tl.add((String)en.nextElement());
        }
        return StrSeq.get((TokenList)tl);
    }

    public Item get(Str id, Str key) throws QueryException {
        return this.get(id, key, null);
    }

    private Item get(Str id, Str key, Item def) throws QueryException {
        Object o = this.session(id).getAttribute(key.toJava());
        if (o == null) {
            return def;
        }
        if (o instanceof Item) {
            return (Item)o;
        }
        throw SessionErrors.noAttribute(Util.className((Object)o));
    }

    public void set(Str id, Str key, Item item) throws QueryException {
        Item it = item;
        Data d = it.data();
        if (d != null && !d.inMemory()) {
            it = ((ANode)it).dbCopy(this.queryContext.context.options);
        } else if (it instanceof FItem) {
            throw SessionErrors.functionItem();
        }
        this.session(id).setAttribute(key.toJava(), (Object)it);
    }

    public void delete(Str id, Str key) throws QueryException {
        this.session(id).removeAttribute(key.toJava());
    }

    public void close(Str id) throws QueryException {
        this.session(id).invalidate();
    }

    private HttpSession session(Str id) throws QueryException {
        if (this.queryContext.http == null) {
            throw SessionErrors.noContext();
        }
        HashMap<String, HttpSession> http = SessionListener.sessions();
        HttpSession session = http.get(id.toJava());
        if (session == null) {
            throw SessionErrors.whichSession(id);
        }
        return session;
    }
}

