/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.webdav.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.basex.core.Command;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.core.cmd.AlterDB;
import org.basex.core.cmd.Copy;
import org.basex.core.cmd.CreateDB;
import org.basex.core.cmd.Delete;
import org.basex.core.cmd.DropDB;
import org.basex.core.cmd.Open;
import org.basex.core.cmd.Rename;
import org.basex.core.cmd.Set;
import org.basex.http.HTTPContext;
import org.basex.http.webdav.impl.ResourceMetaData;
import org.basex.http.webdav.impl.ResourceMetaDataFactory;
import org.basex.http.webdav.impl.Utils;
import org.basex.http.webdav.impl.WebDAVLockService;
import org.basex.http.webdav.impl.WebDAVQuery;
import org.basex.io.in.ArrayInput;
import org.basex.io.in.BufferInput;
import org.basex.query.func.FNDb;
import org.basex.query.func.Function;
import org.basex.server.LocalQuery;
import org.basex.server.LocalSession;
import org.basex.server.LoginException;
import org.basex.util.DateTime;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.list.StringList;
import org.basex.util.options.Option;

public final class WebDAVService<T> {
    private static final String WEBDAV_DB = "~webdav";
    private final HTTPContext http;
    private final ResourceMetaDataFactory<T> factory;
    public final WebDAVLockService locking;
    private LocalSession ls;

    public WebDAVService(ResourceMetaDataFactory<T> f, HTTPContext h) {
        this.factory = f;
        this.http = h;
        this.locking = new WebDAVLockService(this.http);
    }

    public void close() {
        if (this.ls != null) {
            this.ls.close();
        }
    }

    public void authenticate(String user, String pass) throws LoginException {
        this.http.credentials(user, pass);
        this.http.authenticate();
    }

    public static boolean authorize(String db) {
        return !WEBDAV_DB.equals(db);
    }

    public void deleteDummy(String db, String path) throws IOException {
        String dummy = path + '/' + ".empty";
        if (!this.pathExists(db, dummy)) {
            return;
        }
        LocalSession session = this.session();
        session.execute((Command)new Open(db));
        session.execute((Command)new Delete(dummy));
    }

    public boolean dbExists(String db) throws IOException {
        WebDAVQuery query = new WebDAVQuery(Function._DB_LIST.args(new Object[0]) + "[. = $db]").bind("db", db);
        return !this.execute(query).isEmpty();
    }

    public long timestamp(String db) throws IOException {
        WebDAVQuery query = new WebDAVQuery(Function.DATA.args(new Object[]{Function._DB_INFO.args(new Object[]{"$path"}) + "/descendant::" + FNDb.toName((String)Text.TIMESTAMP) + "[1]"})).bind("path", db);
        try {
            return DateTime.parse((String)this.execute(query).get(0), (DateFormat)DateTime.DATETIME).getTime();
        }
        catch (ParseException ex) {
            Util.errln((Object)ex, (Object[])new Object[0]);
            return 0L;
        }
    }

    private ResourceMetaData metaData(String db, String path) throws IOException {
        WebDAVQuery query = new WebDAVQuery("let $a := " + Function._DB_LIST_DETAILS.args(new Object[]{"$db", "$path"}) + "return (" + "string($a/@raw)," + "string($a/@content-type)," + "string($a/@modified-date)," + "string($a/@size)," + "string($a))");
        query.bind("db", db);
        query.bind("path", path);
        StringList result = this.execute(query);
        boolean raw = Boolean.parseBoolean(result.get(0));
        String ctype = result.get(1);
        long mod = DateTime.parse((String)result.get(2));
        Long size = raw ? Long.valueOf(result.get(3)) : null;
        String pth = Utils.stripLeadingSlash(result.get(4));
        return new ResourceMetaData(db, pth, mod, raw, ctype, size);
    }

    public void delete(String db, String path) throws IOException {
        LocalSession session = this.session();
        session.execute((Command)new Open(db));
        session.execute((Command)new Delete(path));
        int ix = path.lastIndexOf(47);
        if (ix > 0) {
            this.createDummy(db, path.substring(0, ix));
        }
    }

    public void rename(String db, String path, String npath) throws IOException {
        int i2;
        LocalSession session = this.session();
        session.execute((Command)new Open(db));
        session.execute((Command)new Rename(path, npath));
        int i1 = path.lastIndexOf(47);
        if (i1 > 0) {
            this.createDummy(db, path.substring(0, i1));
        }
        if ((i2 = npath.lastIndexOf(47)) > 0) {
            this.deleteDummy(db, npath.substring(0, i2));
        }
    }

    public void copyDoc(String db, String path, String tdb, String tpath) throws IOException {
        WebDAVQuery query = new WebDAVQuery("declare option db:chop 'false';if(" + Function._DB_IS_RAW.args(new Object[]{"$db", "$path"}) + ')' + " then " + Function._DB_STORE.args(new Object[]{"$tdb", "$tpath", Function._DB_RETRIEVE.args(new Object[]{"$db", "$path"})}) + " else " + Function._DB_ADD.args(new Object[]{"$tdb", Function._DB_OPEN.args(new Object[]{"$db", "$path"}), "$tpath"}));
        query.bind("db", db);
        query.bind("path", path);
        query.bind("tdb", tdb);
        query.bind("tpath", tpath);
        this.execute(query);
    }

    public void copyAll(String db, String path, String tdb, String tpath) throws IOException {
        WebDAVQuery query = new WebDAVQuery("declare option db:chop 'false'; for $d in " + Function._DB_LIST.args(new Object[]{"$db", "$path"}) + "let $t := $tpath ||'/'|| substring($d, string-length($path) + 1) return " + "if(" + Function._DB_IS_RAW.args(new Object[]{"$db", "$d"}) + ") " + "then " + Function._DB_STORE.args(new Object[]{"$tdb", "$t", Function._DB_RETRIEVE.args(new Object[]{"$db", "$d"})}) + " else " + Function._DB_ADD.args(new Object[]{"$tdb", Function._DB_OPEN.args(new Object[]{"$db", "$d"}), "$t"}));
        query.bind("db", db);
        query.bind("path", path);
        query.bind("tdb", tdb);
        query.bind("tpath", tpath);
        this.execute(query);
    }

    public void retrieve(String db, String path, boolean raw, OutputStream out) throws IOException {
        this.session().setOutputStream(out);
        WebDAVQuery query = new WebDAVQuery("declare option output:" + (raw ? "method 'raw'; " + Function._DB_RETRIEVE.args(new Object[]{"$db", "$path"}) : "use-character-maps 'webdav'; " + Function._DB_OPEN.args(new Object[]{"$db", "$path"})));
        query.bind("db", db);
        query.bind("path", path);
        this.execute(query);
    }

    public T createDb(String db) throws IOException {
        this.session().execute((Command)new CreateDB(db));
        return this.factory.database(this, new ResourceMetaData(db, this.timestamp(db)));
    }

    public void dropDb(String db) throws IOException {
        this.session().execute((Command)new DropDB(db));
    }

    public void renameDb(String db, String n) throws IOException {
        this.session().execute((Command)new AlterDB(db, n));
    }

    public void copyDb(String db, String n) throws IOException {
        this.session().execute((Command)new Copy(db, n));
    }

    public List<T> list(String db, String path) throws IOException {
        WebDAVQuery query = new WebDAVQuery(Function._DB_LIST_DETAILS.args(new Object[]{"$db", "$path"}) + " ! (" + "string(@raw), string(@content-type), string(@modified-date), string(@size)," + Function.SUBSTRING_AFTER.args(new Object[]{"text()", "$path"}) + ')');
        query.bind("db", db);
        query.bind("path", path);
        StringList result = this.execute(query);
        int rs = result.size();
        HashSet<String> paths = new HashSet<String>();
        ArrayList<T> ch = new ArrayList<T>(rs / 5);
        for (int r = 0; r < rs; r += 5) {
            boolean raw = Boolean.parseBoolean(result.get(r));
            String ctype = result.get(r + 1);
            long mod = DateTime.parse((String)result.get(r + 2));
            Long size = raw ? Long.valueOf(result.get(r + 3)) : null;
            String pth = Utils.stripLeadingSlash(result.get(r + 4));
            int ix = pth.indexOf(47);
            if (ix < 0) {
                if (pth.equals(".empty")) continue;
                ch.add(this.factory.file(this, new ResourceMetaData(db, path + '/' + pth, mod, raw, ctype, size)));
                continue;
            }
            String dir = path + '/' + pth.substring(0, ix);
            if (!paths.add(dir)) continue;
            ch.add(this.factory.folder(this, new ResourceMetaData(db, dir, mod)));
        }
        return ch;
    }

    public List<T> listDbs() throws IOException {
        WebDAVQuery query = new WebDAVQuery(Function._DB_LIST_DETAILS.args(new Object[0]) + "[. != $db] ! (text(), @modified-date/data())");
        query.bind("db", WEBDAV_DB);
        StringList result = this.execute(query);
        int rs = result.size();
        ArrayList<T> dbs = new ArrayList<T>(rs >>> 1);
        for (int r = 0; r < rs; r += 2) {
            String name = result.get(r);
            long mod = DateTime.parse((String)result.get(r + 1));
            dbs.add(this.factory.database(this, new ResourceMetaData(name, mod)));
        }
        return dbs;
    }

    public T createFolder(String db, String path, String name) throws IOException {
        this.deleteDummy(db, path);
        String newFolder = path + '/' + name;
        this.createDummy(db, newFolder);
        return this.factory.folder(this, new ResourceMetaData(db, newFolder, this.timestamp(db)));
    }

    public T resource(String db, String path) throws IOException {
        return this.exists(db, path) ? (T)this.factory.file(this, this.metaData(db, path)) : (this.pathExists(db, path) ? (T)this.factory.folder(this, new ResourceMetaData(db, path, this.timestamp(db))) : null);
    }

    public T createFile(String db, String path, String name, InputStream in) throws IOException {
        String dbp;
        LocalSession session = this.session();
        session.execute((Command)new Open(db));
        String string = dbp = path.isEmpty() ? name : path + '/' + name;
        if (this.pathExists(db, dbp)) {
            session.execute((Command)new Open(db));
            session.execute((Command)new Delete(dbp));
        } else {
            this.deleteDummy(db, path);
        }
        return this.addFile(db, dbp, in);
    }

    public T createFile(String n, InputStream in) throws IOException {
        return this.addFile(null, n, in);
    }

    private boolean pathExists(String db, String path) throws IOException {
        WebDAVQuery query = new WebDAVQuery(Function.EXISTS.args(new Object[]{Function._DB_LIST.args(new Object[]{"$db", "$path"})}));
        query.bind("db", db);
        query.bind("path", path);
        return this.execute(query).get(0).equals("true");
    }

    private boolean exists(String db, String path) throws IOException {
        WebDAVQuery query = new WebDAVQuery(Function._DB_EXISTS.args(new Object[]{"$db", "$path"}));
        query.bind("db", db);
        query.bind("path", path);
        return this.execute(query).get(0).equals("true");
    }

    private T createDb(String db, InputStream in) throws IOException {
        this.session().create(db, in);
        return this.factory.database(this, new ResourceMetaData(db, this.timestamp(db)));
    }

    private T addXML(String db, String path, InputStream in) throws IOException {
        LocalSession session = this.session();
        session.execute((Command)new Set((Option)MainOptions.CHOP, (Object)false));
        session.execute((Command)new Open(db));
        session.add(path, in);
        return this.factory.file(this, new ResourceMetaData(db, path, this.timestamp(db), false, "application/xml", null));
    }

    private T store(String db, String path, InputStream in) throws IOException {
        LocalSession session = this.session();
        session.execute((Command)new Open(db));
        session.store(path, in);
        return this.factory.file(this, this.metaData(db, path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private T addFile(String db, String path, InputStream in) throws IOException {
        bi = new BufferInput(in, 0x400000);
        try {
            if (Utils.peek(bi) != 60) ** GOTO lbl14
            try {
                var5_5 = db == null ? this.createDb(Utils.dbname(path), (InputStream)bi) : this.addXML(db, path, (InputStream)bi);
            }
            catch (IOException ex) {
                try {
                    bi.reset();
                }
                catch (IOException e) {
                    throw ex;
                }
lbl14:
                // 2 sources

                if (db == null) {
                    d = Utils.dbname(path);
                    this.createDb(d);
                } else {
                    d = db;
                }
                var6_9 = this.store(d, path, (InputStream)bi);
            }
            return var5_5;
            return var6_9;
            {
                catch (Throwable var7_10) {
                    throw var7_10;
                }
            }
        }
        finally {
            bi.close();
        }
    }

    private void createDummy(String db, String path) throws IOException {
        if (path.matches("[^/]") || this.pathExists(db, path)) {
            return;
        }
        LocalSession session = this.session();
        session.execute((Command)new Open(db));
        session.store(path + '/' + ".empty", (InputStream)new ArrayInput(Token.EMPTY));
    }

    private StringList execute(WebDAVQuery query) throws IOException {
        LocalQuery lq = this.session().query(query.toString());
        for (Map.Entry<String, Object> entry : query.entries()) {
            lq.bind(entry.getKey(), entry.getValue());
        }
        StringList sl = new StringList();
        while (lq.more()) {
            sl.add(lq.next());
        }
        return sl;
    }

    private LocalSession session() throws LoginException {
        if (this.ls == null) {
            this.ls = new LocalSession(this.http.authenticate(), this.http.user, this.http.pass);
        }
        return this.ls;
    }
}

