/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.webdav;

import com.bradmcevoy.http.AbstractResponse;
import com.bradmcevoy.http.Cookie;
import com.bradmcevoy.http.Response;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.basex.http.webdav.BXServletCookie;

final class BXServletResponse
extends AbstractResponse {
    private static final ThreadLocal<HttpServletResponse> RESPONSE = new ThreadLocal();
    private final HttpServletResponse res;
    private final Map<String, String> headers = new HashMap<String, String>();
    private Response.Status status;

    BXServletResponse(HttpServletResponse r) {
        this.res = r;
        RESPONSE.set(r);
    }

    protected void setAnyDateHeader(Response.Header name, Date date) {
        this.res.setDateHeader(name.code, date.getTime());
    }

    public String getNonStandardHeader(String code) {
        return this.headers.get(code);
    }

    public void setNonStandardHeader(String name, String value) {
        this.res.addHeader(name, value);
        this.headers.put(name, value);
    }

    public void setStatus(Response.Status s) {
        this.res.setStatus(s.code);
        this.status = s;
    }

    public Response.Status getStatus() {
        return this.status;
    }

    public OutputStream getOutputStream() {
        try {
            return this.res.getOutputStream();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void close() {
        try {
            this.res.flushBuffer();
            this.res.getOutputStream().flush();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void sendRedirect(String url) {
        try {
            this.res.sendRedirect(this.res.encodeRedirectURL(url));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public Map<String, String> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    public void setAuthenticateHeader(List<String> challenges) {
        for (String ch : challenges) {
            this.res.addHeader(Response.Header.WWW_AUTHENTICATE.code, ch);
        }
    }

    public Cookie setCookie(Cookie cookie) {
        if (cookie instanceof BXServletCookie) {
            this.res.addCookie(((BXServletCookie)cookie).cookie);
            return cookie;
        }
        javax.servlet.http.Cookie c = new javax.servlet.http.Cookie(cookie.getName(), cookie.getValue());
        c.setDomain(cookie.getDomain());
        c.setMaxAge(cookie.getExpiry());
        c.setPath(cookie.getPath());
        c.setSecure(cookie.getSecure());
        c.setVersion(cookie.getVersion());
        this.res.addCookie(c);
        return new BXServletCookie(c);
    }

    public Cookie setCookie(String name, String value) {
        javax.servlet.http.Cookie c = new javax.servlet.http.Cookie(name, value);
        this.res.addCookie(c);
        return new BXServletCookie(c);
    }
}

