/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.webdav;

import com.bradmcevoy.common.Path;
import com.bradmcevoy.http.Auth;
import com.bradmcevoy.http.HttpManager;
import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.ResourceFactory;
import javax.servlet.http.HttpServletRequest;
import org.basex.http.HTTPContext;
import org.basex.http.webdav.BXAbstractResource;
import org.basex.http.webdav.BXDatabase;
import org.basex.http.webdav.BXFile;
import org.basex.http.webdav.BXFolder;
import org.basex.http.webdav.BXNotAuthorizedResource;
import org.basex.http.webdav.BXRoot;
import org.basex.http.webdav.BXServletRequest;
import org.basex.http.webdav.impl.ResourceMetaData;
import org.basex.http.webdav.impl.ResourceMetaDataFactory;
import org.basex.http.webdav.impl.WebDAVService;
import org.basex.server.LoginException;
import org.basex.util.Util;

public final class BXResourceFactory
implements ResourceFactory,
ResourceMetaDataFactory<BXAbstractResource> {
    private final HTTPContext http;
    private final WebDAVService<BXAbstractResource> service;

    BXResourceFactory(HTTPContext ht) {
        this.http = ht;
        this.service = new WebDAVService<BXAbstractResource>(this, this.http);
    }

    void close() {
        this.service.close();
    }

    public Resource getResource(String host, String dbpath) {
        Auth a = HttpManager.request().getAuthorization();
        if (a != null) {
            this.http.credentials(a.getUser(), a.getPassword());
        }
        try {
            HttpServletRequest r = BXServletRequest.getRequest();
            Path p = Path.path((String)dbpath);
            if (!r.getContextPath().isEmpty()) {
                p = p.getStripFirst();
            }
            if (!r.getServletPath().isEmpty()) {
                p = p.getStripFirst();
            }
            if (p.isRoot()) {
                return new BXRoot(this.service);
            }
            String db = p.getFirst();
            return p.getLength() == 1 ? (this.service.dbExists(db) ? new BXDatabase(new ResourceMetaData(db, this.service.timestamp(db)), this.service) : null) : this.service.resource(db, p.getStripFirst().toString());
        }
        catch (LoginException ex) {
            return BXNotAuthorizedResource.NOAUTH;
        }
        catch (Exception ex) {
            Util.errln((Object)ex, (Object[])new Object[0]);
            return null;
        }
    }

    @Override
    public BXFile file(WebDAVService<BXAbstractResource> s, ResourceMetaData d) {
        return new BXFile(d, s);
    }

    @Override
    public BXFolder folder(WebDAVService<BXAbstractResource> s, ResourceMetaData d) {
        return new BXFolder(d, s);
    }

    @Override
    public BXDatabase database(WebDAVService<BXAbstractResource> s, ResourceMetaData d) {
        return new BXDatabase(d, s);
    }
}

