/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.webdav;

import com.bradmcevoy.http.Auth;
import com.bradmcevoy.http.DeletableCollectionResource;
import com.bradmcevoy.http.FolderResource;
import com.bradmcevoy.http.LockInfo;
import com.bradmcevoy.http.LockResult;
import com.bradmcevoy.http.LockTimeout;
import com.bradmcevoy.http.LockToken;
import com.bradmcevoy.http.LockingCollectionResource;
import com.bradmcevoy.http.Range;
import com.bradmcevoy.http.Request;
import com.bradmcevoy.http.exceptions.BadRequestException;
import com.bradmcevoy.http.exceptions.NotAuthorizedException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.basex.http.webdav.BXAbstractResource;
import org.basex.http.webdav.BXCode;
import org.basex.http.webdav.impl.ResourceMetaData;
import org.basex.http.webdav.impl.Utils;
import org.basex.http.webdav.impl.WebDAVService;
import org.basex.io.in.ArrayInput;
import org.basex.util.Token;
import org.basex.util.Util;

public class BXFolder
extends BXAbstractResource
implements FolderResource,
DeletableCollectionResource,
LockingCollectionResource {
    public BXFolder(ResourceMetaData d, WebDAVService<BXAbstractResource> s) {
        super(d, s);
    }

    public final Long getContentLength() {
        return null;
    }

    public final String getContentType(String accepts) {
        return null;
    }

    public final Date getCreateDate() {
        return null;
    }

    public final Long getMaxAgeSeconds(Auth auth) {
        return null;
    }

    public final void sendContent(OutputStream out, Range range, Map<String, String> params, String contentType) {
    }

    public final boolean isLockedOutRecursive(Request request) {
        return (Boolean)new BXCode<Boolean>((BXAbstractResource)this){

            @Override
            public Boolean get() throws IOException {
                return BXFolder.this.service.locking.conflictingLocks(BXFolder.this.meta.db, BXFolder.this.meta.path);
            }
        }.evalNoEx();
    }

    public BXFolder createCollection(final String folder) throws BadRequestException, NotAuthorizedException {
        return (BXFolder)new BXCode<BXFolder>((BXAbstractResource)this){

            @Override
            public BXFolder get() throws IOException {
                return (BXFolder)BXFolder.this.service.createFolder(BXFolder.this.meta.db, BXFolder.this.meta.path, folder);
            }
        }.eval();
    }

    public BXAbstractResource child(final String childName) throws BadRequestException, NotAuthorizedException {
        return (BXAbstractResource)new BXCode<BXAbstractResource>((BXAbstractResource)this){

            @Override
            public BXAbstractResource get() throws IOException {
                return (BXAbstractResource)BXFolder.this.service.resource(BXFolder.this.meta.db, BXFolder.this.meta.path + '/' + childName);
            }
        }.eval();
    }

    public List<BXAbstractResource> getChildren() throws BadRequestException, NotAuthorizedException {
        return (List)new BXCode<List<BXAbstractResource>>((BXAbstractResource)this){

            @Override
            public List<BXAbstractResource> get() throws IOException {
                return BXFolder.this.service.list(BXFolder.this.meta.db, BXFolder.this.meta.path);
            }
        }.eval();
    }

    public BXAbstractResource createNew(final String newName, final InputStream input, Long length, String contentType) throws BadRequestException, NotAuthorizedException {
        return (BXAbstractResource)new BXCode<BXAbstractResource>((BXAbstractResource)this){

            @Override
            public BXAbstractResource get() throws IOException {
                return (BXAbstractResource)BXFolder.this.service.createFile(BXFolder.this.meta.db, BXFolder.this.meta.path, newName, input);
            }
        }.eval();
    }

    public final LockToken createAndLock(String name, LockTimeout timeout, LockInfo lockInfo) {
        try {
            BXAbstractResource r = this.createNew(name, (InputStream)new ArrayInput(Token.EMPTY), 0L, null);
            LockResult lockResult = r.lock(timeout, lockInfo);
            if (lockResult.isSuccessful()) {
                return lockResult.getLockToken();
            }
        }
        catch (Exception ex) {
            Util.debug((Object)"Cannot lock and create requested resource", (Object[])new Object[]{ex});
        }
        return null;
    }

    @Override
    protected void copyToRoot(String name) throws IOException {
        String dbname = Utils.dbname(name);
        this.service.createDb(dbname);
        this.service.copyAll(this.meta.db, this.meta.path, dbname, "");
    }

    @Override
    protected final void copyTo(BXFolder folder, String name) throws IOException {
        this.service.copyAll(this.meta.db, this.meta.path, folder.meta.db, folder.meta.path + '/' + name);
        this.service.deleteDummy(folder.meta.db, folder.meta.path);
    }
}

