/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.webdav;

import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.exceptions.BadRequestException;
import com.bradmcevoy.http.exceptions.NotAuthorizedException;
import java.io.IOException;
import org.basex.http.webdav.BXAbstractResource;
import org.basex.server.LoginException;
import org.basex.util.Util;

abstract class BXCode<E> {
    private final BXAbstractResource resource;

    BXCode(BXAbstractResource res) {
        this.resource = res;
    }

    public final E eval() throws BadRequestException, NotAuthorizedException {
        try {
            E ret = this.get();
            if (ret == null) {
                this.run();
            }
            return ret;
        }
        catch (LoginException ex) {
            throw new NotAuthorizedException((Resource)this.resource);
        }
        catch (IOException ex) {
            Util.errln((Object)ex, (Object[])new Object[0]);
            throw new BadRequestException((Resource)this.resource, ex.getMessage());
        }
    }

    public final E evalNoEx() {
        try {
            return this.eval();
        }
        catch (Exception ex) {
            Util.errln((Object)ex, (Object[])new Object[0]);
            return null;
        }
    }

    public E get() throws IOException {
        return null;
    }

    public void run() throws IOException {
    }
}

