/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.webdav;

import com.bradmcevoy.http.Auth;
import com.bradmcevoy.http.CollectionResource;
import com.bradmcevoy.http.CopyableResource;
import com.bradmcevoy.http.DeletableResource;
import com.bradmcevoy.http.LockInfo;
import com.bradmcevoy.http.LockResult;
import com.bradmcevoy.http.LockTimeout;
import com.bradmcevoy.http.LockToken;
import com.bradmcevoy.http.LockableResource;
import com.bradmcevoy.http.MoveableResource;
import com.bradmcevoy.http.Request;
import com.bradmcevoy.http.exceptions.BadRequestException;
import com.bradmcevoy.http.exceptions.LockedException;
import com.bradmcevoy.http.exceptions.NotAuthorizedException;
import com.bradmcevoy.http.exceptions.PreConditionFailedException;
import java.io.IOException;
import java.io.StringReader;
import java.util.Date;
import java.util.Locale;
import org.basex.http.webdav.BXCode;
import org.basex.http.webdav.BXFolder;
import org.basex.http.webdav.BXRoot;
import org.basex.http.webdav.impl.ResourceMetaData;
import org.basex.http.webdav.impl.Utils;
import org.basex.http.webdav.impl.WebDAVService;
import org.basex.server.LoginException;
import org.basex.util.Util;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public abstract class BXAbstractResource
implements CopyableResource,
DeletableResource,
MoveableResource,
LockableResource {
    final ResourceMetaData meta;
    final WebDAVService<BXAbstractResource> service;

    BXAbstractResource(ResourceMetaData m, WebDAVService<BXAbstractResource> s) {
        this.meta = m;
        this.service = s;
    }

    public Object authenticate(final String user, final String pass) {
        if (user == null) {
            return null;
        }
        return new BXCode<Object>(this){

            @Override
            public String get() throws LoginException {
                BXAbstractResource.this.service.authenticate(user, pass);
                return user;
            }
        }.evalNoEx();
    }

    public boolean authorise(Request request, Request.Method method, Auth auth) {
        return auth != null && auth.getTag() != null && WebDAVService.authorize(this.meta.db);
    }

    public String checkRedirect(Request request) {
        return null;
    }

    public String getRealm() {
        return "BaseX";
    }

    public String getUniqueId() {
        return null;
    }

    public String getName() {
        return Utils.name(this.meta.path);
    }

    public Date getModifiedDate() {
        return this.meta.mdate;
    }

    public void delete() throws BadRequestException, NotAuthorizedException {
        new BXCode<Object>(this){

            @Override
            public void run() throws IOException {
                BXAbstractResource.this.del();
            }
        }.eval();
    }

    public void copyTo(final CollectionResource target, final String name) throws BadRequestException, NotAuthorizedException {
        new BXCode<Object>(this){

            @Override
            public void run() throws IOException {
                if (target instanceof BXRoot) {
                    BXAbstractResource.this.copyToRoot(name);
                } else if (target instanceof BXFolder) {
                    BXAbstractResource.this.copyTo((BXFolder)target, name);
                }
            }
        }.eval();
    }

    public void moveTo(final CollectionResource target, final String name) throws BadRequestException, NotAuthorizedException {
        new BXCode<Object>(this){

            @Override
            public void run() throws IOException {
                if (target instanceof BXRoot) {
                    BXAbstractResource.this.moveToRoot(name);
                } else if (target instanceof BXFolder) {
                    BXAbstractResource.this.moveTo((BXFolder)target, name);
                }
            }
        }.eval();
    }

    public LockResult lock(final LockTimeout timeout, final LockInfo lockInfo) throws NotAuthorizedException, PreConditionFailedException, LockedException {
        return (LockResult)new BXCode<LockResult>(this){

            @Override
            public LockResult get() throws IOException {
                return BXAbstractResource.this.lockResource(timeout, lockInfo);
            }
        }.evalNoEx();
    }

    public LockResult refreshLock(final String token) throws NotAuthorizedException, PreConditionFailedException {
        return (LockResult)new BXCode<LockResult>(this){

            @Override
            public LockResult get() throws IOException {
                return BXAbstractResource.this.refresh(token);
            }
        }.evalNoEx();
    }

    public void unlock(final String tokenId) throws NotAuthorizedException, PreConditionFailedException {
        new BXCode<Object>(this){

            @Override
            public void run() throws IOException {
                BXAbstractResource.this.service.locking.unlock(tokenId);
            }
        }.evalNoEx();
    }

    public LockToken getCurrentLock() {
        return (LockToken)new BXCode<LockToken>(this){

            @Override
            public LockToken get() throws IOException {
                return BXAbstractResource.this.getCurrentActiveLock();
            }
        }.evalNoEx();
    }

    void del() throws IOException {
        this.service.delete(this.meta.db, this.meta.path);
    }

    void rename(String n) throws IOException {
        this.service.rename(this.meta.db, this.meta.path, n);
    }

    protected abstract void copyToRoot(String var1) throws IOException;

    protected abstract void copyTo(BXFolder var1, String var2) throws IOException;

    void moveToRoot(String n) throws IOException {
        this.copyToRoot(n);
        this.del();
    }

    private void moveTo(BXFolder f, String n) throws IOException {
        if (f.meta.db.equals(this.meta.db)) {
            this.rename(f.meta.path + '/' + n);
        } else {
            this.copyTo(f, n);
            this.del();
        }
    }

    private LockResult lockResource(LockTimeout timeout, LockInfo lockInfo) throws IOException {
        String tokenId = this.service.locking.lock(this.meta.db, this.meta.path, lockInfo.scope.name().toLowerCase(Locale.ENGLISH), lockInfo.type.name().toLowerCase(Locale.ENGLISH), lockInfo.depth.name().toLowerCase(Locale.ENGLISH), lockInfo.lockedByUser, timeout.getSeconds());
        return LockResult.success((LockToken)new LockToken(tokenId, lockInfo, timeout));
    }

    private LockToken getCurrentActiveLock() throws IOException {
        String lockInfoStr = this.service.locking.lock(this.meta.db, this.meta.path);
        return lockInfoStr == null ? null : BXAbstractResource.parseLockInfo(lockInfoStr);
    }

    private LockResult refresh(String token) throws IOException {
        this.service.locking.refreshLock(token);
        String lockInfoStr = this.service.locking.lock(token);
        LockToken lockToken = lockInfoStr == null ? null : BXAbstractResource.parseLockInfo(lockInfoStr);
        return LockResult.success((LockToken)lockToken);
    }

    private static LockToken parseLockInfo(String lockInfo) throws IOException {
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader();
            LockTokenSaxHandler handler = new LockTokenSaxHandler();
            reader.setContentHandler(handler);
            reader.parse(new InputSource(new StringReader(lockInfo)));
            return handler.lockToken;
        }
        catch (SAXException ex) {
            Util.errln((Object)"Error while parsing lock info.", (Object[])new Object[0]);
            Util.debug((Throwable)ex);
            return null;
        }
    }

    private static final class LockTokenSaxHandler
    extends DefaultHandler {
        public final LockToken lockToken = new LockToken(null, new LockInfo(), null);
        private String elementName;

        private LockTokenSaxHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            this.elementName = localName;
            super.startElement(uri, localName, name, attributes);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.elementName = null;
            super.endElement(uri, localName, qName);
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            String v = String.valueOf(ch, start, length);
            if ("token".equals(this.elementName)) {
                this.lockToken.tokenId = v;
            } else if ("scope".equals(this.elementName)) {
                this.lockToken.info.scope = LockInfo.LockScope.valueOf((String)v.toUpperCase(Locale.ENGLISH));
            } else if ("type".equals(this.elementName)) {
                this.lockToken.info.type = LockInfo.LockType.valueOf((String)v.toUpperCase(Locale.ENGLISH));
            } else if ("depth".equals(this.elementName)) {
                this.lockToken.info.depth = LockInfo.LockDepth.valueOf((String)v.toUpperCase(Locale.ENGLISH));
            } else if ("owner".equals(this.elementName)) {
                this.lockToken.info.lockedByUser = v;
            } else if ("timeout".equals(this.elementName)) {
                this.lockToken.timeout = LockTimeout.parseTimeout((String)v);
            }
        }
    }
}

