/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.rest;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.basex.http.HTTPCode;
import org.basex.http.HTTPContext;
import org.basex.http.rest.RESTCmd;
import org.basex.http.rest.RESTCommand;
import org.basex.http.rest.RESTQuery;
import org.basex.http.rest.RESTRetrieve;
import org.basex.http.rest.RESTRun;
import org.basex.http.rest.RESTSession;
import org.basex.io.serial.SerializerOptions;
import org.basex.util.Token;
import org.basex.util.Util;

final class RESTGet {
    private RESTGet() {
    }

    public static RESTCmd get(RESTSession rs) throws IOException {
        HashMap<String, String[]> vars = new HashMap<String, String[]>();
        String op = null;
        String input = null;
        String value = null;
        HTTPContext http = rs.http;
        SerializerOptions sopts = http.sopts();
        for (Map.Entry<String, String[]> param : http.params.map().entrySet()) {
            String key = param.getKey();
            String[] vals = param.getValue();
            String val = vals[0];
            if (Token.eqic((String)key, (String[])new String[]{"command", "query", "run"})) {
                if (op != null || vals.length > 1) {
                    throw HTTPCode.ONEOP.get(new Object[0]);
                }
                op = key;
                input = val;
                continue;
            }
            if (key.equalsIgnoreCase("wrap")) {
                http.wrapping = Util.yes((String)val);
                continue;
            }
            if (key.equalsIgnoreCase("context")) {
                value = val;
                continue;
            }
            if (sopts.option(key) != null) {
                for (String v : vals) {
                    sopts.assign(key, v);
                }
                continue;
            }
            if (RESTCmd.parseOption(rs, param, false)) continue;
            vars.put(key, new String[]{val});
        }
        if (op == null) {
            return RESTRetrieve.get(rs);
        }
        if (op.equals("query")) {
            return RESTQuery.get(rs, input, vars, value);
        }
        if (op.equals("run")) {
            return RESTRun.get(rs, input, vars, value);
        }
        return RESTCommand.get(rs, input);
    }
}

