/*
 * Decompiled with CFR 0.152.
 */
package org.basex;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import javax.net.ssl.SSLHandshakeException;
import javax.servlet.ServletContext;
import org.basex.BaseXServer;
import org.basex.core.BaseXException;
import org.basex.core.Context;
import org.basex.core.GlobalOptions;
import org.basex.core.Text;
import org.basex.http.HTTPContext;
import org.basex.io.IOFile;
import org.basex.io.IOStream;
import org.basex.server.Log;
import org.basex.util.Main;
import org.basex.util.MainParser;
import org.basex.util.Performance;
import org.basex.util.Prop;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.options.BooleanOption;
import org.basex.util.options.NumberOption;
import org.basex.util.options.Option;
import org.basex.util.options.Options;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.server.ssl.SslSelectChannelConnector;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.xml.XmlConfiguration;

public final class BaseXHTTP
extends Main {
    private final Context context;
    private final Server jetty;
    private int httpPort;
    private boolean service;
    private boolean stopped;

    public static void main(String ... args) {
        try {
            new BaseXHTTP(args);
        }
        catch (Exception ex) {
            Util.errln((Object)ex, (Object[])new Object[0]);
            System.exit(1);
        }
    }

    public BaseXHTTP(String ... args) throws Exception {
        super(args);
        this.parseArgs();
        this.context = HTTPContext.init();
        GlobalOptions gopts = this.context.globalopts;
        String webapp = gopts.get(GlobalOptions.WEBPATH);
        WebAppContext wac = new WebAppContext(webapp, "/");
        this.jetty = (Server)new XmlConfiguration(BaseXHTTP.initJetty(webapp).inputStream()).configure();
        this.jetty.setHandler((Handler)wac);
        if (this.httpPort != 0) {
            for (Connector c : this.jetty.getConnectors()) {
                if (!(c instanceof SelectChannelConnector)) continue;
                c.setPort(this.httpPort);
                break;
            }
        }
        String startX = "HTTP " + Text.SRV_STARTED_PORT_X;
        final String stopX = "HTTP " + Text.SRV_STOPPED_PORT_X;
        if (this.stopped) {
            this.stop();
            for (Connector c : this.jetty.getConnectors()) {
                Util.outln((Object)stopX, (Object[])new Object[]{c.getPort()});
            }
            Performance.sleep((long)1000L);
            return;
        }
        if (this.service) {
            Connector connector = this.jetty.getConnectors()[0];
            BaseXHTTP.start(connector.getPort(), connector instanceof SslSelectChannelConnector, args);
            for (Connector c : this.jetty.getConnectors()) {
                Util.outln((Object)startX, (Object[])new Object[]{c.getPort()});
            }
            Performance.sleep((long)1000L);
            return;
        }
        if (!Options.getSystem((Option)GlobalOptions.USER).isEmpty()) {
            while (Options.getSystem((Option)GlobalOptions.PASSWORD).isEmpty()) {
                Util.out((Object)(Text.PASSWORD + ": "), (Object[])new Object[0]);
                Options.setSystem((Option)GlobalOptions.PASSWORD, (Object)Util.password());
            }
        }
        this.jetty.start();
        for (Connector c : this.jetty.getConnectors()) {
            Util.outln((Object)startX, (Object[])new Object[]{c.getPort()});
        }
        HTTPContext.init((ServletContext)wac.getServletContext());
        int stop = gopts.get(GlobalOptions.STOPPORT);
        if (stop >= 0) {
            new StopServer(gopts.get(GlobalOptions.SERVERHOST), stop).start();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                for (Connector c : BaseXHTTP.this.jetty.getConnectors()) {
                    Util.outln((Object)stopX, (Object[])new Object[]{c.getPort()});
                }
                Log l = ((BaseXHTTP)BaseXHTTP.this).context.log;
                if (l != null) {
                    for (Connector c : BaseXHTTP.this.jetty.getConnectors()) {
                        l.writeServer(new Object[]{"OK", Util.info((Object)stopX, (Object[])new Object[]{c.getPort()})});
                    }
                }
                BaseXHTTP.this.context.close();
            }
        });
        for (Connector c : this.jetty.getConnectors()) {
            this.context.log.writeServer(new Object[]{"OK", Util.info((Object)startX, (Object[])new Object[]{c.getPort()})});
        }
    }

    public void stop() throws Exception {
        GlobalOptions mprop = this.context.globalopts;
        int stop = BaseXHTTP.num(GlobalOptions.STOPPORT, mprop);
        if (stop >= 0) {
            BaseXHTTP.stop(stop);
        }
        if (!BaseXHTTP.bool(GlobalOptions.HTTPLOCAL, mprop)) {
            int port = BaseXHTTP.num(GlobalOptions.SERVERPORT, mprop);
            int eport = BaseXHTTP.num(GlobalOptions.EVENTPORT, mprop);
            BaseXServer.stop((int)port, (int)eport);
        }
    }

    private static int num(NumberOption option, GlobalOptions gopts) {
        String val = Options.getSystem((Option)option);
        return val.isEmpty() ? gopts.get(option) : Token.toInt((String)val);
    }

    private static boolean bool(BooleanOption option, GlobalOptions gopts) {
        String val = Options.getSystem((Option)option);
        return val.isEmpty() ? gopts.get(option) : Boolean.parseBoolean(val);
    }

    private static IOFile initJetty(String root) throws IOException {
        BaseXHTTP.locate("WEB-INF/web.xml", root);
        return BaseXHTTP.locate("WEB-INF/jetty.xml", root);
    }

    private static IOFile locate(String file, String root) throws IOException {
        byte[] data;
        IOFile trg = new IOFile(root + '/' + file);
        boolean create = !trg.exists();
        IOFile in = new IOFile("src/main/webapp/" + file);
        if (in.exists()) {
            data = in.read();
            IOFile res = new IOFile("src/main/resources/");
            if (!(!res.exists() || (res = new IOFile(res, file)).exists() && Token.eq((byte[])data, (byte[])res.read()))) {
                Util.errln((Object)("Updating " + res), (Object[])new Object[0]);
                res.dir().md();
                res.write(in.read());
            }
        } else if (create) {
            InputStream is = BaseXHTTP.class.getResourceAsStream('/' + file);
            if (is == null) {
                throw new BaseXException(in + " not found.", new Object[0]);
            }
            data = new IOStream(is).read();
        } else {
            return trg;
        }
        if (create) {
            Util.errln((Object)("Creating " + trg), (Object[])new Object[0]);
            trg.dir().md();
            trg.write(data);
        }
        return trg;
    }

    protected void parseArgs() throws IOException {
        MainParser arg = new MainParser((Main)this);
        boolean serve = true;
        block14: while (arg.more()) {
            if (arg.dash()) {
                switch (arg.next()) {
                    case 'd': {
                        Options.setSystem((Option)GlobalOptions.DEBUG, (Object)true);
                        Prop.debug = true;
                        continue block14;
                    }
                    case 'D': {
                        serve = false;
                        continue block14;
                    }
                    case 'e': {
                        Options.setSystem((Option)GlobalOptions.EVENTPORT, (Object)arg.number());
                        continue block14;
                    }
                    case 'h': {
                        this.httpPort = arg.number();
                        continue block14;
                    }
                    case 'l': {
                        Options.setSystem((Option)GlobalOptions.HTTPLOCAL, (Object)true);
                        continue block14;
                    }
                    case 'n': {
                        Options.setSystem((Option)GlobalOptions.HOST, (Object)arg.string());
                        continue block14;
                    }
                    case 'p': {
                        int p = arg.number();
                        Options.setSystem((Option)GlobalOptions.PORT, (Object)p);
                        Options.setSystem((Option)GlobalOptions.SERVERPORT, (Object)p);
                        continue block14;
                    }
                    case 'P': {
                        Options.setSystem((Option)GlobalOptions.PASSWORD, (Object)arg.string());
                        continue block14;
                    }
                    case 's': {
                        Options.setSystem((Option)GlobalOptions.STOPPORT, (Object)arg.number());
                        continue block14;
                    }
                    case 'S': {
                        this.service = serve;
                        continue block14;
                    }
                    case 'U': {
                        Options.setSystem((Option)GlobalOptions.USER, (Object)arg.string());
                        continue block14;
                    }
                    case 'z': {
                        Options.setSystem((Option)GlobalOptions.LOG, (Object)false);
                        continue block14;
                    }
                }
                throw arg.usage();
            }
            if (!"stop".equalsIgnoreCase(arg.string())) {
                throw arg.usage();
            }
            this.stopped = true;
        }
    }

    private static void start(int port, boolean ssl, String ... args) throws BaseXException {
        Util.start(BaseXHTTP.class, (String[])args);
        for (int c = 1; c < 10; ++c) {
            if (BaseXHTTP.ping("localhost", port, ssl)) {
                return;
            }
            Performance.sleep((long)((long)c * 100L));
        }
        throw new BaseXException(Text.CONNECTION_ERROR, new Object[0]);
    }

    private static File stopFile(int port) {
        return new File(Prop.TMP, Util.className(BaseXHTTP.class) + port);
    }

    private static void stop(int port) throws IOException {
        File stop = BaseXHTTP.stopFile(port);
        try {
            stop.createNewFile();
            new Socket("localhost", port).close();
            Performance.sleep((long)100L);
        }
        catch (IOException ex) {
            stop.delete();
            throw ex;
        }
    }

    private static boolean ping(String host, int port, boolean ssl) {
        try {
            new URL((ssl ? "https://" : "http://") + host + ':' + port).openConnection().getInputStream();
            return true;
        }
        catch (IOException ex) {
            return ex instanceof FileNotFoundException || ex instanceof SSLHandshakeException;
        }
    }

    public String header() {
        return Util.info((Object)Text.S_CONSOLE, (Object[])new Object[]{"HTTP"});
    }

    public String usage() {
        return Text.S_HTTPINFO;
    }

    private final class StopServer
    extends Thread {
        private final ServerSocket ss;
        private final File stop;

        StopServer(String host, int port) throws IOException {
            InetAddress addr = host.isEmpty() ? null : InetAddress.getByName(host);
            this.ss = new ServerSocket();
            this.ss.setReuseAddress(true);
            this.ss.bind(new InetSocketAddress(addr, port));
            this.stop = BaseXHTTP.stopFile(port);
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                do {
                    this.ss.accept().close();
                } while (!this.stop.exists());
                this.ss.close();
                this.stop.delete();
                BaseXHTTP.this.jetty.stop();
            }
            catch (Exception ex) {
                Util.errln((Object)ex, (Object[])new Object[0]);
            }
        }
    }
}

