/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.hash;

import java.util.Arrays;
import org.basex.util.hash.ASet;

public class IntSet
extends ASet {
    int[] keys;

    public IntSet() {
        this(8);
    }

    public IntSet(int capacity) {
        super(capacity);
        this.keys = new int[this.bucket.length];
    }

    public final boolean add(int key) {
        return this.index(key) > 0;
    }

    final int put(int key) {
        int i = this.index(key);
        return Math.abs(i);
    }

    public final boolean contains(int key) {
        return this.id(key) > 0;
    }

    final int id(int key) {
        int p = key & this.bucket.length - 1;
        int id = this.bucket[p];
        while (id != 0) {
            if (key == this.keys[id]) {
                return id;
            }
            id = this.next[id];
        }
        return 0;
    }

    public final int key(int id) {
        return this.keys[id];
    }

    int delete(int key) {
        int b = key & this.bucket.length - 1;
        int p = 0;
        int i = this.bucket[b];
        while (i != 0) {
            if (key == this.keys[i]) {
                if (p == 0) {
                    this.bucket[b] = this.next[i];
                } else {
                    this.next[p] = this.next[this.next[i]];
                }
                this.keys[i] = 0;
                return i;
            }
            p = i;
            i = this.next[i];
        }
        return 0;
    }

    private int index(int key) {
        this.checkSize();
        int b = key & this.bucket.length - 1;
        int r = this.bucket[b];
        while (r != 0) {
            if (key == this.keys[r]) {
                return -r;
            }
            r = this.next[r];
        }
        this.next[this.size] = this.bucket[b];
        this.keys[this.size] = key;
        this.bucket[b] = this.size;
        return this.size++;
    }

    @Override
    protected int hash(int id) {
        return this.keys[id];
    }

    @Override
    protected void rehash(int newSize) {
        this.keys = Arrays.copyOf(this.keys, newSize);
    }

    public final int[] toArray() {
        return Arrays.copyOfRange(this.keys, 1, this.size);
    }
}

