/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.ft;

import java.util.Collection;
import org.basex.util.TokenBuilder;
import org.basex.util.ft.FTIterator;
import org.basex.util.ft.InternalStemmer;
import org.basex.util.ft.Language;
import org.basex.util.ft.Stemmer;

final class IndonesianStemmer
extends InternalStemmer {
    private int numSyllables;
    private int flags;
    private static final int REMOVED_KE = 1;
    private static final int REMOVED_PENG = 2;
    private static final int REMOVED_DI = 4;
    private static final int REMOVED_MENG = 8;
    private static final int REMOVED_TER = 16;
    private static final int REMOVED_BER = 32;
    private static final int REMOVED_PE = 64;

    IndonesianStemmer(FTIterator fti) {
        super(fti);
    }

    @Override
    Stemmer get(Language l, FTIterator fti) {
        return new IndonesianStemmer(fti);
    }

    @Override
    Collection<Language> languages() {
        return IndonesianStemmer.collection("in");
    }

    @Override
    protected byte[] stem(byte[] word) {
        int n;
        TokenBuilder tb = new TokenBuilder(word);
        this.numSyllables = IndonesianStemmer.countSyllables(tb);
        int s = tb.size();
        if (this.numSyllables > 2) {
            this.remParticle(tb);
        }
        if (this.numSyllables > 2) {
            this.remPossesivePronous(tb);
        }
        if (this.numSyllables > 2) {
            this.remFirstPrefix(tb);
        }
        if ((n = tb.size()) != s) {
            if (this.numSyllables > 2) {
                this.remSuffix(tb);
                s = tb.size();
            }
            if (n != s && this.numSyllables > 2) {
                this.remSecondPrefix(tb);
                return tb.finish();
            }
            return tb.finish();
        }
        if (this.numSyllables > 2) {
            this.remSecondPrefix(tb);
        }
        if (this.numSyllables > 2) {
            this.remSuffix(tb);
        }
        return tb.finish();
    }

    private static int countSyllables(TokenBuilder tb) {
        int t = 0;
        int s = tb.size();
        for (int c = 0; c < s; ++c) {
            byte ch = tb.get(c);
            if (!IndonesianStemmer.isVowel(ch)) continue;
            ++t;
        }
        return t;
    }

    private static boolean isVowel(byte c) {
        switch (c) {
            case 97: 
            case 101: 
            case 105: 
            case 111: 
            case 117: {
                return true;
            }
        }
        return false;
    }

    private void remParticle(TokenBuilder tb) {
        int tl = tb.size();
        if (tl > 3) {
            byte c1 = tb.get(tl - 1);
            byte c2 = tb.get(tl - 2);
            byte c3 = tb.get(tl - 3);
            if (c3 == 107 && c2 == 97 && c1 == 104) {
                --this.numSyllables;
                tb.size(tl - 3);
            } else if (c3 == 108 && c2 == 97 && c1 == 104) {
                --this.numSyllables;
                tb.size(tl - 3);
            } else if (c3 == 112 && c2 == 117 && c1 == 110) {
                --this.numSyllables;
                tb.size(tl - 3);
            } else if (c3 == 116 && c2 == 97 && c1 == 104) {
                --this.numSyllables;
                tb.size(tl - 3);
            }
        }
    }

    private void remPossesivePronous(TokenBuilder tb) {
        int tl = tb.size();
        if (tl > 3) {
            byte c1 = tb.get(tl - 1);
            byte c2 = tb.get(tl - 2);
            byte c3 = tb.get(tl - 3);
            if (c2 == 107 && c1 == 117) {
                --this.numSyllables;
                tb.size(tl - 2);
            } else if (c2 == 109 && c1 == 117) {
                --this.numSyllables;
                tb.size(tl - 2);
            } else if (c3 == 110 && c2 == 121 && c1 == 97) {
                --this.numSyllables;
                tb.size(tl - 3);
            }
        }
    }

    private void remSuffix(TokenBuilder tb) {
        int tl = tb.size();
        if (tl > 3) {
            byte c1 = tb.get(tl - 1);
            byte c2 = tb.get(tl - 2);
            byte c3 = tb.get(tl - 3);
            if (c3 == 107 && c2 == 97 && c1 == 110 && (this.flags & 1) == 0 && (this.flags & 2) == 0 && (this.flags & 0x40) == 0) {
                --this.numSyllables;
                tb.size(tl - 3);
            } else if (c2 == 97 && c1 == 110 && (this.flags & 4) == 0 && (this.flags & 8) == 0 && (this.flags & 0x10) == 0) {
                --this.numSyllables;
                tb.size(tl - 2);
            } else if (c1 == 105 && c2 != 115 && (this.flags & 0x20) == 0 && (this.flags & 1) == 0 && (this.flags & 2) == 0) {
                --this.numSyllables;
                tb.size(tl - 1);
            }
        }
    }

    private void remFirstPrefix(TokenBuilder tb) {
        int tl = tb.size();
        if (tl > 4) {
            byte c1 = tb.get(0);
            byte c2 = tb.get(1);
            byte c3 = tb.get(2);
            byte c4 = tb.get(3);
            if (c1 == 109 && c2 == 101 && c3 == 110 && c4 == 103) {
                this.flags |= 8;
                --this.numSyllables;
                tb.delete(0, 4);
            } else if (c1 == 109 && c2 == 101 && c3 == 110 && c4 == 121 && tl > 4 && IndonesianStemmer.isVowel(tb.get(4))) {
                this.flags |= 8;
                int setS = 115;
                tb.set(3, (byte)115);
                --this.numSyllables;
                tb.delete(0, 3);
            } else if (c1 == 109 && c2 == 101 && c3 == 110) {
                this.flags |= 8;
                --this.numSyllables;
                tb.delete(0, 3);
            } else if (c1 == 109 && c2 == 101 && c3 == 109 && tl > 3 && IndonesianStemmer.isVowel(tb.get(3))) {
                this.flags |= 8;
                int setP = 112;
                tb.set(2, (byte)112);
                --this.numSyllables;
                tb.delete(0, 2);
            } else if (c1 == 109 && c2 == 101 && c3 == 109) {
                this.flags |= 8;
                --this.numSyllables;
                tb.delete(0, 3);
            } else if (c1 == 109 && c2 == 101) {
                this.flags |= 8;
                --this.numSyllables;
                tb.delete(0, 2);
            } else if (c1 == 112 && c2 == 101 && c3 == 110 && c4 == 103) {
                this.flags |= 2;
                --this.numSyllables;
                tb.delete(0, 4);
            } else if (c1 == 112 && c2 == 101 && c3 == 110 && c4 == 121 && tl > 4 && IndonesianStemmer.isVowel(tb.get(4))) {
                this.flags |= 2;
                int setS = 115;
                tb.set(3, (byte)115);
                --this.numSyllables;
                tb.delete(0, 3);
            } else if (c1 == 112 && c2 == 101 && c3 == 110 && tl > 4 && IndonesianStemmer.isVowel(tb.get(3))) {
                this.flags |= 2;
                int setT = 116;
                tb.set(2, (byte)116);
                --this.numSyllables;
                tb.delete(0, 2);
            } else if (c1 == 112 && c2 == 101 && c3 == 110) {
                this.flags |= 2;
                --this.numSyllables;
                tb.delete(0, 3);
            } else if (c1 == 112 && c2 == 101 && c3 == 109 && tl > 4 && IndonesianStemmer.isVowel(tb.get(3))) {
                this.flags |= 2;
                int setP = 112;
                tb.set(2, (byte)112);
                --this.numSyllables;
                tb.delete(0, 2);
            } else if (c1 == 112 && c2 == 101 && c3 == 109) {
                this.flags |= 2;
                --this.numSyllables;
                tb.delete(0, 3);
            } else if (c1 == 100 && c2 == 105) {
                this.flags |= 4;
                --this.numSyllables;
                tb.delete(0, 2);
            } else if (c1 == 116 && c2 == 101 && c3 == 114) {
                this.flags |= 0x10;
                --this.numSyllables;
                tb.delete(0, 3);
            } else if (c1 == 107 && c2 == 101) {
                this.flags |= 1;
                --this.numSyllables;
                tb.delete(0, 2);
            }
        }
    }

    private void remSecondPrefix(TokenBuilder tb) {
        int tl = tb.size();
        if (tl > 4) {
            byte c1 = tb.get(0);
            byte c2 = tb.get(1);
            byte c3 = tb.get(2);
            byte c4 = tb.get(3);
            if (c1 == 98 && c2 == 101 && c3 == 114) {
                this.flags |= 0x20;
                --this.numSyllables;
                tb.delete(0, 3);
            } else if (c1 == 98 && c2 == 101 && c3 == 108 && c4 == 97 && tl > 7) {
                if (tb.get(4) == 106 && tb.get(5) == 97 && tb.get(6) == 114) {
                    this.flags |= 0x20;
                    --this.numSyllables;
                    tb.delete(0, 3);
                }
            } else if (c1 == 98 && c2 == 101 && !IndonesianStemmer.isVowel(tb.get(2)) && c4 == 101 && tl > 4) {
                if (tb.get(4) == 114) {
                    this.flags |= 0x20;
                    --this.numSyllables;
                    tb.delete(0, 2);
                }
            } else if (c1 == 112 && c2 == 101 && c3 == 114) {
                this.flags |= 0x40;
                --this.numSyllables;
                tb.delete(0, 3);
            } else if (c1 == 98 && c2 == 101 && c3 == 108 && c4 == 97 && tl > 7) {
                if (tb.get(4) == 106 && tb.get(5) == 97 && tb.get(6) == 114) {
                    this.flags |= 0x40;
                    --this.numSyllables;
                    tb.delete(0, 3);
                }
            } else if (c1 == 112 && c2 == 101) {
                this.flags |= 0x40;
                --this.numSyllables;
                tb.delete(0, 2);
            }
        }
    }
}

