/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.basex.util.Util;

public final class DateTime {
    public static final String PATTERN = "-\\d{4}-\\d{2}-\\d{2}-\\d{2}-\\d{2}-\\d{2}";
    public static final SimpleDateFormat FULL = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    public static final SimpleDateFormat DATETIME = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
    public static final SimpleDateFormat DATE = new SimpleDateFormat("yyyy-MM-dd");
    public static final SimpleDateFormat TIME = new SimpleDateFormat("HH:mm:ss.SSS");
    public static final SimpleDateFormat ZONE = new SimpleDateFormat("Z");

    private DateTime() {
    }

    public static long parse(String date) {
        try {
            return DateTime.parse(date, FULL).getTime();
        }
        catch (ParseException ex) {
            Util.errln(ex, new Object[0]);
            return 0L;
        }
    }

    public static synchronized String format(Date date, DateFormat format) {
        return format.format(date);
    }

    public static synchronized Date parse(String date, DateFormat format) throws ParseException {
        return format.parse(date);
    }

    static {
        FULL.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

