/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util;

import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.list.ByteList;

public final class Base64 {
    private static final byte[] ENDING = Token.token("AQgw");
    private static final byte[] ENDING2 = Token.token("AEIMQUYcgkosw048");
    private static final byte[] H2B = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private static final byte[] B2H = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51};

    private Base64() {
    }

    public static String encode(String token) {
        return Token.string(Base64.encode(Token.token(token)));
    }

    public static byte[] encode(byte[] token) {
        ByteList bl = new ByteList();
        int a = token.length;
        int f = a / 3;
        int p = a - 3 * f;
        int c = 0;
        for (int i = 0; i < f; ++i) {
            int b0 = token[c++] & 0xFF;
            int b1 = token[c++] & 0xFF;
            int b2 = token[c++] & 0xFF;
            bl.add(H2B[b0 >> 2]);
            bl.add(H2B[b0 << 4 & 0x3F | b1 >> 4]);
            bl.add(H2B[b1 << 2 & 0x3F | b2 >> 6]);
            bl.add(H2B[b2 & 0x3F]);
        }
        if (p != 0) {
            int b0 = token[c++] & 0xFF;
            bl.add(H2B[b0 >> 2]);
            if (p == 1) {
                bl.add(H2B[b0 << 4 & 0x3F]);
                bl.add(61);
                bl.add(61);
            } else {
                int b1 = token[c] & 0xFF;
                bl.add(H2B[b0 << 4 & 0x3F | b1 >> 4]);
                bl.add(H2B[b1 << 2 & 0x3F]);
                bl.add(61);
            }
        }
        return bl.toArray();
    }

    public static String decode(String token) {
        return Token.string(Base64.decode(Token.token(token)));
    }

    public static byte[] decode(byte[] token) {
        ByteList bl = new ByteList();
        for (byte c : token) {
            if (c >= 0 && c <= 32) continue;
            bl.add(c);
        }
        byte[] s = bl.toArray();
        if ((s.length & 3) != 0) {
            throw Base64.error(s);
        }
        int l = s.length;
        int g = l >>> 2;
        int m = 0;
        int n = g;
        if (l != 0) {
            if (s[l - 1] == 61) {
                ++m;
                --n;
            }
            if (s[l - 2] == 61) {
                ++m;
                if (!Token.contains(ENDING, s[l - 3])) {
                    throw Base64.error(Token.substring(s, l - 3));
                }
            }
            if (m == 1 && !Token.contains(ENDING2, s[l - 2])) {
                throw Base64.error(Token.substring(s, l - 4));
            }
        }
        byte[] val = new byte[3 * g - m];
        int c = 0;
        int o = 0;
        for (int i = 0; i < n; ++i) {
            int c0 = Base64.b2h(s[c++]);
            int c1 = Base64.b2h(s[c++]);
            int c2 = Base64.b2h(s[c++]);
            int c3 = Base64.b2h(s[c++]);
            val[o++] = (byte)(c0 << 2 | c1 >> 4);
            val[o++] = (byte)(c1 << 4 | c2 >> 2);
            val[o++] = (byte)(c2 << 6 | c3);
        }
        if (m != 0) {
            int c0 = Base64.b2h(s[c++]);
            int c1 = Base64.b2h(s[c++]);
            val[o++] = (byte)(c0 << 2 | c1 >> 4);
            if (m == 1) {
                val[o] = (byte)(c1 << 4 | Base64.b2h(s[c]) >> 2);
            }
        }
        return val;
    }

    private static int b2h(byte c) {
        if (c < 0 || c >= B2H.length) {
            throw Base64.error(Character.valueOf((char)c));
        }
        byte result = B2H[c];
        if (result < 0) {
            throw Base64.error(Character.valueOf((char)c));
        }
        return result;
    }

    private static IllegalArgumentException error(Object a) {
        return new IllegalArgumentException(Util.info("Invalid Base64 cast: %.", a));
    }
}

