/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.var;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ParseExpr;
import org.basex.query.iter.Iter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.FElem;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.query.var.VarUsage;
import org.basex.util.InputInfo;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.IntObjMap;

public final class VarRef
extends ParseExpr {
    public final Var var;

    public VarRef(InputInfo ii, Var v) {
        super(ii);
        this.var = v;
    }

    @Override
    public Expr compile(QueryContext ctx, VarScope scp) {
        return this.optimize(ctx, scp);
    }

    @Override
    public VarRef optimize(QueryContext ctx, VarScope scp) {
        this.type = this.var.type();
        this.size = this.var.size;
        return this;
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        return ctx.get(this.var).item(ctx, ii);
    }

    @Override
    public Iter iter(QueryContext ctx) {
        return ctx.get(this.var).iter();
    }

    @Override
    public Value value(QueryContext ctx) {
        return ctx.get(this.var);
    }

    @Override
    public boolean removable(Var v) {
        return true;
    }

    @Override
    public VarUsage count(Var v) {
        return this.var.is(v) ? VarUsage.ONCE : VarUsage.NEVER;
    }

    @Override
    public Expr inline(QueryContext ctx, VarScope scp, Var v, Expr e) {
        return v.is(this.var) ? (e.isValue() ? e : e.copy(ctx, scp)) : null;
    }

    @Override
    public VarRef copy(QueryContext ctx, VarScope scp, IntObjMap<Var> vs) {
        Var nw = vs.get(this.var.id);
        return new VarRef(this.info, nw != null ? nw : this.var).optimize(ctx, scp);
    }

    @Override
    public boolean sameAs(Expr cmp) {
        return cmp instanceof VarRef && this.var.is(((VarRef)cmp).var);
    }

    @Override
    public void plan(FElem plan) {
        FElem e = this.planElem(new Object[0]);
        this.var.plan(e);
        plan.add(e);
    }

    @Override
    public String description() {
        return "Variable";
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return visitor.used(this);
    }

    @Override
    public void checkUp() {
    }

    @Override
    public String toString() {
        return new TokenBuilder("$").add(this.var.name.toString()).add(95).addInt(this.var.id).toString();
    }

    @Override
    public boolean has(Expr.Flag flag) {
        return false;
    }

    @Override
    public int exprSize() {
        return 1;
    }
}

