/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.var;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.value.Value;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.Util;

public final class QueryStack {
    private static final int INIT = 32;
    private Value[] stack = new Value[32];
    private int fp;
    private int sl;

    public int enterFrame(int size) {
        int nsl = this.sl + size;
        this.ensureCapacity(nsl);
        int ret = this.fp;
        this.fp = this.sl;
        this.sl = nsl;
        return ret;
    }

    public void reuseFrame(int newFrameSize) {
        this.ensureCapacity(this.fp + newFrameSize);
        while (--this.sl >= this.fp) {
            this.stack[this.sl] = null;
        }
        this.sl = this.fp + newFrameSize;
    }

    public void exitFrame(int fpt) {
        while (--this.sl >= this.fp) {
            this.stack[this.sl] = null;
        }
        this.sl = this.fp;
        this.fp = fpt;
        if (this.stack.length > 32 && this.sl <= this.stack.length / 4) {
            int len = this.stack.length;
            while ((len /= 2) > 32 && this.sl <= len / 4) {
            }
            Value[] nst = new Value[len];
            System.arraycopy(this.stack, 0, nst, 0, this.sl);
            this.stack = nst;
        }
    }

    private void ensureCapacity(int newSize) {
        if (newSize > this.stack.length) {
            int len = this.stack.length;
            while (newSize > (len <<= 1)) {
            }
            Value[] nst = new Value[len];
            System.arraycopy(this.stack, 0, nst, 0, this.sl);
            this.stack = nst;
        }
    }

    private int pos(Var v) {
        int pos = this.fp + v.slot;
        if (pos < this.fp || this.sl <= pos) {
            throw Util.notExpected(v);
        }
        return pos;
    }

    public Value get(Var var) {
        return this.stack[this.pos(var)];
    }

    public void set(Var var, Value val, QueryContext ctx, InputInfo ii) throws QueryException {
        this.stack[this.pos((Var)var)] = var.checkType(val, ctx, ii, false);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(Util.className(this)).append('[');
        for (int i = 0; i < this.sl; ++i) {
            sb.append(i == 0 ? "" : ", ").append(this.stack[i]);
        }
        return sb.append(']').toString();
    }
}

