/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.seq;

import java.util.Arrays;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.value.Value;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.NativeSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Type;

public final class BlnSeq
extends NativeSeq {
    private final boolean[] values;

    private BlnSeq(boolean[] vals) {
        super(vals.length, (Type)AtomType.BLN);
        this.values = vals;
    }

    @Override
    public Bln itemAt(long pos) {
        return Bln.get(this.values[(int)pos]);
    }

    @Override
    public boolean sameAs(Expr cmp) {
        return cmp instanceof BlnSeq && Arrays.equals(this.values, ((BlnSeq)cmp).values);
    }

    public boolean[] toJava() {
        return this.values;
    }

    @Override
    public Value reverse() {
        int s = this.values.length;
        boolean[] tmp = new boolean[s];
        int l = 0;
        int r = s - 1;
        while (l < s) {
            tmp[l] = this.values[r];
            ++l;
            --r;
        }
        return BlnSeq.get(tmp);
    }

    public static Value get(boolean[] items) {
        return items.length == 0 ? Empty.SEQ : (items.length == 1 ? Bln.get(items[0]) : new BlnSeq(items));
    }

    public static Value get(Value[] vals, int size) throws QueryException {
        boolean[] tmp = new boolean[size];
        int t = 0;
        for (Value val : vals) {
            int vs = (int)val.size();
            if (val instanceof Item) {
                tmp[t++] = ((Item)val).bool(null);
                continue;
            }
            if (val instanceof BlnSeq) {
                BlnSeq sq = (BlnSeq)val;
                System.arraycopy(sq.values, 0, tmp, t, vs);
                t += vs;
                continue;
            }
            for (int v = 0; v < vs; ++v) {
                tmp[t++] = val.itemAt(v).bool(null);
            }
        }
        return BlnSeq.get(tmp);
    }
}

