/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.node;

import org.basex.data.ExprInfo;
import org.basex.query.QueryText;
import org.basex.query.iter.AxisMoreIter;
import org.basex.query.util.ANodeList;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.FAttr;
import org.basex.query.value.node.FComm;
import org.basex.query.value.node.FNames;
import org.basex.query.value.node.FNode;
import org.basex.query.value.node.FPI;
import org.basex.query.value.node.FTxt;
import org.basex.query.value.type.NodeType;
import org.basex.util.Atts;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.TokenMap;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public final class FElem
extends FNode {
    private final QNm name;
    private ANodeList children;
    private ANodeList atts;
    private Atts ns;

    public FElem(String nm) {
        this(Token.token(nm));
    }

    public FElem(byte[] nm) {
        this(QNm.get(nm));
    }

    public FElem(byte[] local, byte[] uri) {
        this(Token.EMPTY, local, uri);
    }

    public FElem(String local, String uri) {
        this(Token.EMPTY, Token.token(local), Token.token(uri));
    }

    public FElem(String prefix, String local, String uri) {
        this(Token.token(prefix), Token.token(local), Token.token(uri));
    }

    public FElem(byte[] prefix, byte[] local, byte[] uri) {
        this(QNm.get(prefix, local, uri));
    }

    public FElem(QNm n) {
        this(n, null);
    }

    private FElem(QNm n, Atts nsp) {
        this(n, nsp, null, null);
    }

    public FElem(QNm nm, Atts nsp, ANodeList ch, ANodeList at) {
        super(NodeType.ELM);
        this.name = nm;
        this.children = ch;
        this.atts = at;
        this.ns = nsp;
    }

    public FElem(Element elem, ANode p, TokenMap nss) {
        super(NodeType.ELM);
        int i;
        String nu = elem.getNamespaceURI();
        this.name = new QNm(elem.getNodeName(), nu == null ? Token.EMPTY : Token.token(nu));
        this.par = p;
        this.ns = new Atts();
        NamedNodeMap at = elem.getAttributes();
        int as = at.getLength();
        for (i = 0; i < as; ++i) {
            Attr att = (Attr)at.item(i);
            byte[] nm = Token.token(att.getName());
            byte[] uri = Token.token(att.getValue());
            if (Token.eq(nm, Token.XMLNS)) {
                this.ns.add(Token.EMPTY, uri);
                continue;
            }
            if (Token.startsWith(nm, Token.XMLNSC)) {
                this.ns.add(Token.local(nm), uri);
                continue;
            }
            this.add(new FAttr(att));
        }
        for (i = 0; i < this.ns.size(); ++i) {
            nss.put(this.ns.name(i), this.ns.value(i));
        }
        if (p == null) {
            FElem.nsScope(elem.getParentNode(), nss);
            for (byte[] pref : nss) {
                if (this.ns.contains(pref)) continue;
                this.ns.add(pref, nss.get(pref));
            }
        }
        byte[] pref = this.name.prefix();
        byte[] uri = this.name.uri();
        byte[] old = nss.get(pref);
        if (old == null || !Token.eq(uri, old)) {
            this.ns.add(pref, uri);
            nss.put(pref, uri);
        }
        NodeList ch = elem.getChildNodes();
        block9: for (int i2 = 0; i2 < ch.getLength(); ++i2) {
            Node child = ch.item(i2);
            switch (child.getNodeType()) {
                case 3: {
                    this.add(new FTxt((Text)child));
                    continue block9;
                }
                case 8: {
                    this.add(new FComm((Comment)child));
                    continue block9;
                }
                case 7: {
                    this.add(new FPI((ProcessingInstruction)child));
                    continue block9;
                }
                case 1: {
                    this.add(new FElem((Element)child, this, nss));
                    continue block9;
                }
            }
        }
        this.optimize();
    }

    private static void nsScope(Node elem, TokenMap nss) {
        Node n = elem;
        while (n instanceof Element) {
            NamedNodeMap atts = n.getAttributes();
            byte[] pref = Token.token(n.getPrefix());
            if (nss.get(pref) != null) {
                nss.put(pref, Token.token(n.getNamespaceURI()));
            }
            int len = atts.getLength();
            for (int i = 0; i < len; ++i) {
                byte[] ln;
                Attr a = (Attr)atts.item(i);
                byte[] name = Token.token(a.getName());
                byte[] val = Token.token(a.getValue());
                if (Token.eq(name, Token.XMLNS)) {
                    if (nss.get(Token.EMPTY) != null) continue;
                    nss.put(Token.EMPTY, val);
                    continue;
                }
                if (!Token.startsWith(name, Token.XMLNS) || nss.get(ln = Token.local(name)) != null) continue;
                nss.put(ln, val);
            }
            n = n.getParentNode();
        }
    }

    @Override
    public FElem optimize() {
        if (this.children != null) {
            for (ANode n : this.children) {
                n.parent(this);
            }
            if (this.children.isEmpty()) {
                this.children = null;
            }
        }
        if (this.atts != null) {
            for (ANode n : this.atts) {
                n.parent(this);
            }
            if (this.atts.isEmpty()) {
                this.atts = null;
            }
        }
        if (this.ns != null && this.ns.isEmpty()) {
            this.ns = null;
        }
        return this;
    }

    public FElem declareNS() {
        this.namespaces().add(this.name.prefix(), this.name.uri());
        return this;
    }

    public FElem add(ANode node) {
        if (node.type == NodeType.ATT) {
            if (this.atts == null) {
                this.atts = new ANodeList(node);
            } else {
                this.atts.add(node);
            }
        } else if (this.children == null) {
            this.children = new ANodeList(node);
        } else {
            this.children.add(node);
        }
        node.parent(this);
        return this;
    }

    public FElem add(String nm, String value) {
        return this.add(Token.token(nm), Token.token(value));
    }

    public FElem add(byte[] nm, String value) {
        return this.add(nm, Token.token(value));
    }

    public FElem add(String nm, byte[] value) {
        return this.add(Token.token(nm), value);
    }

    public FElem add(byte[] nm, byte[] value) {
        return this.add(new FAttr(nm, value));
    }

    public FElem add(QNm nm, String value) {
        return this.add(nm, Token.token(value));
    }

    public FElem add(QNm nm, byte[] value) {
        return this.add(new FAttr(nm, value));
    }

    public FElem add(String text) {
        return this.add(Token.token(text));
    }

    public FElem add(byte[] text) {
        if (text.length != 0) {
            FTxt txt = new FTxt(text);
            if (this.children == null) {
                this.children = new ANodeList(txt);
            } else {
                this.children.add(txt);
            }
            txt.parent(this);
        }
        return this;
    }

    @Override
    public Atts namespaces() {
        if (this.ns == null) {
            this.ns = new Atts();
        }
        return this.ns;
    }

    @Override
    public byte[] string() {
        return this.children == null ? Token.EMPTY : this.string(this.children);
    }

    @Override
    public byte[] baseURI() {
        byte[] b = this.attribute(new QNm(QueryText.BASE, QueryText.XMLURI));
        return b != null ? b : Token.EMPTY;
    }

    @Override
    public QNm qname() {
        return this.name;
    }

    @Override
    public byte[] name() {
        return this.name.string();
    }

    @Override
    public AxisMoreIter attributes() {
        return this.atts != null ? FElem.iter(this.atts) : super.attributes();
    }

    @Override
    public AxisMoreIter children() {
        return this.children != null ? FElem.iter(this.children) : super.children();
    }

    @Override
    public boolean hasChildren() {
        return this.children != null && !this.children.isEmpty();
    }

    @Override
    public FElem copy() {
        ANodeList ch = this.children != null ? new ANodeList(this.children.size()) : null;
        ANodeList at = this.atts != null ? new ANodeList(this.atts.size()) : null;
        Atts as = this.ns != null ? new Atts() : null;
        FElem node = new FElem(this.name, as, ch, at);
        if (this.ns != null) {
            for (int n = 0; n < this.ns.size(); ++n) {
                as.add(this.ns.name(n), this.ns.value(n));
            }
        }
        if (this.atts != null) {
            for (ANode n : this.atts) {
                at.add(n.copy());
            }
        }
        if (this.children != null) {
            for (ANode n : this.children) {
                ch.add(n.copy());
            }
        }
        node.parent(this.par);
        return node.optimize();
    }

    @Override
    public void plan(FElem plan) {
        this.addPlan(plan, this.planElem(QueryText.NAM, this.name.string()), new ExprInfo[0]);
    }

    @Override
    public String toString() {
        TokenBuilder tb = new TokenBuilder().add(60).add(this.name.string());
        if (this.ns != null) {
            for (int n = 0; n < this.ns.size(); ++n) {
                tb.add(new FNames(this.ns.name(n), this.ns.value(n)).toString());
            }
        }
        if (this.atts != null) {
            for (ANode n : this.atts) {
                tb.add(n.toString());
            }
        }
        if (this.hasChildren()) {
            tb.add(">...</").add(this.name.string());
        } else {
            tb.add("/");
        }
        return tb.add(">").toString();
    }
}

