/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.map;

import org.basex.query.QueryException;
import org.basex.query.iter.ValueBuilder;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.map.Leaf;
import org.basex.query.value.map.List;
import org.basex.query.value.map.TrieNode;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.SeqType;
import org.basex.util.InputInfo;

final class Branch
extends TrieNode {
    private final TrieNode[] kids;
    final int used;
    private static final String[] ENDS = new String[]{"|-- ", "|   ", "`-- ", "    "};

    Branch(TrieNode[] ch, int u, int s) {
        super(s);
        this.kids = ch;
        this.used = u;
        assert (this.verify());
    }

    TrieNode[] copyKids() {
        TrieNode[] copy = new TrieNode[32];
        System.arraycopy(this.kids, 0, copy, 0, 32);
        return copy;
    }

    @Override
    TrieNode insert(int h, Item k, Value v, int l, InputInfo ii) throws QueryException {
        int rem;
        int bs;
        TrieNode nsub;
        int key = Branch.key(h, l);
        TrieNode sub = this.kids[key];
        if (sub != null) {
            nsub = sub.insert(h, k, v, l + 1, ii);
            if (nsub == sub) {
                return this;
            }
            bs = this.used;
            rem = sub.size;
        } else {
            nsub = new Leaf(h, k, v);
            bs = this.used | 1 << key;
            rem = 0;
        }
        TrieNode[] ks = this.copyKids();
        ks[key] = nsub;
        return new Branch(ks, bs, this.size - rem + nsub.size);
    }

    @Override
    TrieNode delete(int h, Item k, int l, InputInfo ii) throws QueryException {
        int nu;
        int key = Branch.key(h, l);
        TrieNode sub = this.kids[key];
        if (sub == null) {
            return this;
        }
        TrieNode nsub = sub.delete(h, k, l + 1, ii);
        if (nsub == sub) {
            return this;
        }
        if (nsub == null) {
            TrieNode single;
            nu = this.used ^ 1 << key;
            if (Integer.bitCount(nu) == 1 && !((single = this.kids[Integer.numberOfTrailingZeros(nu)]) instanceof Branch)) {
                return single;
            }
        } else {
            nu = this.used;
        }
        TrieNode[] ks = this.copyKids();
        ks[key] = nsub;
        return new Branch(ks, nu, this.size - 1);
    }

    @Override
    Value get(int h, Item k, int l, InputInfo ii) throws QueryException {
        int key = Branch.key(h, l);
        TrieNode sub = this.kids[key];
        return sub == null ? null : sub.get(h, k, l + 1, ii);
    }

    @Override
    boolean contains(int h, Item k, int l, InputInfo ii) throws QueryException {
        int key = Branch.key(h, l);
        TrieNode sub = this.kids[key];
        return sub != null && sub.contains(h, k, l + 1, ii);
    }

    @Override
    StringBuilder toString(StringBuilder sb, String ind) {
        int s = Integer.bitCount(this.used);
        int i = 0;
        int j = 0;
        while (i < s) {
            while ((this.used & 1 << j) == 0) {
                ++j;
            }
            int e = i == s - 1 ? 2 : 0;
            sb.append(ind).append(ENDS[e]).append(String.format("%x", j)).append('\n');
            this.kids[j].toString(sb, ind + ENDS[e + 1]);
            ++i;
            ++j;
        }
        return sb;
    }

    @Override
    TrieNode addAll(TrieNode o, int l, InputInfo ii) throws QueryException {
        return o.add(this, l, ii);
    }

    @Override
    TrieNode add(Leaf o, int l, InputInfo ii) throws QueryException {
        TrieNode nw;
        int k = Branch.key(o.hash, l);
        TrieNode ch = this.kids[k];
        if (ch != null) {
            TrieNode ins = ch.add(o, l + 1, ii);
            if (ins == ch) {
                return this;
            }
            nw = ins;
        } else {
            nw = o;
        }
        TrieNode[] ks = this.copyKids();
        ks[k] = nw;
        return new Branch(ks, this.used | 1 << k, this.size + 1);
    }

    @Override
    TrieNode add(List o, int l, InputInfo ii) throws QueryException {
        TrieNode nw;
        int k = Branch.key(o.hash, l);
        TrieNode ch = this.kids[k];
        int n = o.size;
        if (ch != null) {
            TrieNode ins = ch.add(o, l + 1, ii);
            if (ins == ch) {
                return this;
            }
            n = ins.size - ch.size;
            nw = ins;
        } else {
            nw = o;
        }
        TrieNode[] ks = this.copyKids();
        ks[k] = nw;
        return new Branch(ks, this.used | 1 << k, this.size + n);
    }

    @Override
    TrieNode add(Branch o, int l, InputInfo ii) throws QueryException {
        TrieNode[] ch = null;
        int nu = this.used;
        int ns = this.size;
        for (int i = 0; i < this.kids.length; ++i) {
            TrieNode nw;
            TrieNode k = this.kids[i];
            TrieNode ok = o.kids[i];
            if (ok == null) continue;
            TrieNode trieNode = nw = k == null ? ok : ok.addAll(k, l + 1, ii);
            if (nw == k) continue;
            if (ch == null) {
                ch = this.copyKids();
            }
            ch[i] = nw;
            nu |= 1 << i;
            ns += nw.size - (k == null ? 0 : k.size);
        }
        return ch == null ? this : new Branch(ch, nu, ns);
    }

    @Override
    boolean verify() {
        int c = 0;
        for (int i = 0; i < 32; ++i) {
            boolean act;
            boolean bit = (this.used & 1 << i) != 0;
            boolean bl = act = this.kids[i] != null;
            if (bit ^ act) {
                return false;
            }
            if (!act) continue;
            c += this.kids[i].size;
        }
        return c == this.size;
    }

    @Override
    void keys(ValueBuilder ks) {
        for (TrieNode nd : this.kids) {
            if (nd == null) continue;
            nd.keys(ks);
        }
    }

    @Override
    boolean hasType(AtomType kt, SeqType vt) {
        for (TrieNode k : this.kids) {
            if (k == null || k.hasType(kt, vt)) continue;
            return false;
        }
        return true;
    }

    @Override
    int hash(InputInfo ii) throws QueryException {
        int hash = 0;
        for (TrieNode ch : this.kids) {
            if (ch == null) continue;
            hash = 31 * hash + ch.hash(ii);
        }
        return hash;
    }

    @Override
    boolean deep(InputInfo ii, TrieNode o) throws QueryException {
        if (!(o instanceof Branch)) {
            return false;
        }
        Branch ob = (Branch)o;
        if (this.used != ob.used) {
            return false;
        }
        for (int i = 0; i < 32; ++i) {
            if (this.kids[i] == null || this.kids[i].deep(ii, ob.kids[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    StringBuilder toString(StringBuilder sb) {
        for (int i = 0; i < 32; ++i) {
            if (this.kids[i] == null) continue;
            this.kids[i].toString(sb);
        }
        return sb;
    }
}

