/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import org.basex.core.MainOptions;
import org.basex.data.DataText;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.util.Err;
import org.basex.query.value.item.AStr;
import org.basex.query.value.type.AtomType;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.XMLToken;
import org.basex.util.list.ByteList;

public class Str
extends AStr {
    public static final Str ZERO = new Str(Token.EMPTY);
    final byte[] val;

    private Str(byte[] v) {
        this(v, AtomType.STR);
    }

    public Str(byte[] v, AtomType t) {
        super(t);
        this.val = v;
    }

    public static Str get(byte[] v) {
        return v.length == 0 ? ZERO : new Str(v);
    }

    public static Str get(String s) {
        return Str.get(Token.token(s));
    }

    public static Str get(Object v, QueryContext ctx, InputInfo ii) throws QueryException {
        byte[] bytes = Token.token(v.toString());
        if (ctx.context.options.get(MainOptions.CHECKSTRINGS).booleanValue()) {
            int bl = bytes.length;
            for (int b = 0; b < bl; b += Token.cl(bytes, b)) {
                int cp = Token.cp(bytes, b);
                if (XMLToken.valid(cp)) continue;
                throw Err.INVCODE.get(ii, Integer.toHexString(cp));
            }
        }
        return Str.get(bytes);
    }

    @Override
    public final byte[] string(InputInfo ii) {
        return this.val;
    }

    public final byte[] string() {
        return this.val;
    }

    @Override
    public final boolean sameAs(Expr cmp) {
        if (!(cmp instanceof Str)) {
            return false;
        }
        Str i = (Str)cmp;
        return this.type == i.type && Token.eq(this.val, i.val);
    }

    @Override
    public final String toJava() {
        return Token.string(this.val);
    }

    @Override
    public final String toString() {
        ByteList tb = new ByteList();
        tb.add(34);
        for (byte v : this.val) {
            if (v == 38) {
                tb.add(DataText.E_AMP);
            } else if (v == 13) {
                tb.add(DataText.E_0D);
            } else if (v == 10) {
                tb.add(DataText.E_0A);
            } else {
                tb.add(v);
            }
            if (v != 34) continue;
            tb.add(34);
        }
        return tb.add(34).toString();
    }
}

