/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.util.Collation;
import org.basex.query.util.Err;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class Int
extends ANum {
    private static final Int[] NUMS = new Int[128];
    private final long val;

    private Int(long v) {
        this(v, AtomType.ITR);
    }

    public Int(long v, Type t) {
        super(t);
        this.val = v;
    }

    public static Int get(long v) {
        return v >= 0L && v < (long)NUMS.length ? NUMS[(int)v] : new Int(v);
    }

    public static Int get(long v, Type t) {
        return t == AtomType.ITR ? Int.get(v) : new Int(v, t);
    }

    @Override
    public byte[] string() {
        return this.val == 0L ? Token.ZERO : Token.token(this.val);
    }

    @Override
    public boolean bool(InputInfo ii) {
        return this.val != 0L;
    }

    @Override
    public long itr() {
        return this.val;
    }

    @Override
    public float flt() {
        return this.val;
    }

    @Override
    public double dbl() {
        return this.val;
    }

    @Override
    public Item test(QueryContext ctx, InputInfo ii) {
        return this.val == ctx.pos ? this : null;
    }

    @Override
    public BigDecimal dec(InputInfo ii) {
        return BigDecimal.valueOf(this.val);
    }

    @Override
    public boolean eq(Item it, Collation coll, InputInfo ii) throws QueryException {
        return it instanceof Int ? this.val == ((Int)it).val : (double)this.val == it.dbl(ii);
    }

    @Override
    public int diff(Item it, Collation coll, InputInfo ii) throws QueryException {
        if (it instanceof Int) {
            long i = ((Int)it).val;
            return this.val < i ? -1 : (this.val > i ? 1 : 0);
        }
        double n = it.dbl(ii);
        return Double.isNaN(n) ? Integer.MIN_VALUE : ((double)this.val < n ? -1 : ((double)this.val > n ? 1 : 0));
    }

    @Override
    public Object toJava() {
        switch ((AtomType)this.type) {
            case BYT: {
                return (byte)this.val;
            }
            case SHR: 
            case UBY: {
                return (short)this.val;
            }
            case INT: 
            case USH: {
                return (int)this.val;
            }
            case LNG: 
            case UIN: {
                return this.val;
            }
        }
        return new BigInteger(this.toString());
    }

    @Override
    public boolean sameAs(Expr cmp) {
        if (!(cmp instanceof Int)) {
            return false;
        }
        Int i = (Int)cmp;
        return this.type == i.type && this.val == i.val;
    }

    public static long parse(byte[] val, InputInfo ii) throws QueryException {
        long l = Token.toLong(val);
        if (l != Long.MIN_VALUE) {
            return l;
        }
        try {
            return Long.parseLong(Token.string(val).trim());
        }
        catch (NumberFormatException ex) {
            throw Err.FUNCAST.get(ii, Int.NUMS[0].type, Err.chop(val));
        }
    }

    static {
        for (int i = 0; i < NUMS.length; ++i) {
            Int.NUMS[i] = new Int(i);
        }
    }
}

