/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.unit;

import java.io.IOException;
import java.util.ArrayList;
import org.basex.core.Context;
import org.basex.io.IOFile;
import org.basex.query.MainModule;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Expr;
import org.basex.query.func.StaticFunc;
import org.basex.query.func.StaticFuncCall;
import org.basex.query.iter.Iter;
import org.basex.query.util.Ann;
import org.basex.query.util.Err;
import org.basex.query.util.unit.Constants;
import org.basex.query.util.unit.UnitException;
import org.basex.query.value.Value;
import org.basex.query.value.item.DTDur;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.FElem;
import org.basex.query.var.VarScope;
import org.basex.util.Performance;
import org.basex.util.Token;

public final class Unit {
    private final Context ctx;
    private final IOFile file;
    private String input;
    private StaticFunc[] funcs;
    private StaticFunc current;
    int failures;
    int errors;
    int skipped;
    int tests;

    public Unit(IOFile file, Context ctx) {
        this.file = file;
        this.ctx = ctx;
    }

    public void test(FElem suites) throws IOException {
        FElem suite = new FElem(Constants.TESTSUITE).add(Constants.NAME, this.file.url());
        ArrayList<StaticFunc> before = new ArrayList<StaticFunc>(0);
        ArrayList<StaticFunc> after = new ArrayList<StaticFunc>(0);
        ArrayList<StaticFunc> beforeModule = new ArrayList<StaticFunc>(0);
        ArrayList<StaticFunc> afterModule = new ArrayList<StaticFunc>(0);
        ArrayList<StaticFunc> test = new ArrayList<StaticFunc>(0);
        Performance perf = new Performance();
        try {
            QueryContext qc = new QueryContext(this.ctx);
            this.input = Token.string(this.file.read());
            qc.parse(this.input, this.file.path(), null);
            for (StaticFunc uf : this.funcs = qc.funcs.funcs()) {
                Ann ann = uf.ann;
                int as = ann.size();
                boolean xq = false;
                for (int a = 0; !xq && a < as; xq |= Token.eq(ann.names[a].uri(), QueryText.UNITURI), ++a) {
                }
                if (!xq) continue;
                if (uf.ann.contains(Ann.Q_PRIVATE)) {
                    throw Err.UNIT_PRIVATE.get(null, new Object[]{uf.name.local()});
                }
                if (uf.args.length > 0) {
                    throw Err.UNIT_ARGS.get(null, new Object[]{uf.name.local()});
                }
                if (this.indexOf(uf, Constants.BEFORE) != -1) {
                    before.add(uf);
                }
                if (this.indexOf(uf, Constants.AFTER) != -1) {
                    after.add(uf);
                }
                if (this.indexOf(uf, Constants.BEFORE_MODULE) != -1) {
                    beforeModule.add(uf);
                }
                if (this.indexOf(uf, Constants.AFTER_MODULE) != -1) {
                    afterModule.add(uf);
                }
                if (this.indexOf(uf, Constants.TEST) == -1) continue;
                test.add(uf);
            }
            for (StaticFunc uf : beforeModule) {
                this.eval(uf);
            }
            for (StaticFunc uf : test) {
                Performance perf2;
                FElem testcase;
                block31: {
                    Value values = uf.ann.values[this.indexOf(uf, Constants.TEST)];
                    long vs = values.size();
                    byte[] code = null;
                    if (vs != 0L) {
                        if (vs == 2L && Token.eq(Constants.EXPECTED, values.itemAt(0L).string(null))) {
                            code = values.itemAt(1L).string(null);
                        } else {
                            throw Err.UNIT_ANN.get(null, Character.valueOf('%'), uf.ann.names[0]);
                        }
                    }
                    testcase = new FElem(Constants.TESTCASE).add(Constants.NAME, uf.name.local());
                    ++this.tests;
                    perf2 = new Performance();
                    int skip = this.indexOf(uf, Constants.IGNORE);
                    if (skip == -1) {
                        try {
                            for (StaticFunc fn : before) {
                                this.eval(fn);
                            }
                            this.eval(uf);
                            for (StaticFunc fn : after) {
                                this.eval(fn);
                            }
                            if (code != null) {
                                ++this.failures;
                                testcase.add(new FElem(Constants.FAILURE).add(new FElem(Constants.EXPECTED).add(code)));
                            }
                            break block31;
                        }
                        catch (QueryException ex) {
                            QNm name = ex.qname();
                            if (code == null || !Token.eq(code, name.local())) {
                                FElem error;
                                boolean failure = Err.UNIT_ASSERT.eq(name);
                                if (failure) {
                                    ++this.failures;
                                    error = new FElem(Constants.FAILURE);
                                } else {
                                    ++this.errors;
                                    error = new FElem(Constants.ERROR);
                                }
                                error.add(Constants.LINE, Token.token(ex.line()));
                                error.add(Constants.COLUMN, Token.token(ex.column()));
                                if (ex instanceof UnitException) {
                                    UnitException ue = (UnitException)ex;
                                    error.add(this.elem(ue.returned, Constants.RETURNED, ue.count));
                                    error.add(this.elem(ue.expected, Constants.EXPECTED, ue.count));
                                } else {
                                    if (!failure) {
                                        error.add(Constants.TYPE, ex.qname().prefixId(QueryText.ERRORURI));
                                    }
                                    error.add(ex.getLocalizedMessage());
                                }
                                testcase.add(error);
                            }
                            break block31;
                        }
                    }
                    Value sv = uf.ann.values[skip];
                    testcase.add(Constants.SKIPPED, sv.isEmpty() ? Token.EMPTY : sv.itemAt(0L).string(null));
                    ++this.skipped;
                }
                testcase.add(Constants.TIME, Unit.time(perf2));
                suite.add(testcase);
            }
            for (StaticFunc uf : afterModule) {
                this.eval(uf);
            }
        }
        catch (QueryException ex) {
            if (this.current == null) {
                FElem error = new FElem(Constants.ERROR);
                error.add(Constants.LINE, Token.token(ex.line()));
                error.add(Constants.COLUMN, Token.token(ex.column()));
                error.add(Constants.TYPE, ex.qname().prefixId(QueryText.ERRORURI));
                error.add(ex.getLocalizedMessage());
                suite.add(error);
            } else {
                FElem testcase = new FElem(Constants.TESTCASE).add(Constants.NAME, this.current.name.local());
                testcase.add(Constants.TIME, Unit.time(perf));
                suite.add(testcase);
            }
            ++this.errors;
        }
        if (suite.hasChildren()) {
            suite.add(Constants.TIME, Unit.time(perf));
            suite.add(Constants.TESTS, Token.token(this.tests));
            suite.add(Constants.FAILURES, Token.token(this.failures));
            suite.add(Constants.ERRORS, Token.token(this.errors));
            suite.add(Constants.SKIPPED, Token.token(this.skipped));
            suites.add(suite);
        }
    }

    private FElem elem(Item it, byte[] name, int c) throws QueryException {
        FElem exp = new FElem(name);
        if (it instanceof ANode) {
            exp.add((ANode)it);
        } else if (it != null) {
            exp.add(it.string(null));
        }
        exp.add(Constants.ITEM, Token.token(c));
        exp.add(Constants.TYPE, it.type.toString());
        return exp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void eval(StaticFunc func) throws QueryException {
        this.current = func;
        QueryContext query = new QueryContext(this.ctx);
        try {
            query.parse(this.input, this.file.path(), null);
            StaticFuncCall sfc = new StaticFuncCall(func.name, new Expr[0], func.sc, func.info).init(func);
            MainModule mm = new MainModule(sfc, new VarScope(func.sc), null, func.sc);
            query.mainModule(mm);
            query.compile();
            Iter iter = query.iter();
            if (iter.next() != null) {
                throw Err.UNIT_EMPTY.get(null, new Object[]{func.name.local()});
            }
        }
        finally {
            query.close();
        }
    }

    private int indexOf(StaticFunc func, byte[] name) throws QueryException {
        Ann ann = func.ann;
        int as = ann.size();
        int pos = -1;
        for (int a = 0; a < as; ++a) {
            QNm nm = ann.names[a];
            if (!Token.eq(nm.uri(), QueryText.UNITURI) || !Token.eq(nm.local(), name)) continue;
            if (pos != -1) {
                throw Err.UNIT_TWICE.get(null, Character.valueOf('%'), nm.local());
            }
            pos = a;
        }
        return pos;
    }

    static byte[] time(Performance p) {
        return new DTDur(p.time() / 1000000L).string(null);
    }
}

