/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.pkg;

import java.util.ArrayList;
import org.basex.io.IOFile;
import org.basex.query.QueryException;
import org.basex.query.util.Err;
import org.basex.query.util.pkg.Package;
import org.basex.query.util.pkg.PkgParser;
import org.basex.query.util.pkg.Repo;
import org.basex.util.InputInfo;
import org.basex.util.Prop;
import org.basex.util.Token;
import org.basex.util.Version;
import org.basex.util.hash.TokenSet;

public final class PkgValidator {
    private final Repo repo;
    private final InputInfo info;

    public PkgValidator(Repo r, InputInfo ii) {
        this.repo = r;
        this.info = ii;
    }

    public void check(Package pkg) throws QueryException {
        this.checkDepends(pkg);
        this.checkComps(pkg);
    }

    private void checkDepends(Package pkg) throws QueryException {
        ArrayList<Package.Dependency> procs = new ArrayList<Package.Dependency>();
        for (Package.Dependency dep : pkg.dep) {
            if (dep.pkg == null && dep.processor == null) {
                throw Err.BXRE_DESC.get(this.info, "Dependency not completely specified.");
            }
            if (dep.pkg != null && this.depPkg(dep) == null) {
                throw Err.BXRE_NOTINST.get(this.info, new Object[]{dep.pkg});
            }
            if (dep.processor == null) continue;
            procs.add(dep);
        }
        if (!procs.isEmpty()) {
            this.checkProcs(procs);
        }
    }

    public byte[] depPkg(Package.Dependency dep) {
        TokenSet instVers = new TokenSet();
        for (byte[] nextPkg : this.repo.pkgDict()) {
            if (nextPkg == null || !Token.startsWith(nextPkg, dep.pkg)) continue;
            instVers.add(Package.version(nextPkg));
        }
        byte[] version = PkgValidator.availVersion(dep, instVers);
        return version == null ? null : dep.name(version);
    }

    private void checkProcs(ArrayList<Package.Dependency> procs) throws QueryException {
        boolean supported = false;
        int i = Prop.VERSION.indexOf(32);
        TokenSet versions = new TokenSet(new byte[][]{Token.token(i == -1 ? Prop.VERSION : Prop.VERSION.substring(0, i))});
        byte[] name = Token.token(Prop.PROJECT_NAME);
        for (Package.Dependency d : procs) {
            if (!Token.eq(Token.lc(d.processor), name)) {
                supported = false;
                break;
            }
            supported = PkgValidator.availVersion(d, versions) != null;
        }
        if (!supported) {
            throw Err.BXRE_VERSION.get(this.info, new Object[0]);
        }
    }

    private static byte[] availVersion(Package.Dependency dep, TokenSet versions) {
        if (versions.isEmpty()) {
            return null;
        }
        if (dep.versions != null) {
            TokenSet versList = new TokenSet(Token.split(dep.versions, 32));
            for (byte[] v : versList) {
                if (!versions.contains(v)) continue;
                return v;
            }
        } else if (dep.semver != null) {
            Version semVer = new Version(dep.semver);
            for (byte[] v : versions) {
                if (!new Version(v).isCompatible(semVer)) continue;
                return v;
            }
        } else if (dep.semverMin != null && dep.semverMax != null) {
            Version min = new Version(dep.semverMin);
            Version max = new Version(dep.semverMax);
            for (byte[] nextVer : versions) {
                Version v = new Version(nextVer);
                if (v.compareTo(min) < 0 || v.compareTo(max) >= 0) continue;
                return nextVer;
            }
        } else if (dep.semverMin != null) {
            Version semVer = new Version(dep.semverMin);
            for (byte[] nextVer : versions) {
                Version v = new Version(nextVer);
                if (!v.isCompatible(semVer) && v.compareTo(semVer) < 0) continue;
                return nextVer;
            }
        } else if (dep.semverMax != null) {
            Version semVer = new Version(dep.semverMax);
            for (byte[] nextVer : versions) {
                Version v = new Version(nextVer);
                if (!v.isCompatible(semVer) && v.compareTo(semVer) > 0) continue;
                return nextVer;
            }
        } else {
            return versions.key(1);
        }
        return null;
    }

    private void checkComps(Package pkg) throws QueryException {
        for (Package.Component comp : pkg.comps) {
            if (!this.isInstalled(comp, pkg.name)) continue;
            throw Err.BXRE_INST.get(this.info, comp.name());
        }
    }

    private boolean isInstalled(Package.Component comp, byte[] name) throws QueryException {
        TokenSet pkgs = this.repo.nsDict().get(comp.uri);
        if (pkgs == null) {
            return false;
        }
        for (byte[] nextPkg : pkgs) {
            if (nextPkg == null || Token.eq(Package.name(nextPkg), name)) continue;
            String pkgDir = Token.string(this.repo.pkgDict().get(nextPkg));
            IOFile pkgDesc = new IOFile(this.repo.path(pkgDir), "expath-pkg.xml");
            Package pkg = new PkgParser(this.repo, this.info).parse(pkgDesc);
            for (Package.Component nextComp : pkg.comps) {
                if (!nextComp.name().equals(comp.name())) continue;
                return true;
            }
        }
        return false;
    }
}

