/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util;

import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.util.Err;
import org.basex.query.util.NSGlobal;
import org.basex.util.Atts;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class NSContext {
    private final Atts ns = new Atts();
    private Atts stack;

    public void add(byte[] pref, byte[] uri, InputInfo ii) throws QueryException {
        if (Token.eq(pref, Token.XML, Token.XMLNS)) {
            throw Err.BINDXML.get(ii, new Object[]{pref});
        }
        if (Token.eq(uri, QueryText.XMLURI)) {
            throw Err.BINDXMLURI.get(ii, uri, Token.XML);
        }
        if (Token.eq(uri, QueryText.XMLNSURI)) {
            throw Err.BINDXMLURI.get(ii, uri, Token.XMLNS);
        }
        this.ns.add(pref, uri);
    }

    public void delete(byte[] pref) {
        for (int s = this.ns.size() - 1; s >= 0; --s) {
            if (!Token.eq(pref, this.ns.name(s))) continue;
            this.ns.delete(s);
        }
    }

    public byte[] staticURI(byte[] pref) {
        for (int s = this.ns.size() - 1; s >= 0; --s) {
            if (!Token.eq(this.ns.name(s), pref)) continue;
            return this.ns.value(s);
        }
        return null;
    }

    public byte[] uri(byte[] pref) {
        byte[] uri;
        if (this.stack != null) {
            for (int s = this.stack.size() - 1; s >= 0; --s) {
                if (!Token.eq(this.stack.name(s), pref)) continue;
                return this.stack.value(s);
            }
        }
        return (uri = this.staticURI(pref)) == null ? NSGlobal.uri(pref) : (byte[])(uri.length == 0 ? null : uri);
    }

    public int size() {
        return this.stack().size();
    }

    public void size(int s) {
        this.stack().size(s);
    }

    public void add(byte[] pref, byte[] uri) {
        this.stack().add(pref, uri);
    }

    private Atts stack() {
        if (this.stack == null) {
            this.stack = new Atts();
        }
        return this.stack;
    }
}

