/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up.primitives;

import java.util.LinkedList;
import org.basex.data.Data;
import org.basex.data.MemData;
import org.basex.data.atomic.AtomicUpdateCache;
import org.basex.query.QueryException;
import org.basex.query.up.NamePool;
import org.basex.query.up.primitives.DeleteNode;
import org.basex.query.up.primitives.NodeUpdate;
import org.basex.query.up.primitives.ReplaceContent;
import org.basex.query.up.primitives.Update;
import org.basex.query.up.primitives.UpdateType;
import org.basex.query.util.ANodeList;
import org.basex.query.util.Err;
import org.basex.query.value.node.DBNode;
import org.basex.util.InputInfo;
import org.basex.util.Util;

public final class ReplaceValue
extends NodeUpdate {
    private final byte[] value;
    public final boolean rec;

    public ReplaceValue(int p, Data d, InputInfo i, byte[] v) {
        super(UpdateType.REPLACEVALUE, p, d, i);
        this.value = v;
        this.rec = d.kind(this.pre) == 1;
    }

    @Override
    public void merge(Update up) throws QueryException {
        throw Err.UPMULTREPV.get(this.info, this.node());
    }

    @Override
    public int size() {
        return 1;
    }

    public String toString() {
        return Util.info("%[%, %]", Util.className(this), this.node(), this.value);
    }

    private boolean deleteText() {
        return this.value.length == 0 && this.data.kind(this.pre) == 2;
    }

    private boolean substituted() {
        return this.rec || this.deleteText();
    }

    @Override
    public void addAtomics(AtomicUpdateCache l) {
        if (!this.substituted()) {
            l.addUpdateValue(this.pre, this.value);
        }
    }

    @Override
    public NodeUpdate[] substitute(MemData tmp) {
        int k = this.data.kind(this.pre);
        if (this.rec) {
            LinkedList<NodeUpdate> l = new LinkedList<NodeUpdate>();
            l.add(this);
            int firstChild = this.pre + this.data.attSize(this.pre, k);
            int followingNode = this.pre + this.data.size(this.pre, k);
            for (int runner = firstChild; runner < followingNode; runner += this.data.size(runner, this.data.kind(runner))) {
                l.add(new DeleteNode(runner, this.data, this.info, true));
            }
            if (this.value.length > 0) {
                int p = tmp.meta.size;
                tmp.text(p, 1, this.value, 2);
                tmp.insert(p);
                ANodeList nl = new ANodeList(new DBNode(tmp, p));
                l.add(new ReplaceContent(this.pre, this.data, this.info, nl));
            }
            return l.toArray(new NodeUpdate[l.size()]);
        }
        if (this.deleteText()) {
            return new NodeUpdate[]{this, new DeleteNode(this.pre, this.data, this.info, false)};
        }
        return new NodeUpdate[]{this};
    }

    @Override
    public void update(NamePool pool) {
    }
}

