/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up.primitives;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.basex.core.MainOptions;
import org.basex.query.QueryException;
import org.basex.query.util.Err;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.options.BooleanOption;
import org.basex.util.options.NumberOption;
import org.basex.util.options.Option;

final class DBOptions {
    static final Option<?>[] INDEXING = new Option[]{MainOptions.MAXCATS, MainOptions.MAXLEN, MainOptions.INDEXSPLITSIZE, MainOptions.FTINDEXSPLITSIZE, MainOptions.LANGUAGE, MainOptions.STOPWORDS, MainOptions.TEXTINDEX, MainOptions.ATTRINDEX, MainOptions.FTINDEX, MainOptions.STEMMING, MainOptions.CASESENS, MainOptions.DIACRITICS, MainOptions.UPDINDEX};
    static final Option<?>[] PARSING = new Option[]{MainOptions.CREATEFILTER, MainOptions.ADDARCHIVES, MainOptions.SKIPCORRUPT, MainOptions.ADDRAW, MainOptions.ADDCACHE, MainOptions.CSVPARSER, MainOptions.TEXTPARSER, MainOptions.JSONPARSER, MainOptions.HTMLPARSER, MainOptions.PARSER, MainOptions.CHOP, MainOptions.INTPARSE, MainOptions.STRIPNS, MainOptions.DTD, MainOptions.CATFILE};
    private final HashMap<Option<?>, Object> rOptions = new HashMap();
    private final HashMap<Option<?>, Object> oOptions = new HashMap();

    DBOptions(HashMap<String, String> options, List<Option<?>> supported, InputInfo info) throws QueryException {
        HashMap opts = new HashMap();
        for (Option<?> option : supported) {
            opts.put(option.name().toLowerCase(Locale.ENGLISH), option);
        }
        for (Map.Entry entry : options.entrySet()) {
            String key = (String)entry.getKey();
            Option option = (Option)opts.get(key);
            if (option == null) {
                throw Err.BASX_OPTIONS.get(info, key);
            }
            String value = (String)entry.getValue();
            if (option instanceof NumberOption) {
                int v = Token.toInt(value);
                if (v < 0) {
                    throw Err.BASX_VALUE.get(info, key, value);
                }
                this.rOptions.put(option, v);
                continue;
            }
            if (option instanceof BooleanOption) {
                boolean yes = Util.yes(value);
                if (!yes && !Util.no(value)) {
                    throw Err.BASX_VALUE.get(info, key, value);
                }
                this.rOptions.put(option, yes);
                continue;
            }
            this.rOptions.put(option, value);
        }
    }

    void assign(Option<?> option, Object value) {
        if (!this.rOptions.containsKey(option)) {
            this.rOptions.put(option, value);
        }
    }

    void assign(MainOptions opts) {
        for (Map.Entry<Option<?>, Object> entry : this.rOptions.entrySet()) {
            Option<?> option = entry.getKey();
            this.oOptions.put(option, opts.get(option));
            opts.put(option, entry.getValue());
        }
    }

    void reset(MainOptions opts) {
        for (Map.Entry<Option<?>, Object> e : this.oOptions.entrySet()) {
            opts.put(e.getKey(), e.getValue());
        }
    }
}

