/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.path;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.iter.Iter;
import org.basex.query.iter.NodeIter;
import org.basex.query.iter.NodeSeqBuilder;
import org.basex.query.path.AxisPath;
import org.basex.query.util.Err;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

final class CachedPath
extends AxisPath {
    private boolean cache;
    private NodeSeqBuilder citer;
    private Value lvalue;

    CachedPath(InputInfo ii, Expr r, Expr ... s) {
        super(ii, r, s);
    }

    @Override
    public Expr optimize(QueryContext ctx, VarScope scp) throws QueryException {
        Expr e = super.optimize(ctx, scp);
        if (e != this) {
            return e;
        }
        this.cache = this.root != null && !this.hasFreeVars();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        Value cv = ctx.value;
        long cs = ctx.size;
        long cp = ctx.pos;
        Value r = this.root != null ? ctx.value(this.root) : cv;
        try {
            this.citer = new NodeSeqBuilder().check();
            if (r != null) {
                Item it;
                Iter ir = ctx.iter(r);
                while ((it = ir.next()) != null) {
                    if (this.root != null && !(it instanceof ANode)) {
                        throw Err.PATHNODE.get(this.info, it.type);
                    }
                    ctx.value = it;
                    this.iter(0, this.citer, ctx);
                }
            } else {
                ctx.value = null;
                this.iter(0, this.citer, ctx);
            }
            this.citer.sort();
            NodeSeqBuilder nodeSeqBuilder = this.citer;
            return nodeSeqBuilder;
        }
        finally {
            ctx.value = cv;
            ctx.size = cs;
            ctx.pos = cp;
        }
    }

    private void iter(int l, NodeSeqBuilder nc, QueryContext ctx) throws QueryException {
        ANode node;
        boolean more;
        NodeIter ni = (NodeIter)ctx.iter(this.steps[l]);
        boolean bl = more = l + 1 != this.steps.length;
        while ((node = ni.next()) != null) {
            if (more) {
                ctx.value = node;
                this.iter(l + 1, nc, ctx);
                continue;
            }
            ctx.checkStop();
            nc.add(node);
        }
    }

    @Override
    public AxisPath copy(QueryContext ctx, VarScope scp, IntObjMap<Var> vs) {
        Expr[] stps = new Expr[this.steps.length];
        for (int s = 0; s < this.steps.length; ++s) {
            stps[s] = this.step(s).copy(ctx, scp, (IntObjMap)vs);
        }
        CachedPath ap = this.copyType(new CachedPath(this.info, this.root == null ? null : this.root.copy(ctx, scp, vs), stps));
        ap.cache = this.cache;
        if (this.citer != null) {
            ap.citer = this.citer.copy();
        }
        if (this.lvalue != null) {
            ap.lvalue = this.lvalue;
        }
        return ap;
    }
}

