/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.gflwor;

import java.util.ArrayDeque;
import java.util.Iterator;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Single;
import org.basex.query.gflwor.GFLWOR;
import org.basex.query.iter.Iter;
import org.basex.query.iter.ValueBuilder;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Err;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.FElem;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.query.var.VarUsage;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.hash.IntObjMap;

public final class Window
extends GFLWOR.Clause {
    private final boolean sliding;
    private final Var var;
    private Expr expr;
    private Condition start;
    private final boolean only;
    private Condition end;

    public Window(InputInfo ii, boolean slide, Var v, Expr in, Condition st, boolean o, Condition nd) throws QueryException {
        super(ii, Window.vars(v, st, nd, ii));
        this.sliding = slide;
        this.var = v;
        this.expr = in;
        this.start = st;
        this.only = o;
        this.end = nd;
    }

    private static Var[] vars(Var vr, Condition st, Condition nd, InputInfo ii) throws QueryException {
        int stn = st.nVars();
        Var[] vs = new Var[1 + stn + (nd == null ? 0 : nd.nVars())];
        st.writeVars(vs, 0);
        if (nd != null) {
            nd.writeVars(vs, stn);
        }
        vs[vs.length - 1] = vr;
        for (int i = 0; i < vs.length; ++i) {
            Var v = vs[i];
            int j = i;
            while (--j >= 0) {
                if (!v.name.eq(vs[j].name)) continue;
                throw Err.WINDOWUNIQ.get(ii, vs[j]);
            }
        }
        return vs;
    }

    @Override
    GFLWOR.Eval eval(GFLWOR.Eval sub) {
        return this.sliding ? this.slidingEval(sub) : (this.end == null ? this.tumblingEval(sub) : this.tumblingEndEval(sub));
    }

    private GFLWOR.Eval tumblingEval(final GFLWOR.Eval sub) {
        return new TumblingEval(){
            private Item[] vals;
            private long spos;

            @Override
            public boolean next(QueryContext ctx) throws QueryException {
                while (true) {
                    Item fst;
                    Item item = this.vals != null ? this.vals[0] : (fst = this.findStart(ctx) ? this.curr : null);
                    if (fst != null) {
                        Item[] itemArray;
                        ValueBuilder window = new ValueBuilder(new Item[]{fst, null, null, null}, 1);
                        if (this.vals == null) {
                            Item[] itemArray2 = new Item[3];
                            itemArray2[0] = this.curr;
                            itemArray2[1] = this.prev;
                            itemArray = itemArray2;
                            itemArray2[2] = this.next;
                        } else {
                            itemArray = this.vals;
                        }
                        Item[] st = itemArray;
                        long ps = this.vals == null ? this.p : this.spos;
                        this.vals = null;
                        while (this.readNext()) {
                            if (Window.this.start.matches(ctx, this.curr, this.p, this.prev, this.next)) {
                                this.vals = new Item[]{this.curr, this.prev, this.next};
                                this.spos = this.p;
                                break;
                            }
                            window.add(this.curr);
                        }
                        Window.this.start.bind(ctx, st[0], ps, st[1], st[2]);
                        ctx.set(Window.this.var, window.value(), Window.this.info);
                        return true;
                    }
                    if (!this.prepareNext(ctx, sub)) {
                        return false;
                    }
                    this.vals = null;
                }
            }
        };
    }

    private GFLWOR.Eval tumblingEndEval(final GFLWOR.Eval sub) {
        return new TumblingEval(){

            @Override
            public boolean next(QueryContext ctx) throws QueryException {
                do {
                    if (!this.findStart(ctx)) continue;
                    ValueBuilder window = new ValueBuilder();
                    boolean found = false;
                    do {
                        window.add(this.curr);
                        if (!Window.this.end.matches(ctx, this.curr, this.p, this.prev, this.next)) continue;
                        found = true;
                        break;
                    } while (this.readNext());
                    if (!found && Window.this.only) continue;
                    ctx.set(Window.this.var, window.value(), Window.this.info);
                    return true;
                } while (this.prepareNext(ctx, sub));
                return false;
            }
        };
    }

    private GFLWOR.Eval slidingEval(final GFLWOR.Eval sub) {
        return new WindowEval(){
            private final ArrayDeque<Item> queue = new ArrayDeque();

            @Override
            public boolean next(QueryContext ctx) throws QueryException {
                while (true) {
                    Item curr;
                    Item next = null;
                    while ((curr = this.advance()) != null) {
                        next = this.queue.peekFirst();
                        if (next == null && (next = this.next()) != null) {
                            this.queue.addLast(next);
                        }
                        if (Window.this.start.matches(ctx, curr, this.p, this.prev, next)) break;
                        this.prev = curr;
                    }
                    if (curr != null) {
                        ValueBuilder cache = new ValueBuilder();
                        Iterator<Item> qiter = this.queue.iterator();
                        if (qiter.hasNext()) {
                            qiter.next();
                        }
                        Item pr = this.prev;
                        Item it = curr;
                        Item nx = next;
                        long ps = this.p;
                        do {
                            cache.add(it);
                            if (Window.this.end.matches(ctx, it, ps++, pr, nx)) break;
                            pr = it;
                            it = nx;
                            if (qiter.hasNext()) {
                                nx = qiter.next();
                                continue;
                            }
                            nx = this.next();
                            if (nx == null) continue;
                            this.queue.addLast(nx);
                        } while (it != null);
                        if (it != null || !Window.this.only) {
                            Window.this.start.bind(ctx, curr, this.p, this.prev, next);
                            this.prev = curr;
                            ctx.set(Window.this.var, cache.value(), Window.this.info);
                            return true;
                        }
                    }
                    if (!this.prepareNext(ctx, sub)) {
                        return false;
                    }
                    this.queue.clear();
                }
            }

            private Item advance() throws QueryException {
                Item it = this.queue.pollFirst();
                if (it == null) {
                    it = this.next();
                }
                if (it != null) {
                    ++this.p;
                }
                return it;
            }
        };
    }

    @Override
    public GFLWOR.Clause compile(QueryContext cx, VarScope scp) throws QueryException {
        this.expr = this.expr.compile(cx, scp);
        this.start.compile(cx, scp);
        if (this.end != null) {
            this.end.compile(cx, scp);
        }
        return this.optimize(cx, scp);
    }

    @Override
    public GFLWOR.Clause optimize(QueryContext cx, VarScope sc) throws QueryException {
        SeqType t = this.expr.type();
        this.var.refineType(t.withOcc(SeqType.Occ.ZERO_MORE), cx, this.info);
        return this;
    }

    @Override
    public boolean has(Expr.Flag flag) {
        return this.expr.has(flag) || this.start.has(flag) || this.end != null && this.end.has(flag);
    }

    @Override
    public boolean removable(Var v) {
        return this.expr.removable(v) && this.start.removable(v) && (this.end == null || this.end.removable(v));
    }

    @Override
    public VarUsage count(Var v) {
        VarUsage us = this.end == null ? this.start.count(v) : this.start.count(v).plus(this.end.count(v));
        return us == VarUsage.NEVER ? this.expr.count(v) : VarUsage.MORE_THAN_ONCE;
    }

    @Override
    public GFLWOR.Clause inline(QueryContext ctx, VarScope scp, Var v, Expr e) throws QueryException {
        Condition en;
        Expr ex = this.expr.inline(ctx, scp, v, e);
        Condition st = this.start.inline(ctx, scp, v, e);
        Condition condition = en = this.end == null ? null : this.end.inline(ctx, scp, v, e);
        if (ex != null) {
            this.expr = ex;
        }
        if (st != null) {
            this.start = st;
        }
        if (en != null) {
            this.end = en;
        }
        return ex != null || st != null || en != null ? this.optimize(ctx, scp) : null;
    }

    @Override
    public Window copy(QueryContext ctx, VarScope scp, IntObjMap<Var> vs) {
        Var v = scp.newCopyOf(ctx, this.var);
        vs.put(this.var.id, v);
        try {
            return new Window(this.info, this.sliding, v, this.expr.copy(ctx, scp, vs), (Condition)this.start.copy(ctx, scp, (IntObjMap)vs), this.only, (Condition)(this.end != null ? this.end.copy(ctx, scp, (IntObjMap)vs) : null));
        }
        catch (QueryException e) {
            throw Util.notExpected(e);
        }
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return this.expr.accept(visitor) && this.start.accept(visitor) && (this.end == null || this.end.accept(visitor)) && visitor.declared(this.var);
    }

    @Override
    public void plan(FElem plan) {
        FElem e = this.planElem(Token.token("sliding"), Token.token(this.sliding));
        this.var.plan(e);
        this.expr.plan(e);
        this.start.plan(e);
        if (this.end != null) {
            this.end.plan(e);
        }
        plan.add(e);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("for").append(' ').append(this.sliding ? "sliding" : "tumbling").append(' ').append("window").append(' ').append(this.var).append(' ').append("in").append(' ').append(this.expr).append(' ').append(this.start);
        if (this.end != null) {
            if (this.only) {
                sb.append(' ').append("only");
            }
            sb.append(' ').append(this.end);
        }
        return sb.toString();
    }

    @Override
    public void checkUp() throws QueryException {
        this.checkNoneUp(this.expr, this.start, this.end);
    }

    @Override
    long calcSize(long cnt) {
        return this.expr.isEmpty() ? 0L : -1L;
    }

    @Override
    public int exprSize() {
        return this.expr.exprSize() + this.start.exprSize() + (this.end == null ? 0 : this.end.exprSize());
    }

    abstract class TumblingEval
    extends WindowEval {
        Item curr;
        Item next;
        final boolean popNext;

        TumblingEval() {
            this.popNext = Window.this.start.usesNext() || Window.this.end != null && Window.this.end.usesNext();
        }

        final boolean readNext() throws QueryException {
            this.prev = this.curr;
            ++this.p;
            Item n = this.next();
            if (this.next != null) {
                this.curr = this.next;
                this.next = n;
            } else if (n != null && this.popNext) {
                this.next = this.next();
                this.curr = n;
            } else {
                this.curr = n;
            }
            return this.curr != null;
        }

        final boolean findStart(QueryContext ctx) throws QueryException {
            while (this.readNext()) {
                if (!Window.this.start.matches(ctx, this.curr, this.p, this.prev, this.next)) continue;
                return true;
            }
            return false;
        }

        @Override
        boolean prepareNext(QueryContext ctx, GFLWOR.Eval sub) throws QueryException {
            if (!super.prepareNext(ctx, sub)) {
                return false;
            }
            this.curr = null;
            this.next = null;
            return true;
        }
    }

    abstract class WindowEval
    implements GFLWOR.Eval {
        Iter iter;
        Item prev;
        long p;

        WindowEval() {
        }

        final Item next() throws QueryException {
            if (this.iter == null) {
                return null;
            }
            Item it = this.iter.next();
            if (it == null) {
                this.iter = null;
            }
            return it;
        }

        boolean prepareNext(QueryContext ctx, GFLWOR.Eval sub) throws QueryException {
            if (!sub.next(ctx)) {
                return false;
            }
            this.iter = Window.this.expr.iter(ctx);
            this.prev = null;
            this.p = 0L;
            return true;
        }
    }

    public static final class Condition
    extends Single {
        private final boolean start;
        private final Var item;
        private final Var pos;
        private final Var prev;
        private final Var next;

        public Condition(boolean st, Var it, Var p, Var pr, Var nx, Expr cond, InputInfo ii) {
            super(ii, cond);
            this.start = st;
            this.item = it;
            this.pos = p;
            this.prev = pr;
            this.next = nx;
        }

        @Override
        public Expr compile(QueryContext cx, VarScope scp) throws QueryException {
            this.expr = this.expr.compile(cx, scp).compEbv(cx);
            return this;
        }

        @Override
        public Condition optimize(QueryContext ctx, VarScope scp) {
            return this;
        }

        @Override
        public Condition inline(QueryContext ctx, VarScope scp, Var v, Expr e) throws QueryException {
            return (Condition)super.inline(ctx, scp, v, e);
        }

        @Override
        public Condition copy(QueryContext ctx, VarScope scp, IntObjMap<Var> vs) {
            Var nx;
            Var it = this.item == null ? null : scp.newCopyOf(ctx, this.item);
            Var ps = this.pos == null ? null : scp.newCopyOf(ctx, this.pos);
            Var pr = this.prev == null ? null : scp.newCopyOf(ctx, this.prev);
            Var var = nx = this.next == null ? null : scp.newCopyOf(ctx, this.next);
            if (it != null) {
                vs.put(this.item.id, it);
            }
            if (ps != null) {
                vs.put(this.pos.id, ps);
            }
            if (pr != null) {
                vs.put(this.prev.id, pr);
            }
            if (nx != null) {
                vs.put(this.next.id, nx);
            }
            return new Condition(this.start, it, ps, pr, nx, this.expr.copy(ctx, scp, vs), this.info);
        }

        int nVars() {
            int i = 0;
            if (this.item != null) {
                ++i;
            }
            if (this.pos != null) {
                ++i;
            }
            if (this.prev != null) {
                ++i;
            }
            if (this.next != null) {
                ++i;
            }
            return i;
        }

        boolean usesNext() {
            return this.next != null;
        }

        void writeVars(Var[] arr, int p) {
            int i = p;
            if (this.item != null) {
                arr[i++] = this.item;
            }
            if (this.pos != null) {
                arr[i++] = this.pos;
            }
            if (this.prev != null) {
                arr[i++] = this.prev;
            }
            if (this.next != null) {
                arr[i] = this.next;
            }
        }

        boolean matches(QueryContext ctx, Item it, long p, Item pr, Item nx) throws QueryException {
            this.bind(ctx, it, p, pr, nx);
            return this.expr.ebv(ctx, this.info).bool(this.info);
        }

        void bind(QueryContext ctx, Item it, long p, Item pr, Item nx) throws QueryException {
            if (this.item != null) {
                ctx.set(this.item, it == null ? Empty.SEQ : it, this.info);
            }
            if (this.pos != null) {
                ctx.set(this.pos, Int.get(p), this.info);
            }
            if (this.prev != null) {
                ctx.set(this.prev, pr == null ? Empty.SEQ : pr, this.info);
            }
            if (this.next != null) {
                ctx.set(this.next, nx == null ? Empty.SEQ : nx, this.info);
            }
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder(this.start ? "start" : "end");
            if (this.item != null) {
                sb.append(' ').append(this.item);
            }
            if (this.pos != null) {
                sb.append(' ').append("at").append(' ').append(this.pos);
            }
            if (this.prev != null) {
                sb.append(' ').append("previous").append(' ').append(this.prev);
            }
            if (this.next != null) {
                sb.append(' ').append("next").append(' ').append(this.next);
            }
            return sb.append(' ').append("when").append(' ').append(this.expr).toString();
        }

        @Override
        public void plan(FElem plan) {
            FElem e = new FElem(this.start ? "start" : "end");
            if (this.item != null) {
                e.add(this.planAttr(QueryText.VAR, Token.token(this.item.toString())));
            }
            if (this.pos != null) {
                e.add(this.planAttr(Token.token("at"), Token.token(this.pos.toString())));
            }
            if (this.prev != null) {
                e.add(this.planAttr(Token.token("previous"), Token.token(this.prev.toString())));
            }
            if (this.next != null) {
                e.add(this.planAttr(Token.token("next"), Token.token(this.next.toString())));
            }
            if (this.item != null) {
                this.item.plan(e);
            }
            if (this.pos != null) {
                this.pos.plan(e);
            }
            if (this.prev != null) {
                this.prev.plan(e);
            }
            if (this.next != null) {
                this.next.plan(e);
            }
            this.expr.plan(e);
            plan.add(e);
        }

        @Override
        public boolean accept(ASTVisitor visitor) {
            return !(this.item != null && !visitor.declared(this.item) || this.pos != null && !visitor.declared(this.pos) || this.prev != null && !visitor.declared(this.prev) || this.next != null && !visitor.declared(this.next) || !this.expr.accept(visitor));
        }

        @Override
        public int exprSize() {
            return this.expr.exprSize();
        }
    }
}

