/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.expr.XQFunction;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.util.InputInfo;

public abstract class FuncCall
extends Arr {
    boolean tailCall;

    FuncCall(InputInfo ii, Expr[] e) {
        super(ii, e);
    }

    abstract XQFunction evalFunc(QueryContext var1) throws QueryException;

    abstract Value[] evalArgs(QueryContext var1) throws QueryException;

    @Override
    public final void markTailCalls(QueryContext ctx) {
        if (ctx != null) {
            ctx.compInfo("marking as tail call: %", this);
        }
        this.tailCall = true;
    }

    @Override
    public final Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        return this.tailCall ? (Item)FuncCall.invokeTail(this.evalFunc(ctx), this.evalArgs(ctx), true, ctx, this.info) : (Item)FuncCall.invoke(this.evalFunc(ctx), this.evalArgs(ctx), true, ctx, this.info);
    }

    @Override
    public final Value value(QueryContext ctx) throws QueryException {
        return this.tailCall ? FuncCall.invokeTail(this.evalFunc(ctx), this.evalArgs(ctx), false, ctx, this.info) : FuncCall.invoke(this.evalFunc(ctx), this.evalArgs(ctx), false, ctx, this.info);
    }

    @Override
    public final Iter iter(QueryContext ctx) throws QueryException {
        return this.value(ctx).iter();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Value invoke(XQFunction fun, Value[] arg, boolean itm, QueryContext ctx, InputInfo ii) throws QueryException {
        XQFunction func = fun;
        Value[] args = arg;
        int fp = ctx.stack.enterFrame(func.stackFrameSize());
        try {
            while (true) {
                Value ret = itm ? func.invItem(ctx, ii, args) : func.invValue(ctx, ii, args);
                func = ctx.pollTailCall();
                if (func == null) {
                    Value value = ret;
                    return value;
                }
                ctx.stack.reuseFrame(func.stackFrameSize());
                args = ctx.pollTailArgs();
                continue;
                break;
            }
        }
        catch (QueryException ex) {
            ex.add(ii);
            throw ex;
        }
        finally {
            ctx.stack.exitFrame(fp);
        }
    }

    private static Value invokeTail(XQFunction fun, Value[] arg, boolean itm, QueryContext ctx, InputInfo ii) throws QueryException {
        int calls = ctx.tailCalls;
        int max = ctx.maxCalls;
        if (max >= 0 && calls >= max) {
            ctx.registerTailCall(fun, arg);
            return itm ? null : Empty.SEQ;
        }
        ++ctx.tailCalls;
        int fp = ctx.stack.enterFrame(fun.stackFrameSize());
        try {
            Value value = itm ? fun.invItem(ctx, ii, arg) : fun.invValue(ctx, ii, arg);
            return value;
        }
        catch (QueryException ex) {
            ex.add(ii);
            throw ex;
        }
        finally {
            ctx.tailCalls = calls;
            ctx.stack.exitFrame(fp);
        }
    }

    public static Item item(XQFunction fun, Value[] arg, QueryContext ctx, InputInfo ii) throws QueryException {
        return (Item)FuncCall.invoke(fun, arg, true, ctx, ii);
    }

    public static Value value(XQFunction fun, Value[] arg, QueryContext ctx, InputInfo ii) throws QueryException {
        return FuncCall.invoke(fun, arg, false, ctx, ii);
    }
}

