/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.text.Normalizer;
import java.util.Arrays;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.util.Collation;
import org.basex.query.util.Err;
import org.basex.query.value.Value;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.IntSeq;
import org.basex.query.value.type.AtomType;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.XMLToken;

public final class FNStr
extends StandardFunc {
    public FNStr(StaticContext sctx, InputInfo ii, Function f, Expr ... e) {
        super(sctx, ii, f, e);
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        Expr e = this.expr[0];
        switch (this.sig) {
            case STRING_TO_CODEPOINTS: {
                return this.str2cp(e.item(ctx, this.info));
            }
        }
        return super.iter(ctx);
    }

    @Override
    public Value value(QueryContext ctx) throws QueryException {
        switch (this.sig) {
            case STRING_TO_CODEPOINTS: {
                int[] tmp = Token.cps(this.checkEStr(this.expr[0], ctx));
                long[] vals = new long[tmp.length];
                for (int i = 0; i < tmp.length; ++i) {
                    vals[i] = tmp[i];
                }
                return IntSeq.get(vals, AtomType.ITR);
            }
        }
        return super.value(ctx);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        Expr e = this.expr[0];
        switch (this.sig) {
            case CODEPOINTS_TO_STRING: {
                return this.cp2str(ctx.iter(e));
            }
            case COMPARE: {
                Collation coll = this.checkColl(this.expr.length == 3 ? this.expr[2] : null, ctx, this.sc);
                Item it1 = e.item(ctx, this.info);
                Item it2 = this.expr[1].item(ctx, this.info);
                if (it1 == null || it2 == null) {
                    return null;
                }
                return Int.get(Math.max(-1, Math.min(1, coll == null ? Token.diff(this.checkEStr(it1), this.checkEStr(it2)) : coll.compare(this.checkStr(it1), this.checkStr(it2)))));
            }
            case CODEPOINT_EQUAL: {
                Item it1 = e.item(ctx, this.info);
                Item it2 = this.expr[1].item(ctx, this.info);
                if (it1 == null || it2 == null) {
                    return null;
                }
                return Bln.get(Token.eq(this.checkEStr(it1), this.checkEStr(it2)));
            }
            case STRING_JOIN: {
                return this.strjoin(ctx);
            }
            case SUBSTRING: {
                return this.substr(ctx);
            }
            case NORMALIZE_UNICODE: {
                return this.normuni(ctx);
            }
            case UPPER_CASE: {
                return Str.get(Token.uc(this.checkEStr(e, ctx)));
            }
            case LOWER_CASE: {
                return Str.get(Token.lc(this.checkEStr(e, ctx)));
            }
            case TRANSLATE: {
                return this.trans(ctx);
            }
            case ENCODE_FOR_URI: {
                return Str.get(Token.uri(this.checkEStr(e, ctx), false));
            }
            case IRI_TO_URI: {
                return Str.get(Token.uri(this.checkEStr(e, ctx), true));
            }
            case ESCAPE_HTML_URI: {
                return Str.get(Token.escape(this.checkEStr(e, ctx)));
            }
            case CONCAT: {
                return this.concat(ctx);
            }
            case CONTAINS: {
                Collation coll = this.checkColl(this.expr.length == 3 ? this.expr[2] : null, ctx, this.sc);
                byte[] ss = this.checkEStr(e, ctx);
                byte[] sb = this.checkEStr(this.expr[1], ctx);
                return Bln.get(coll == null ? Token.contains(ss, sb) : coll.contains(ss, sb, this.info));
            }
            case STARTS_WITH: {
                Collation coll = this.checkColl(this.expr.length == 3 ? this.expr[2] : null, ctx, this.sc);
                byte[] ss = this.checkEStr(e, ctx);
                byte[] sb = this.checkEStr(this.expr[1], ctx);
                return Bln.get(coll == null ? Token.startsWith(ss, sb) : coll.startsWith(ss, sb, this.info));
            }
            case ENDS_WITH: {
                Collation coll = this.checkColl(this.expr.length == 3 ? this.expr[2] : null, ctx, this.sc);
                byte[] ss = this.checkEStr(e, ctx);
                byte[] sb = this.checkEStr(this.expr[1], ctx);
                return Bln.get(coll == null ? Token.endsWith(ss, sb) : coll.endsWith(ss, sb, this.info));
            }
            case SUBSTRING_AFTER: {
                Collation coll = this.checkColl(this.expr.length == 3 ? this.expr[2] : null, ctx, this.sc);
                byte[] ss = this.checkEStr(e, ctx);
                byte[] sb = this.checkEStr(this.expr[1], ctx);
                if (coll == null) {
                    int p = Token.indexOf(ss, sb);
                    return p == -1 ? Str.ZERO : Str.get(Token.substring(ss, p + sb.length));
                }
                return Str.get(coll.after(ss, sb, this.info));
            }
            case SUBSTRING_BEFORE: {
                Collation coll = this.checkColl(this.expr.length == 3 ? this.expr[2] : null, ctx, this.sc);
                byte[] ss = this.checkEStr(e, ctx);
                byte[] sb = this.checkEStr(this.expr[1], ctx);
                if (coll == null) {
                    int p = Token.indexOf(ss, sb);
                    return p == -1 ? Str.ZERO : Str.get(Token.substring(ss, 0, p));
                }
                return Str.get(coll.before(ss, sb, this.info));
            }
        }
        return super.item(ctx, ii);
    }

    private Str cp2str(Iter ir) throws QueryException {
        Item it;
        TokenBuilder tb = new TokenBuilder(Math.max(8, (int)ir.size()));
        while ((it = ir.next()) != null) {
            long n = this.checkItr(it);
            int i = (int)n;
            if (n < Integer.MIN_VALUE || n > Integer.MAX_VALUE || !XMLToken.valid(i)) {
                throw Err.INVCODE.get(this.info, Long.toHexString(n));
            }
            tb.add(i);
        }
        return Str.get(tb.finish());
    }

    private Iter str2cp(Item it) throws QueryException {
        if (it == null) {
            return Empty.ITER;
        }
        final byte[] s = this.checkEStr(it);
        return new Iter(){
            int l;

            @Override
            public Item next() {
                if (this.l >= s.length) {
                    return null;
                }
                int i = Token.cp(s, this.l);
                this.l += Token.cl(s, this.l);
                return Int.get(i);
            }
        };
    }

    private Str substr(QueryContext ctx) throws QueryException {
        int l;
        int s;
        byte[] str = this.checkEStr(this.expr[0], ctx);
        Item is = this.checkItem(this.expr[1], ctx);
        if (is instanceof Int) {
            s = (int)is.itr(this.info) - 1;
        } else {
            double ds = is.dbl(this.info);
            if (Double.isNaN(ds)) {
                return Str.ZERO;
            }
            s = FNStr.subPos(ds);
        }
        boolean end = this.expr.length == 3;
        boolean ascii = Token.ascii(str);
        int e = l = ascii ? str.length : Token.len(str);
        if (end) {
            Item ie = this.checkItem(this.expr[2], ctx);
            int n = e = ie instanceof Int ? (int)ie.itr(this.info) : FNStr.subPos(ie.dbl(this.info) + 1.0);
        }
        if (s < 0) {
            e += s;
            s = 0;
        }
        if (s >= (e = Math.min(l, end ? s + e : Integer.MAX_VALUE))) {
            return Str.ZERO;
        }
        if (ascii) {
            return Str.get(Token.substring(str, s, e));
        }
        int ss = s;
        int ee = e;
        int p = 0;
        l = 0;
        while (l < str.length) {
            if (p == s) {
                ss = l;
            }
            if (p == e) {
                ee = l;
            }
            l += Token.cl(str, l);
            ++p;
        }
        if (p == e) {
            ee = l;
        }
        return Str.get(Arrays.copyOfRange(str, ss, ee));
    }

    private static int subPos(double d) {
        int i = (int)d;
        return d == (double)i ? i - 1 : (int)StrictMath.floor(d - 0.5);
    }

    private Str trans(QueryContext ctx) throws QueryException {
        int[] tok = Token.cps(this.checkEStr(this.expr[0], ctx));
        int[] srch = Token.cps(this.checkStr(this.expr[1], ctx));
        int[] rep = Token.cps(this.checkStr(this.expr[2], ctx));
        TokenBuilder tmp = new TokenBuilder(tok.length);
        for (int t : tok) {
            int j = -1;
            while (++j < srch.length && t != srch[j]) {
            }
            if (j < srch.length) {
                if (j >= rep.length) continue;
                tmp.add(rep[j]);
                continue;
            }
            tmp.add(t);
        }
        return Str.get(tmp.finish());
    }

    private Str strjoin(QueryContext ctx) throws QueryException {
        Item i;
        byte[] sep = this.expr.length == 2 ? this.checkStr(this.expr[1], ctx) : Token.EMPTY;
        TokenBuilder tb = new TokenBuilder();
        Iter iter = ctx.iter(this.expr[0]);
        int c = 0;
        while ((i = iter.next()) != null) {
            tb.add(this.checkEStr(i)).add(sep);
            ++c;
        }
        byte[] v = tb.finish();
        return Str.get(c == 0 ? v : Token.substring(v, 0, v.length - sep.length));
    }

    private Str normuni(QueryContext ctx) throws QueryException {
        byte[] str = this.checkEStr(this.expr[0], ctx);
        Normalizer.Form form = Normalizer.Form.NFC;
        if (this.expr.length == 2) {
            byte[] n = Token.uc(Token.trim(this.checkStr(this.expr[1], ctx)));
            if (n.length == 0) {
                return Str.get(str);
            }
            try {
                form = Normalizer.Form.valueOf(Token.string(n));
            }
            catch (IllegalArgumentException ex) {
                throw Err.NORMUNI.get(this.info, new Object[]{n});
            }
        }
        return Token.ascii(str) ? Str.get(str) : Str.get(Normalizer.normalize(Token.string(str), form));
    }

    private Str concat(QueryContext ctx) throws QueryException {
        TokenBuilder tb = new TokenBuilder();
        for (Expr a : this.expr) {
            Item it = a.item(ctx, this.info);
            if (it == null) continue;
            tb.add(it.string(this.info));
        }
        return Str.get(tb.finish());
    }

    @Override
    public boolean has(Expr.Flag flag) {
        return flag == Expr.Flag.X30 && this.sig == Function.STRING_JOIN && this.expr.length == 1 || super.has(flag);
    }
}

