/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.util.ArrayList;
import org.basex.data.Data;
import org.basex.index.path.PathNode;
import org.basex.index.stats.StatsType;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.expr.CmpV;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.AxisIter;
import org.basex.query.iter.Iter;
import org.basex.query.iter.NodeSeqBuilder;
import org.basex.query.iter.ValueBuilder;
import org.basex.query.iter.ValueIter;
import org.basex.query.path.AxisPath;
import org.basex.query.util.Collation;
import org.basex.query.util.CollationItemSet;
import org.basex.query.util.HashItemSet;
import org.basex.query.util.ItemSet;
import org.basex.query.value.Value;
import org.basex.query.value.item.Atm;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.RangeSeq;
import org.basex.query.value.seq.Seq;
import org.basex.query.value.seq.SubSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.var.VarScope;
import org.basex.util.Array;
import org.basex.util.InputInfo;

public final class FNSeq
extends StandardFunc {
    public FNSeq(StaticContext sctx, InputInfo ii, Function f, Expr ... e) {
        super(sctx, ii, f, e);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        switch (this.sig) {
            case HEAD: {
                return this.head(ctx);
            }
        }
        return super.item(ctx, ii);
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        switch (this.sig) {
            case INDEX_OF: {
                return this.indexOf(ctx);
            }
            case DISTINCT_VALUES: {
                return this.distinctValues(ctx);
            }
            case INSERT_BEFORE: {
                return this.insertBefore(ctx);
            }
            case REVERSE: {
                return this.reverse(ctx);
            }
            case REMOVE: {
                return this.remove(ctx);
            }
            case SUBSEQUENCE: {
                return this.subseqIter(ctx);
            }
            case TAIL: {
                return this.tail(ctx);
            }
            case OUTERMOST: {
                return this.most(ctx, true);
            }
            case INNERMOST: {
                return this.most(ctx, false);
            }
        }
        return super.iter(ctx);
    }

    @Override
    public Value value(QueryContext ctx) throws QueryException {
        switch (this.sig) {
            case SUBSEQUENCE: {
                return this.subseqValue(ctx);
            }
            case TAIL: {
                Value seq = ctx.value(this.expr[0]);
                return SubSeq.get(seq, 1L, seq.size() - 1L);
            }
        }
        return super.value(ctx);
    }

    private Iter most(QueryContext ctx, boolean outer) throws QueryException {
        Item it;
        Iter iter = this.expr[0].iter(ctx);
        NodeSeqBuilder nc = new NodeSeqBuilder().check();
        while ((it = iter.next()) != null) {
            nc.add(this.checkNode(it));
        }
        int len = (int)nc.size();
        if (len < 2) {
            return nc;
        }
        if (nc.dbnodes()) {
            DBNode fst = (DBNode)nc.get(outer ? 0 : len - 1);
            Data data = fst.data;
            ANode[] nodes = (ANode[])nc.nodes.clone();
            if (outer) {
                nc.size(0);
                DBNode dummy = new DBNode(fst.data);
                NodeSeqBuilder src = new NodeSeqBuilder(nodes, len);
                int next = 0;
                while (next < len) {
                    DBNode nd = (DBNode)nodes[next];
                    dummy.pre = nd.pre + data.size(nd.pre, data.kind(nd.pre));
                    int p = src.binarySearch(dummy, next + 1, len - next - 1);
                    nc.add(nd);
                    next = p < 0 ? -p - 1 : p;
                }
            } else {
                nc.nodes[0] = fst;
                nc.size(1);
                int before = fst.pre;
                int i = len - 1;
                while (i-- != 0) {
                    DBNode nd = (DBNode)nodes[i];
                    if (nd.pre + data.size(nd.pre, data.kind(nd.pre)) > before) continue;
                    nc.add(nd);
                    before = nd.pre;
                }
                Array.reverse(nc.nodes, 0, (int)nc.size());
            }
            return nc;
        }
        NodeSeqBuilder out = new NodeSeqBuilder(new ANode[len], 0);
        block3: for (int i = 0; i < len; ++i) {
            ANode a;
            AxisIter ax;
            ANode nd = nc.nodes[i];
            AxisIter axisIter = ax = outer ? nd.ancestor() : nd.descendant();
            while ((a = ax.next()) != null) {
                if (nc.indexOf(a, false) == -1) continue;
                continue block3;
            }
            out.add(nc.nodes[i]);
        }
        return out;
    }

    @Override
    protected Expr opt(QueryContext ctx, VarScope scp) throws QueryException {
        if (this.sig == Function.INDEX_OF || this.sig == Function.INSERT_BEFORE) {
            return this;
        }
        SeqType st = this.expr[0].type();
        Type t = st.type;
        if (this.sig == Function.DISTINCT_VALUES && this.expr.length == 1) {
            this.type = t.isNode() ? SeqType.get((Type)AtomType.ATM, st.occ) : st;
            return this.cmpDist(ctx);
        }
        SeqType.Occ o = SeqType.Occ.ZERO_MORE;
        if (this.sig == Function.SUBSEQUENCE && st.one()) {
            o = SeqType.Occ.ZERO_ONE;
        } else if (this.sig == Function.HEAD) {
            o = SeqType.Occ.ZERO_ONE;
        }
        this.type = SeqType.get(t, o);
        return this;
    }

    private Expr cmpDist(QueryContext ctx) throws QueryException {
        if (!(this.expr[0] instanceof AxisPath)) {
            return this;
        }
        ArrayList<PathNode> nodes = ((AxisPath)this.expr[0]).nodes(ctx);
        if (nodes == null) {
            return this;
        }
        HashItemSet is = new HashItemSet();
        for (PathNode pn : nodes) {
            if (pn.kind == 1) {
                if (!pn.stats.isLeaf()) {
                    return this;
                }
                for (PathNode n : pn.ch) {
                    if (n.kind != 2) continue;
                    pn = n;
                }
            }
            if (pn.kind != 2 && pn.kind != 3) {
                return this;
            }
            if (pn.stats.type != StatsType.CATEGORY) {
                return this;
            }
            for (byte[] c : pn.stats.cats) {
                is.put(new Atm(c), this.info);
            }
        }
        ValueBuilder vb = new ValueBuilder(is.size());
        for (Item i : is) {
            vb.add(i);
        }
        return vb.value();
    }

    private Item head(QueryContext ctx) throws QueryException {
        Expr e = this.expr[0];
        return e.type().zeroOrOne() ? e.item(ctx, this.info) : e.iter(ctx).next();
    }

    private Iter tail(QueryContext ctx) throws QueryException {
        Expr e = this.expr[0];
        if (e.type().zeroOrOne()) {
            return Empty.ITER;
        }
        final Iter ir = e.iter(ctx);
        if (ir instanceof ValueIter) {
            Value val = ir.value();
            return SubSeq.get(val, 1L, val.size() - 1L).iter();
        }
        if (ir.next() == null) {
            return Empty.ITER;
        }
        return new Iter(){

            @Override
            public Item next() throws QueryException {
                return ir.next();
            }
        };
    }

    private Iter indexOf(final QueryContext ctx) throws QueryException {
        final Item it = this.checkItem(this.expr[1], ctx);
        final Collation coll = this.checkColl(this.expr.length == 3 ? this.expr[2] : null, ctx, this.sc);
        return new Iter(){
            final Iter ir;
            int c;
            {
                this.ir = FNSeq.this.expr[0].iter(ctx);
            }

            @Override
            public Item next() throws QueryException {
                Item i;
                do {
                    if ((i = this.ir.next()) == null) {
                        return null;
                    }
                    ++this.c;
                } while (!i.comparable(it) || !CmpV.OpV.EQ.eval(i, it, coll, FNSeq.this.info));
                return Int.get(this.c);
            }
        };
    }

    private Iter distinctValues(final QueryContext ctx) throws QueryException {
        final Collation coll = this.checkColl(this.expr.length == 2 ? this.expr[1] : null, ctx, this.sc);
        if (this.expr[0] instanceof RangeSeq) {
            return this.expr[0].iter(ctx);
        }
        return new Iter(){
            final ItemSet set;
            final Iter ir;
            {
                this.set = coll == null ? new HashItemSet() : new CollationItemSet(coll);
                this.ir = FNSeq.this.expr[0].iter(ctx);
            }

            @Override
            public Item next() throws QueryException {
                Item i;
                do {
                    if ((i = this.ir.next()) == null) {
                        return null;
                    }
                    ctx.checkStop();
                } while (!this.set.add(i = StandardFunc.atom(i, FNSeq.this.info), FNSeq.this.info));
                return i;
            }
        };
    }

    private Iter insertBefore(final QueryContext ctx) throws QueryException {
        return new Iter(){
            final long pos;
            final Iter iter;
            final Iter ins;
            long p;
            boolean last;
            {
                this.pos = Math.max(1L, FNSeq.this.checkItr(FNSeq.this.expr[1], ctx));
                this.iter = FNSeq.this.expr[0].iter(ctx);
                this.ins = FNSeq.this.expr[2].iter(ctx);
                this.p = this.pos;
            }

            @Override
            public Item next() throws QueryException {
                if (this.last) {
                    return this.p > 0L ? this.ins.next() : null;
                }
                boolean sub = this.p == 0L || --this.p == 0L;
                Item i = (sub ? this.ins : this.iter).next();
                if (i != null) {
                    return i;
                }
                if (sub) {
                    --this.p;
                } else {
                    this.last = true;
                }
                return this.next();
            }
        };
    }

    private Iter remove(final QueryContext ctx) throws QueryException {
        return new Iter(){
            final long pos;
            final Iter iter;
            long c;
            {
                this.pos = FNSeq.this.checkItr(FNSeq.this.expr[1], ctx);
                this.iter = FNSeq.this.expr[0].iter(ctx);
            }

            @Override
            public Item next() throws QueryException {
                return ++this.c != this.pos || this.iter.next() != null ? this.iter.next() : null;
            }
        };
    }

    private Iter subseqIter(QueryContext ctx) throws QueryException {
        long e;
        boolean li;
        double ds = this.checkDbl(this.expr[1], ctx);
        if (Double.isNaN(ds)) {
            return Empty.ITER;
        }
        final long s = StrictMath.round(ds);
        boolean si = s == Long.MIN_VALUE;
        long l = Long.MAX_VALUE;
        if (this.expr.length > 2) {
            double dl = this.checkDbl(this.expr[2], ctx);
            if (Double.isNaN(dl)) {
                return Empty.ITER;
            }
            if (si && dl == Double.POSITIVE_INFINITY) {
                return Empty.ITER;
            }
            l = StrictMath.round(dl);
        }
        boolean bl = li = l == Long.MAX_VALUE;
        if (si) {
            return li ? this.expr[0].iter(ctx) : Empty.ITER;
        }
        final Iter iter = ctx.iter(this.expr[0]);
        if (iter instanceof ValueIter) {
            Value val = iter.value();
            long rs = val.size();
            long from = Math.max(1L, s) - 1L;
            long len = Math.min(rs - from, l + Math.min(0L, s - 1L));
            return SubSeq.get(val, from, len).iter();
        }
        final long max = iter.size();
        long l2 = e = li ? l : s + l;
        if (max != -1L) {
            return new Iter(){
                final long m;
                long c;
                {
                    this.m = Math.min(e, max + 1L);
                    this.c = Math.max(1L, s);
                }

                @Override
                public Item next() throws QueryException {
                    return this.c < this.m ? iter.get(this.c++ - 1L) : null;
                }

                @Override
                public Item get(long i) throws QueryException {
                    return iter.get(this.c + i - 1L);
                }

                @Override
                public long size() {
                    return Math.max(0L, this.m - this.c);
                }

                @Override
                public boolean reset() {
                    this.c = Math.max(1L, s);
                    return true;
                }
            };
        }
        return new Iter(){
            long c;

            @Override
            public Item next() throws QueryException {
                Item i;
                do {
                    if ((i = iter.next()) != null && ++this.c < e) continue;
                    return null;
                } while (this.c < s);
                return i;
            }
        };
    }

    private Value subseqValue(QueryContext ctx) throws QueryException {
        Item i;
        boolean linf;
        double dstart = this.checkDbl(this.expr[1], ctx);
        if (Double.isNaN(dstart)) {
            return Empty.SEQ;
        }
        long start = StrictMath.round(dstart);
        boolean sinf = start == Long.MIN_VALUE;
        long length = Long.MAX_VALUE;
        if (this.expr.length > 2) {
            double dlength = this.checkDbl(this.expr[2], ctx);
            if (Double.isNaN(dlength)) {
                return Empty.SEQ;
            }
            if (sinf && dlength == Double.POSITIVE_INFINITY) {
                return Empty.SEQ;
            }
            length = StrictMath.round(dlength);
        }
        boolean bl = linf = length == Long.MAX_VALUE;
        if (sinf) {
            return linf ? this.expr[0].value(ctx) : Empty.SEQ;
        }
        Iter iter = ctx.iter(this.expr[0]);
        if (iter instanceof ValueIter) {
            Value val = iter.value();
            long rs = val.size();
            long from = Math.max(1L, start) - 1L;
            long len = Math.min(rs - from, length + Math.min(0L, start - 1L));
            return SubSeq.get(val, from, len);
        }
        long max = iter.size();
        if (max >= 0L) {
            long from = Math.max(1L, start) - 1L;
            long len = Math.min(max - from, length + Math.min(0L, start - 1L));
            if (from >= max || len <= 0L) {
                return Empty.SEQ;
            }
            ValueBuilder vb = new ValueBuilder(Math.max((int)len, 1));
            for (long i2 = 0L; i2 < len; ++i2) {
                vb.add(iter.get(from + i2));
            }
            return vb.value();
        }
        long e = linf ? length : start + length;
        ValueBuilder build = new ValueBuilder();
        int c = 1;
        while ((i = iter.next()) != null) {
            if ((long)c >= e) {
                iter.reset();
                break;
            }
            if ((long)c >= start) {
                build.add(i);
            }
            ++c;
        }
        return build.value();
    }

    private Iter reverse(QueryContext ctx) throws QueryException {
        if (this.expr[0] instanceof Seq) {
            return ((Seq)this.expr[0]).reverse().iter();
        }
        final Iter iter = ctx.iter(this.expr[0]);
        final long s = iter.size();
        if (s == -1L) {
            Item it;
            ValueBuilder vb = new ValueBuilder(Math.max((int)this.expr[0].size(), 1));
            while ((it = iter.next()) != null) {
                vb.add(it);
            }
            Array.reverse(vb.items(), 0, (int)vb.size());
            return vb;
        }
        return s == 0L ? Empty.ITER : (s == 1L ? iter : new Iter(){
            long c;
            {
                this.c = s;
            }

            @Override
            public Item next() throws QueryException {
                return --this.c >= 0L ? iter.get(this.c) : null;
            }

            @Override
            public Item get(long i) throws QueryException {
                return iter.get(s - i - 1L);
            }

            @Override
            public long size() {
                return s;
            }

            @Override
            public boolean reset() {
                this.c = s;
                return iter.reset();
            }
        });
    }
}

