/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import org.basex.io.IOFile;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.iter.NodeSeqBuilder;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.pkg.Package;
import org.basex.query.util.pkg.RepoManager;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.FElem;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class FNRepo
extends StandardFunc {
    private static final String PACKAGE = "package";
    private static final String NAME = "name";
    private static final String TYPE = "type";
    private static final String VERSION = "version";

    public FNRepo(StaticContext sctx, InputInfo ii, Function f, Expr ... e) {
        super(sctx, ii, f, e);
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        switch (this.sig) {
            case _REPO_LIST: {
                return FNRepo.list(ctx);
            }
        }
        return super.iter(ctx);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        this.checkCreate(ctx);
        RepoManager rm = new RepoManager(ctx.context, ii);
        String pkg = this.expr.length == 0 ? null : Token.string(this.checkStr(this.expr[0], ctx));
        switch (this.sig) {
            case _REPO_INSTALL: {
                rm.install(pkg);
                return null;
            }
            case _REPO_DELETE: {
                rm.delete(pkg);
                return null;
            }
        }
        return super.item(ctx, ii);
    }

    private static Iter list(QueryContext ctx) {
        NodeSeqBuilder cache = new NodeSeqBuilder();
        for (byte[] p : ctx.context.repo.pkgDict()) {
            if (p == null) continue;
            FElem elem = new FElem(PACKAGE);
            elem.add(NAME, Package.name(p));
            elem.add(VERSION, Package.version(p));
            elem.add(TYPE, "EXPath");
            cache.add(elem);
        }
        for (IOFile dir : ctx.context.repo.path().children()) {
            if (dir.name().indexOf(45) != -1) continue;
            for (String s : dir.descendants()) {
                FElem elem = new FElem(PACKAGE);
                elem.add(NAME, dir.name() + '.' + s.replaceAll("\\..*", "").replace('/', '.'));
                elem.add(TYPE, "Internal");
                cache.add(elem);
            }
        }
        return cache;
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return visitor.lock("%REPO") && super.accept(visitor);
    }
}

