/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryIOException;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.iter.ValueBuilder;
import org.basex.query.iter.ValueIter;
import org.basex.query.util.Err;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;

public final class FNInfo
extends StandardFunc {
    public FNInfo(StaticContext sctx, InputInfo ii, Function f, Expr ... e) {
        super(sctx, ii, f, e);
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        switch (this.sig) {
            case ERROR: {
                return this.error(ctx);
            }
            case TRACE: {
                return this.trace(ctx);
            }
            case AVAILABLE_ENVIRONMENT_VARIABLES: {
                return FNInfo.avlEnvVars();
            }
        }
        return super.iter(ctx);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        switch (this.sig) {
            case ENVIRONMENT_VARIABLE: {
                return this.envVar(ctx);
            }
        }
        return super.item(ctx, ii);
    }

    @Override
    protected Expr opt(QueryContext ctx, VarScope scp) {
        if (this.sig == Function.TRACE) {
            this.type = this.expr[0].type();
        }
        return this;
    }

    private Iter error(QueryContext ctx) throws QueryException {
        int al = this.expr.length;
        if (al == 0) {
            throw Err.FUNERR1.get(this.info, new Object[0]);
        }
        QNm name = Err.FUNERR1.qname();
        String msg = Err.FUNERR1.desc;
        Item it = this.expr[0].item(ctx, this.info);
        if (it == null) {
            if (al == 1) {
                throw Err.INVEMPTY.get(this.info, this.description());
            }
        } else {
            name = this.checkQNm(it, ctx, this.sc);
        }
        if (al > 1) {
            msg = Token.string(this.checkEStr(this.expr[1], ctx));
        }
        Value val = al > 2 ? ctx.value(this.expr[2]) : null;
        throw new QueryException(this.info, name, msg, new Object[0]).value(val);
    }

    private Iter trace(final QueryContext ctx) throws QueryException {
        return new Iter(){
            final Iter ir;
            final byte[] label;
            boolean empty;
            {
                this.ir = FNInfo.this.expr[0].iter(ctx);
                this.label = FNInfo.this.checkStr(FNInfo.this.expr[1], ctx);
                this.empty = true;
            }

            @Override
            public Item next() throws QueryException {
                Item it = this.ir.next();
                if (it != null) {
                    FNInfo.dump(it, this.label, FNInfo.this.info, ctx);
                    this.empty = false;
                } else if (this.empty) {
                    FNInfo.dump(null, this.label, FNInfo.this.info, ctx);
                }
                return it;
            }
        };
    }

    private static ValueIter avlEnvVars() {
        ValueBuilder vb = new ValueBuilder();
        for (String k : System.getenv().keySet()) {
            vb.add(Str.get(k.toString()));
        }
        return vb;
    }

    private Str envVar(QueryContext ctx) throws QueryException {
        String e = System.getenv(Token.string(this.checkStr(this.expr[0], ctx)));
        return e != null ? Str.get(e) : null;
    }

    public static void dump(Item it, byte[] label, InputInfo info, QueryContext ctx) throws QueryException {
        try {
            byte[] value = it == null ? Token.token(SeqType.EMP.toString()) : (it.type == NodeType.ATT || it.type == NodeType.NSP ? Token.token(it.toString()) : it.serialize().toArray());
            FNInfo.dump(value, label, ctx);
        }
        catch (QueryIOException ex) {
            throw ex.getCause(info);
        }
    }

    public static void dump(byte[] value, byte[] label, QueryContext ctx) {
        TokenBuilder tb = new TokenBuilder();
        if (label != null) {
            tb.add(label);
        }
        tb.add(value);
        String info = tb.toString();
        if (ctx.listen != null || ctx.context.listener != null) {
            ctx.evalInfo(info);
            if (ctx.listen != null) {
                ctx.listen.info(info);
            }
        } else {
            Util.errln(info, new Object[0]);
        }
    }

    public static FNInfo error(QueryException ex, SeqType tp) {
        FNInfo err = new FNInfo(null, ex.info(), Function.ERROR, ex.qname(), Str.get(ex.getLocalizedMessage()));
        err.type = tp;
        return err;
    }
}

