/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.util.Err;
import org.basex.query.util.format.DecFormatter;
import org.basex.query.util.format.FormatParser;
import org.basex.query.util.format.Formatter;
import org.basex.query.util.format.IntFormat;
import org.basex.query.value.item.ADate;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.hash.TokenObjMap;

public final class FNFormat
extends StandardFunc {
    private final TokenObjMap<FormatParser> formats = new TokenObjMap();

    public FNFormat(StaticContext sctx, InputInfo ii, Function f, Expr ... e) {
        super(sctx, ii, f, e);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        switch (this.sig) {
            case FORMAT_INTEGER: {
                return this.formatInteger(ctx);
            }
            case FORMAT_NUMBER: {
                return this.formatNumber(ctx);
            }
            case FORMAT_DATETIME: {
                return this.formatDate(AtomType.DTM, ctx);
            }
            case FORMAT_DATE: {
                return this.formatDate(AtomType.DAT, ctx);
            }
            case FORMAT_TIME: {
                return this.formatDate(AtomType.TIM, ctx);
            }
        }
        return super.item(ctx, ii);
    }

    private Str formatInteger(QueryContext ctx) throws QueryException {
        byte[] pic = this.checkStr(this.expr[1], ctx);
        byte[] lng = this.expr.length == 2 ? Token.EMPTY : this.checkStr(this.expr[2], ctx);
        Item it = this.expr[0].item(ctx, this.info);
        if (it == null) {
            return Str.ZERO;
        }
        long num = this.checkItr(it);
        FormatParser fp = this.formats.get(pic);
        if (fp == null) {
            fp = new IntFormat(pic, this.info);
            this.formats.put(pic, fp);
        }
        return Str.get(Formatter.get(lng).formatInt(num, fp));
    }

    private Str formatNumber(QueryContext ctx) throws QueryException {
        Item it = this.expr[0].item(ctx, this.info);
        if (it == null) {
            it = Dbl.NAN;
        } else if (!it.type.isNumberOrUntyped()) {
            throw Err.numberError(this, it);
        }
        byte[] pic = this.checkStr(this.expr[1], ctx);
        QNm frm = this.expr.length == 3 ? new QNm(Token.trim(this.checkEStr(this.expr[2], ctx)), this.sc) : new QNm(Token.EMPTY);
        DecFormatter df = this.sc.decFormats.get(frm.id());
        if (df == null) {
            throw Err.FORMNUM.get(this.info, frm);
        }
        return Str.get(df.format(this.info, it, pic));
    }

    private Item formatDate(Type tp, QueryContext ctx) throws QueryException {
        byte[] plc;
        Item it = this.expr[0].item(ctx, this.info);
        byte[] pic = this.checkEStr(this.expr[1], ctx);
        byte[] lng = this.expr.length == 5 ? this.checkEStr(this.expr[2], ctx) : Token.EMPTY;
        byte[] cal = this.expr.length == 5 ? this.checkEStr(this.expr[3], ctx) : Token.EMPTY;
        byte[] byArray = plc = this.expr.length == 5 ? this.checkEStr(this.expr[4], ctx) : Token.EMPTY;
        if (it == null) {
            return null;
        }
        ADate date = (ADate)this.checkType(it, tp);
        Formatter form = Formatter.get(lng);
        return Str.get(form.formatDate(date, lng, pic, cal, plc, this.info));
    }
}

